﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="LessonTime.aspx.cs" Inherits="MTCUN.Mobile.Class.LessonTime"
    Title="排课信息-教务" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Register Src="../../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<%@ Register Src="../../UserCol/Ann.ascx" TagName="Ann" TagPrefix="uc3" %>
<%@ Register Src="../User_Col/col_Header.ascx" TagName="col_Header" TagPrefix="uc4" %>
<%@ Register Src="../User_Col/col_ClassControlPanel.ascx" TagName="col_ClassControlPanel" TagPrefix="uc5" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />

    <script type="text/javascript">
        function OpenAuto() {
            if (setContent.style.display == 'none') {
                setContent.style.display = 'block';
                setControl.innerHTML = '▲自动排课';
                __mt__setSearchCookie(1);
            }
            else {
                setContent.style.display = 'none';
                setControl.innerHTML = '▼自动排课';
                __mt__setSearchCookie(0);
            }
        }

        function defaultSearchState() {
            var num = __mt__getSearchCookie();
            if (num == 1) {
                setContent.style.display = 'block';
                setControl.innerHTML = '▲自动排课';
            }
            else {
                setContent.style.display = 'none';
                setControl.innerHTML = '▼自动排课';
            }
        }
    </script>

    <style type="text/css">
        .ld {
            margin: 0px;
            padding: 0px;
            list-style: none;
        }

            .ld li {
                display: block;
                margin: 2px;
            }

                .ld li span {
                    display: inline-block;
                }
    </style>
</head>
<body onload="defaultSearchState();">
    <form id="form1" runat="server">
        <uc3:Ann ID="Ann1" runat="server" />
        <uc4:col_Header ID="col_Header1" runat="server" />
        <div id="web_page_contents">
            <div class="biao_zhun_suo_jin">
                <div class="container">

                    <uc5:col_ClassControlPanel ID="col_ClassControlPanel1" runat="server" />

                    <div class="mt-control">
                        <ul class="mt-listitems">
                            <li>
                                <asp:HyperLink ID="hlkAdd" runat="server" CssClass="btn btn-success">增加上课</asp:HyperLink>
                            </li>
                            <li>
                                <asp:LinkButton ID="lbnClear" runat="server" CssClass="btn btn-default" OnClick="lbnClear_Click" OnClientClick="return confirm('执行此操作，将删除所有未上课的排课信息，您确定要这么做？');">清除未上课</asp:LinkButton>
                            </li>
                            <li>
                                <div id="setControl" onclick="OpenAuto()" class="btn btn-warning">
                                    ▼自动排课
                                </div>
                            </li>
                        </ul>
                        <div id="setContent" style="display: none">

                            <div class="kuai">
                                <br />
                                <h1>班级概要</h1>
                                <asp:FormView ID="fvClass" runat="server">
                                    <ItemTemplate>
                                        <table class="mt-table-m">
                                            <tr>
                                                <td>班号：<%#Eval("ClassID")%></td>
                                            </tr>
                                            <tr>
                                                <td>班级名称：<%#Eval("ClassName")%></td>
                                            </tr>
                                            <tr>
                                                <td>上课规律：<%#Eval("TimeRule")%></td>
                                            </tr>
                                            <tr>
                                                <td>开课时间：<%#Eval("StartDate","{0:d}")%></td>
                                            </tr>
                                            <tr>
                                                <td>总课时：<%#Eval("Lessons","{0:0.##}")%></td>
                                            </tr>
                                            <tr>
                                                <td>每课分钟：<%#Eval("LessonMinute")%></td>
                                            </tr>

                                        </table>
                                    </ItemTemplate>
                                </asp:FormView>
                                <br />
                                <h1>排课参数</h1>
                                <table class="mt-table-m">
                                    <tr>
                                        <td colspan="2">
                                            <table>
                                                <tr>
                                                    <td>
                                                        <ul class="ld">
                                                            <li><span>周期：</span><span>
                                                                <asp:DropDownList ID="ddlWeek" runat="server" Width="80px">
                                                                    <asp:ListItem Text="周日" Value="0"></asp:ListItem>
                                                                    <asp:ListItem Text="周一" Value="1"></asp:ListItem>
                                                                    <asp:ListItem Text="周二" Value="2"></asp:ListItem>
                                                                    <asp:ListItem Text="周三" Value="3"></asp:ListItem>
                                                                    <asp:ListItem Text="周四" Value="4"></asp:ListItem>
                                                                    <asp:ListItem Text="周五" Value="5"></asp:ListItem>
                                                                    <asp:ListItem Text="周六" Value="6"></asp:ListItem>
                                                                    <asp:ListItem Text="全周" Value="-1"></asp:ListItem>
                                                                </asp:DropDownList></span></li>
                                                            <li><span>时段：</span><span><asp:DropDownList ID="ddlTimes" runat="server">
                                                            </asp:DropDownList></span>
                                                                <span>
                                                                    <asp:DropDownList ID="ddlGroupType" runat="server" DataTextField="PeriodTimeGroupName"
                                                                        DataValueField="PeriodTimeGroupID" AutoPostBack="True" OnSelectedIndexChanged="ddlGroupType_SelectedIndexChanged">
                                                                    </asp:DropDownList></span></li>
                                                            <li><span>讲师：</span><span><asp:DropDownList runat="server" ID="ddlTeacher" DataTextField="TrueName" DataValueField="UserID">
                                                            </asp:DropDownList></span><span>
                                                                <uc1:SimpleCode ID="SimpleCode1" runat="server" UsersControlID="ddlTeacher" />
                                                            </span>
                                                            </li>
                                                            <li><span>助教：</span><span><asp:DropDownList runat="server" ID="ddlAssistant" DataTextField="TrueName" DataValueField="UserID">
                                                            </asp:DropDownList></span><span>
                                                                <uc1:SimpleCode ID="SimpleCode2" runat="server" UsersControlID="ddlAssistant" />
                                                            </span>
                                                            </li>
                                                            <li><span>教室：</span><span><asp:DropDownList ID="ddlClassroom" runat="server" DataTextField="ClassroomName"
                                                                DataValueField="ClassroomID">
                                                            </asp:DropDownList></span></li>
                                                            <li><span>课题：</span><span><asp:TextBox runat="server" ID="tbxSubject"></asp:TextBox></span></li>
                                                            <li>
                                                                <asp:Button ID="btnAddTime" runat="server" CssClass="btn btn-warning" CausesValidation="False" OnClick="btnAddTime_Click"
                                                                    Text="添加" />
                                                            </li>
                                                        </ul>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="border: 0px">
                                                        <ul class="striking">
                                                            <li style="min-width: 60%">

                                                                <asp:Repeater ID="repSmallBlock" runat="server" OnItemCommand="repSmallBlock_ItemCommand"
                                                                    OnItemDataBound="repSmallBlock_ItemDataBound">
                                                                    <ItemTemplate>

                                                                        <asp:Panel ID="plItem" runat="server" CssClass="kuai">
                                                                            <table class="mt-table-m">
                                                                                <tr>
                                                                                    <td style="width: 50px">周期：</td>
                                                                                    <td><%# Rs.Items.GetWeekText(Eval("Week")) %></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>时段：</td>
                                                                                    <td><%# Eval("PeriodTimeName") %></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>分钟：</td>
                                                                                    <td><%# Eval("Minute") %></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>课时：</td>
                                                                                    <td><%# Eval("Lessons") %></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>讲师：</td>
                                                                                    <td><%# Eval("TeacherName") %></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>助教：</td>
                                                                                    <td><%# Eval("AssistantName") %></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>教室：</td>
                                                                                    <td><%# Eval("ClassroomName") %></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>课题：</td>
                                                                                    <td><%# Eval("Subject") %></td>
                                                                                </tr>
                                                                            </table>
                                                                            <table class="mt-table-m">
                                                                                <tr>
                                                                                    <td>
                                                                                        <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete"></asp:LinkButton>
                                                                                    </td>
                                                                                    <td>
                                                                                        <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" CausesValidation="False" CommandName="Edit" Text="编辑"></asp:LinkButton>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>

                                                                        </asp:Panel>
                                                                        <asp:Panel ID="plEdit" runat="server" CssClass="kuai edit_kuai">
                                                                            <table class="mt-table-m">
                                                                                <tr>
                                                                                    <td style="width: 50px">周期：</td>
                                                                                    <td><%# Rs.Items.GetWeekText(Eval("Week")) %></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>时段：</td>
                                                                                    <td><%# Eval("PeriodTimeName") %></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>分钟：</td>
                                                                                    <td><%# Eval("Minute") %></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>课时：</td>
                                                                                    <td>
                                                                                        <asp:TextBox ID="tbxLessons" runat="server" Text='<%# Eval("Lessons") %>'></asp:TextBox></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>讲师：</td>
                                                                                    <td>
                                                                                        <asp:DropDownList runat="server" ID="ddlTeacher" SelectedValue='<%# Eval("TeacherID") %>'
                                                                                            DataSource='<%# swq.Cache.GetUsers() %>' DataTextField="TrueName" DataValueField="UserID">
                                                                                        </asp:DropDownList></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>助教：</td>
                                                                                    <td>
                                                                                        <asp:DropDownList runat="server" ID="ddlAssistant" SelectedValue='<%# Eval("AssistantID") %>'
                                                                                            DataSource='<%# swq.Cache.Fill(swq.Cache.GetUsers()," ") %>' DataTextField="TrueName"
                                                                                            DataValueField="UserID">
                                                                                        </asp:DropDownList></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>教室：</td>
                                                                                    <td>
                                                                                        <asp:DropDownList runat="server" ID="ddlClassroom" SelectedValue='<%# Eval("ClassroomID") %>'
                                                                                            DataSource='<%# swq.Cache.GetClassroom() %>' DataTextField="ClassroomName" DataValueField="ClassroomID">
                                                                                        </asp:DropDownList></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <td>课题：</td>
                                                                                    <td>
                                                                                        <asp:TextBox runat="server" ID="tbxSubject" Text='<%# Eval("Subject") %>'></asp:TextBox></td>
                                                                                </tr>
                                                                            </table>
                                                                            <table class="mt-table-m">
                                                                                <tr>
                                                                                    <td>
                                                                                        <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" CausesValidation="True" CommandName="Update" Text="更新"></asp:LinkButton>
                                                                                    </td>
                                                                                    <td>
                                                                                        <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" CausesValidation="False" CommandName="Cancel" Text="取消"></asp:LinkButton>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </asp:Panel>

                                                                    </ItemTemplate>
                                                                </asp:Repeater>
                                                            </li>
                                                        </ul>
                                                    </td>
                                                </tr>
                                            </table>

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>起始日：
                                        </td>
                                        <td>
                                            <asp:TextBox ID="tbxStartDate" runat="server"></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>可排数：
                                        </td>
                                        <td>
                                            <asp:DropDownList ID="ddlLessons" runat="server">
                                            </asp:DropDownList>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>截止日：</td>
                                        <td>
                                            <asp:TextBox ID="tbxEndDate" runat="server"></asp:TextBox>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>完成度：
                                        </td>
                                        <td>
                                            <uc2:Progress ID="Progress1" runat="server" Text="课时" Width="40%" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>&nbsp;
                                        </td>
                                        <td>
                                            <asp:Button ID="btnAutoAddLessonTime" runat="server" CssClass="btn btn-success" OnClick="btnAutoAddLessonTime_Click"
                                                Text="自动排课" />
                                        </td>
                                    </tr>
                                </table>

                            </div>

                        </div>
                    </div>

                    <div class="main">
                        <asp:Repeater ID="repBlock" runat="server" OnItemCommand="repBlock_ItemCommand"
                            OnItemDataBound="repBlock_ItemDataBound">
                            <ItemTemplate>
                                <asp:Panel ID="plItem" runat="server" CssClass="kuai">

                                    <table class="mt-table-m">
                                        <tr>
                                            <td style="width: 80px"><%# (int)Eval("LeStateID") == 0 ? "<span class ='label label-default'>未上课</span>": "<span class ='label label-success'>已上课</span>"%></td>
                                            <td style="width: auto"></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">课题：</td>
                                            <td style="width: auto"><%#Eval("Subject")%></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">上课日期：</td>
                                            <td style="width: auto">
                                                <asp:HyperLink runat="server" ID="hlkClassInfo" Text='<%#Eval("StartDate","{0:d}")%>'
                                                    NavigateUrl='<%# string.Format("Attend.aspx?ClassID={0}&LessonTimeID={1}&GetUrl={2}",Eval("ClassID"),Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                                                <span style="color: Red">[<%#GetWeek(Eval("StartDate"))%>]</span></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">上课时段：</td>
                                            <td style="width: auto">
                                                <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),EndDate(Eval("EndDate")))%>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">类型：</td>
                                            <td style="width: auto">
                                                <asp:Label runat="server" ID="labLessonType" Text='<%#(int)Eval("LessonType") == 1 ? "正常" : "补课"%>'></asp:Label><asp:Label
                                                    runat="server" ID="labPlace" ForeColor="Red" Text='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)" : "(本)") : ""%>'
                                                    ToolTip='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)表示在他班补课" : "(本)表示在本班补课") : ""%>'></asp:Label></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">课时：</td>
                                            <td style="width: auto"><%#Eval("Lessons","{0:0.##}")%></td>
                                        </tr>

                                        <tr>
                                            <td style="width: auto">讲师：</td>
                                            <td style="width: auto">
                                                <%#Eval("TeacherName")%></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">助教：</td>
                                            <td style="width: auto">
                                                <%#Eval("AssistantName")%></td>
                                        </tr>
                                        <tr>
                                            <td>教室：</td>
                                            <td>
                                                <%#Eval("ClassroomName") %>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">出勤：</td>
                                            <td style="width: auto">实到:<%#Eval("FactCount")%>
                                    旷课:<%#Eval("TruancyCount")%>
                                    请假:<%#Eval("LeaveCount")%></td>
                                        </tr>
                                    </table>

                                    <table class="mt-table-m">
                                        <tr>
                                            <td>
                                                <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("LessonTimeID")%>'
                                                    OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                            </td>
                                            <td>
                                                <asp:HyperLink runat="server" CssClass="btn btn-default" NavigateUrl='<%#string.Format("PostLessonTime.aspx?LessonTimeID={0}&ClassID={1}&GetUrl={2}",Eval("LessonTimeID"),Eval("ClassID"),swq.Web.PathAndQuery())%>'
                                                    ID="hlkEdit" Text="编辑" />
                                            </td>
                                            <td>
                                                <asp:HyperLink runat="server" CssClass="btn btn-success" ID="hlkAttend" Text="点名" NavigateUrl='<%# string.Format("Attend.aspx?ClassID={0}&LessonTimeID={1}&GetUrl={2}",Eval("ClassID"),Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                                            </td>
                                        </tr>
                                    </table>

                                </asp:Panel>

                            </ItemTemplate>
                        </asp:Repeater>
                    </div>

                    <div class="pager_button">
                        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
                    </div>


                    <div class="row mt-button">
                        <div class="col-lg-12">
                            <p>
                                <label class="btn btn-success btn-block" id="__mt_labBack" runat="server" onclick="back(this)">
                                    返回
                                </label>
                            </p>
                        </div>
                    </div>

                    <div class="alert alert-info mt-remark">
                        <b>注意事项：</b><br />
                        1、点击“清除未上课”仅删除未上课的排课，不影响已考勤的排课。<br />
                    </div>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
