﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TodayLessons.aspx.cs" Inherits="MTCUN.Mobile.Class.TodayLessons"
    Title="今日上课-教务" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../User_Col/col_Header.ascx" TagName="col_Header" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />
</head>
<body onload="dspCurDT()">
    <script type="text/javascript">

        function Prints() {
            var StuClassID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        StuClassID += "," + e.value;
                    }
                }
            }

            if (StuClassID.length > 0) {
                StuClassID = StuClassID.substring(1, StuClassID.length);
            }
        }

        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }
    </script>
    <form id="form1" runat="server">
        <uc1:col_Header ID="col_Header1" runat="server" />

        <div id="web_page_contents">
            <div class="search biao_zhun_suo_jin">
                <div class="tool_Search">
                    校区：<asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                    </asp:DropDownList>
                    日期：<asp:TextBox ID="tbxStartDate" runat="server"></asp:TextBox>
                    <label class="lab_button">
                        <asp:Button ID="btnPost" runat="server" OnClick="btnPost_Click" Text="搜索" />
                    </label>
                </div>
                <div class="both">
                </div>
                <div class="tool_ControlPanel">
                    <table cellpadding="0" cellspacing="0">
                        <tr>
                            <td>
                                <input onclick="Checks(this)" type="checkbox">
                            </td>
                            <td>全选
                            </td>
                            <td>
                                <asp:RadioButtonList ID="rblTruancy" runat="server" RepeatDirection="Horizontal">
                                    <asp:ListItem Value="1" Text="" Selected="True"></asp:ListItem>
                                </asp:RadioButtonList>
                            </td>
                            <td>全部出勤
                            </td>
                            <td>
                                <label class="lab_button">
                                    <asp:Button ID="btnExc" runat="server" OnClick="btnExc_Click" Text="执行" />
                                </label>
                            </td>
                            <td style="padding-left: 5px">服务器时间：
                            </td>
                            <td>
                                <span id="curDT"></span>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="both">
                </div>
                <div class="divpanel">
                    <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                        DataKeyNames="LessonTimeID" OnRowDataBound="GridView1_RowDataBound">
                        <Columns>
                            <asp:TemplateField HeaderText="班号" ItemStyle-Width="120">
                                <ItemTemplate>
                                    <input type="checkbox" id="id" name="id" value='<%#Eval("LessonTimeID")%>' />
                                    <%#Eval("ClassID")%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="班级名称">
                                <ItemTemplate>
                                    <asp:Image ID="imgClass" ImageUrl='<%# accTheme("Class.gif")%>' ToolTip='<%#Eval("ClassID") %>'
                                        runat="server" />
                                    <asp:HyperLink runat="server" ID="HyperLink1" Text='<%#Eval("ClassName") %>' NavigateUrl='<%# string.Format("../Class/ClassFrame.aspx?ClassID={0}&pageindex=2&LessonTimeID={1}&action=attend&GetUrl={2}",Eval("ClassID"),Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="状态">
                                <ItemTemplate>
                                    <asp:ImageButton runat="server" Enabled="false" ID="ibnLeStateID" ImageUrl='<%#String.Format(accTheme("lesson_{0}.gif"),Eval("LeStateID"))%>'
                                        ToolTip='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>' CommandName="LeStateID"
                                        CommandArgument='<%#Eval("LeStateID")%>' />
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="类型">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="labLessonType" Text='<%#Rs.Items.GetLessonType(Eval("LessonType"))%>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <asp:DropDownList runat="server" ID="ddlLessonType" SelectedValue='<%#Eval("LessonType")%>'>
                                        <asp:ListItem Text="正常" Value="1"></asp:ListItem>
                                        <asp:ListItem Text="补课" Value="0"></asp:ListItem>
                                    </asp:DropDownList>
                                </EditItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="Subject" HeaderText="课题"></asp:BoundField>
                            <asp:TemplateField HeaderText="上课日期">
                                <ItemTemplate>
                                    <asp:HyperLink runat="server" ID="hlkLessonInfo" Text='<%#Eval("StartDate","{0:d}")%>'
                                        NavigateUrl='<%# string.Format("../Class/ClassFrame.aspx?ClassID={0}&pageindex=2&LessonTimeID={1}&action=attend&GetUrl={2}",Eval("ClassID"),Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                                    <span style="color: Red; font-size: 9px">[<%#((DateTime)Eval("StartDate")).DayOfWeek.ToString("d")%>]</span>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <asp:TextBox ID="dateandtime" runat="server" Text='<%#Convert.ToDateTime(Eval("StartDate")).ToString("d")%>'
                                        Width="80">
                                    </asp:TextBox>
                                </EditItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="上课时段">
                                <ItemTemplate>
                                    <%# SignTimeState(Eval("StartDate"), Eval("EndDate"), Eval("SetParameters"))%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:BoundField DataField="Lessons" HeaderText="课时"></asp:BoundField>
                            <asp:BoundField DataField="FactCount" HeaderText="出勤" ReadOnly="True"></asp:BoundField>
                            <asp:TemplateField HeaderText="讲师">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="labTeacherName" Text='<%#Eval("TeacherName")%>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <asp:DropDownList runat="server" ID="ddlTeacher" SelectedValue='<%#Eval("TeacherID")%>'
                                        DataSource='<%#swq.Cache.GetUsers()%>' DataTextField="TrueName" DataValueField="UserID">
                                    </asp:DropDownList>
                                </EditItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="教室">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="labClassroomName" Text='<%#Eval("ClassroomName")%>'></asp:Label>
                                </ItemTemplate>
                                <EditItemTemplate>
                                    <asp:DropDownList runat="server" ID="ddlClassroom" SelectedValue='<%#Eval("ClassroomID")%>'
                                        DataSource='<%#swq.Cache.GetClassroom()%>' DataTextField="ClassroomName" DataValueField="ClassroomID">
                                    </asp:DropDownList>
                                </EditItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                </div>
                <div class="divpanel">
                    <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
                </div>
                <div class="alert alert-info mt-remark">
                    <b>注意事项：</b><br />
                    1、此功能的作用即：将今天上课的班级学员全部处理成正常出勤，然后点击“上课日期”处理少数的旷课迟到等学员。<br />
                    2、如果班级众多，请一次选择少量班级，分次完成。<br />
                    3、上课时段显示为“绿色”处于签到时间内，“黄色”处于签退时间内。<br />
                </div>
            </div>
        </div>
    </form>
</body>
</html>
