﻿<%@ Page Language="c#" CodeBehind="Bills.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Mobile.Finance.Bills"
    Title="学员消费单-财务" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Register Src="../User_Col/col_Header.ascx" TagName="col_Header" TagPrefix="uc1" %>
<%@ Register Src="../User_Col/col_StuControlPanel.ascx" TagName="col_StuControlPanel" TagPrefix="uc3" %>
<%@ Register Src="../../UserCol/ReportServer.ascx" TagName="ReportServer" TagPrefix="uc4" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />
    <script src="../Jscript/createSubMenu.js" type="text/javascript"></script>
    <script type="text/javascript">
        function OpenSearch() {
            if (setContent.style.display == 'none') {
                setContent.style.display = 'block';
                setControl.innerHTML = '▲搜索';
                __mt__setSearchCookie(1);
            }
            else {
                setContent.style.display = 'none';
                setControl.innerHTML = '▼搜索';
                __mt__setSearchCookie(0);
            }
        }

        function defaultSearchState() {
            var num = __mt__getSearchCookie();
            if (num == 1) {
                setContent.style.display = 'block';
                setControl.innerHTML = '▲搜索';
            }
            else {
                setContent.style.display = 'none';
                setControl.innerHTML = '▼搜索';
            }
        }
    </script>

</head>
<body onload="defaultSearchState()">
    <form id="Form1" runat="server">
        <uc1:col_Header ID="col_Header1" runat="server" />
        <uc4:ReportServer ID="ReportServer1" runat="server" />
        <div id="web_page_contents">

            <div class="biao_zhun_suo_jin">
                <div class="container">
                    <div class="setandsearch">
                        <ul class="mt-listitems">
                            <li>
                                <div id="setControl" onclick="OpenSearch()" class="btn btn-default">
                                    ▼搜索
                                </div>
                            </li>
                        </ul>

                        <div id="setContent" style="display: none" class="kuai-show">
                            <table class="mt-table-m">
                                <tr>
                                    <td style="width: 85px">校区：</td>
                                    <td>
                                        <asp:DropDownList ID="ddlSchool" DataTextField="SchoolName" DataValueField="SchoolID"
                                            runat="server">
                                        </asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td>消费单号：</td>
                                    <td>
                                        <asp:TextBox ID="tbxBillID" runat="server"></asp:TextBox></td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                            <asp:Button ID="btnSearch" runat="server" CssClass="btn btn-default" OnClick="btnSearch_Click" Text="查询" />
                                    </td>
                                </tr>
                            </table>
                        </div>

                    </div>

                    <div class="divpanel">

                        <asp:Repeater ID="repBlock" runat="server" OnItemCommand="repBlock_ItemCommand"
                            OnItemDataBound="repBlock_ItemDataBound">
                            <ItemTemplate>
                                <asp:Panel ID="plItem" runat="server" CssClass="kuai">

                                    <h1 class="auto_length_title">
                                        <asp:ImageButton ID="ibnSelect" CommandName="Select" CommandArgument='<%# Eval("BillID") %>' ImageUrl='<%# accTheme("node_close.gif") %>'
                                            runat="server" />
                                        <asp:LinkButton ID="lbnSelect" runat="server" Text='<%# Eval("BillID") %>' CommandName="Select" CommandArgument='<%# Eval("BillID") %>' /></h1>

                                    <table class="mt-table-m" style="table-layout: fixed; word-break: break-all; word-wrap: break-word">
                                        <tr>
                                            <td style="width: auto">日期：</td>
                                            <td style="width: auto"><%#Eval("DateAndTime")%></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">类型：</td>
                                            <td style="width: auto"><%#(int)Eval("BillTypeID") == 1 ? "购买" : "退货"%></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">应交金额：</td>
                                            <td style="width: auto"><%# Eval("Pay","{0:c2}") %></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">优惠：</td>
                                            <td style="width: auto"><%# Eval("Discount","{0:c2}") %></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">实交金额：</td>
                                            <td style="width: auto"><%# Eval("Payed","{0:c2}") %></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">备注：</td>
                                            <td style="width: auto">
                                                <asp:Literal runat="server" ID="litRemark" Text='<%# Eval("Remark") %>' Mode="Encode"></asp:Literal></td>
                                        </tr>
                                        <tr>
                                            <td>办理点：</td>
                                            <td><%#Eval("PostSchoolName") %></td>
                                        </tr>
                                        <tr>
                                            <td>录入员：</td>
                                            <td><%#Eval("TrueName")%></td>
                                        </tr>
                                        <tr style="display: none">
                                            <td style="height: 25px">打印：</td>
                                            <td>
                                                <asp:HyperLink ID="hlkPrint" runat="server" NavigateUrl='<%#string.Format("javascript:Print({0});void(0);",Eval("BillID")) %>'
                                                    ImageUrl='<%# accTheme("print.gif")%>' CssClass="inline_block"></asp:HyperLink>
                                                <span class="inline_block">次数：<%# (int)Eval("PrintCount")%></span></td>
                                        </tr>
                                    </table>

                                    <table style="width: 100%;">
                                        <tr>
                                            <td style="display: none">
                                                <div class="lab_button" id="divDelete" runat="server">
                                                    <asp:LinkButton ID="lbnDelete" runat="server" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("BillID")%>'
                                                        OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                                </div>
                                            </td>
                                            <td style="display: none">
                                                <div class="lab_button" id="divEdit" runat="server">
                                                    <asp:HyperLink ID="hlkEdit" runat="server" Text="编辑" NavigateUrl='<%# string.Format("{3}.aspx?StudentID={0}&BillID={1}&GetUrl={2}",Eval("StudentID"),Eval("BillID"),swq.Web.PathAndQuery(),(int)Eval("BillTypeID") == 1 ? "PostSellBill" : "PostOutBill") %>' />

                                                </div>
                                            </td>
                                            <td>
                                                    <asp:LinkButton ID="lbnDetails" runat="server" CssClass="btn btn-default" Text="明细" CommandName="Select" CommandArgument='<%#Eval("BillID")%>'></asp:LinkButton>
                                            </td>
                                        </tr>
                                    </table>

                                    <div class="details"></div>

                                </asp:Panel>
                            </ItemTemplate>
                        </asp:Repeater>
                    </div>

                    <div class="pager_button">
                        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
                    </div>

                    <div class="row mt-button">
                        <div class="col-lg-12">
                            <p>
                                <label class="btn btn-success btn-block" id="__mt_labBack" runat="server" onclick="back(this)">
                                    返回
                                </label>
                            </p>
                        </div>
                    </div>

                    <div id="divItems" style="visibility: hidden; display: none">
                        <asp:GridView ID="gvItems" runat="server" AutoGenerateColumns="false" ShowHeader="false" CssClass="table_simple_kuan">
                            <Columns>
                                <asp:TemplateField>
                                    <ItemTemplate>
                                        <div class="striking">
                                            项目:<%# Eval("ProductName") %><%#swq.Tools.AddBrackets(Eval("PackageName")) %><br />
                                            单价:<%# Eval("UnitPrice","{0:c2}") %><br />
                                            数量:<%# Eval("Amount","{0:0.####}") %><%# Eval("UnitName") %><br />
                                            优惠:<%# Eval("Discount","{0:c2}") %><br />
                                            小计:<%# Eval("TotalPrice","{0:c2}") %><br />
                                            来源:<%# Eval("ServiceName") %>
                                        </div>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                    </div>
                </div>
            </div>
        </div>
    </form>

</body>
</html>
