﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Payments.aspx.cs" Inherits="MTCUN.Mobile.Finance.Payments"
    Title="学员充值单-财务" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../../UserCol/Remark.ascx" TagName="Remark" TagPrefix="uc2" %>
<%@ Register Src="../User_Col/col_StuControlPanel.ascx" TagName="col_StuControlPanel" TagPrefix="uc1" %>
<%@ Register Src="../User_Col/col_Header.ascx" TagName="col_Header" TagPrefix="uc3" %>
<%@ Register Src="../../UserCol/ReportServer.ascx" TagName="ReportServer" TagPrefix="uc4" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />

    <script type="text/javascript">
        function OpenSearch() {
            if (setContent.style.display == 'none') {
                setContent.style.display = 'block';
                setControl.innerHTML = '▲单号查询';
                __mt__setSearchCookie(1);
            }
            else {
                setContent.style.display = 'none';
                setControl.innerHTML = '▼单号查询';
                __mt__setSearchCookie(0);
            }
        }

        function defaultSearchState() {
            var num = __mt__getSearchCookie();
            if (num == 1) {
                setContent.style.display = 'block';
                setControl.innerHTML = '▲单号查询';
            }
            else {
                setContent.style.display = 'none';
                setControl.innerHTML = '▼单号查询';
            }
        }
    </script>
</head>
<body onload="defaultSearchState();">
    <form id="form1" runat="server">
        <uc4:ReportServer ID="ReportServer1" runat="server" />
        <uc3:col_Header ID="col_Header1" runat="server" />

        <div id="web_page_contents">
            <div class="search biao_zhun_suo_jin">
                <div class="container">
                    <div class="setandsearch">
                        <ul class="mt-listitems">
                            <li>
                                <div id="setControl" onclick="OpenSearch()" class="btn btn-warning">
                                    ▼单号查询
                                </div>
                            </li>
                        </ul>

                        <div id="setContent" style="display: none" class="kuai-show">
                            <h1>单号查询
                            </h1>
                            <table class="mt-table-m">
                                <tr>
                                    <td>充值单号：
                                    </td>
                                    <td>
                                        <asp:TextBox ID="tbxPaymentID" runat="server"></asp:TextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                            <asp:Button ID="btnSearch" runat="server" CssClass="btn btn-success" OnClick="btnSearch_Click" Text="查询" />
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>


                    <div class="divpanel">
                        <asp:Repeater ID="repBlock" runat="server" OnItemCommand="repBlock_ItemCommand"
                            OnItemDataBound="repBlock_ItemDataBound">
                            <ItemTemplate>

                                <asp:Panel ID="plItem" runat="server" CssClass="kuai">

                                    <h1 class="auto_length_title">单号：<%#Eval("PaymentID")%></h1>

                                    <table class="mt-table-m" style="table-layout: fixed; word-break: break-all; word-wrap: break-word">
                                        <tr>
                                            <td style="width: auto">姓名：</td>
                                            <td style="width: auto"><%#Eval("StudentName") %></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">类型：</td>
                                            <td style="width: auto"><%#Eval("PaymentTypeName") %></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">金额：</td>
                                            <td style="width: auto"><%#Eval("PayMoney", "{0:c2}") %></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">收款方式：</td>
                                            <td style="width: auto"><%#Eval("PayMethodName")%></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">日期：</td>
                                            <td style="width: auto"><%#Eval("DateAndTime")%></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">备注：</td>
                                            <td style="width: auto"><%#Eval("Remark")%></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">借款到期：</td>
                                            <td style="width: auto"><%#Eval("CreditExpiration")%></td>
                                        </tr>
                                        <tr>
                                            <td>办理点：</td>
                                            <td><%#Eval("PostSchoolName") %></td>
                                        </tr>
                                        <tr>
                                            <td>录入员：</td>
                                            <td><%#Eval("TrueName")%></td>
                                        </tr>
                                        <tr style="display: none">
                                            <td style="height: 25px">打印：</td>
                                            <td>
                                                <asp:HyperLink ID="hlkPrint" runat="server" NavigateUrl='<%#string.Format("javascript:Print({0});void(0);",Eval("PaymentID")) %>'
                                                    ImageUrl='<%# accTheme("print.gif")%>' CssClass="inline_block"></asp:HyperLink>
                                                <span class="inline_block">次数：<%# (int)Eval("PrintCount")%></span></td>
                                        </tr>
                                    </table>

                                    <table style="width: 100%; display: none" class="mt-table-m">
                                        <tr>
                                            <td>
                                                    <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("PaymentID")%>'
                                                        OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                            </td>
                                            <td>
                                                    <asp:LinkButton runat="server" CssClass="btn btn-default" ID="lbnEdit" CommandArgument='<%# Eval("PaymentID")%>'
                                                        CommandName="Edit" Text="编辑"></asp:LinkButton>
                                            </td>
                                            <td>
                                                    <asp:HyperLink ID="hlkCol" runat="server" CssClass="btn btn-default" Text="控制面板" NavigateUrl='<%# string.Format("StuPayment.aspx?StudentID={0}&PaymentID={1}&pageIndex=1&GetUrl={2}&topurl={2}",Eval("StudentID"),Eval("PaymentID"),swq.Web.PathAndQuery()) %>' />
                                            </td>
                                        </tr>
                                    </table>


                                </asp:Panel>
                                <asp:Panel ID="plEdit" runat="server" CssClass="kuai edit_kuai">
                                    <h1 class="auto_length_title">单号：<%#Eval("PaymentID")%></h1>

                                    <table class="mt-table-m">
                                        <tr>
                                            <td style="width: auto">类型：</td>
                                            <td style="width: auto"><%#Eval("PaymentTypeName") %></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">金额：</td>
                                            <td style="width: auto">
                                                <asp:TextBox ID="tbxPayMoney" runat="server" Text='<%# Eval("PayMoney") %>'></asp:TextBox></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">收款方式：</td>
                                            <td style="width: auto">
                                                <asp:DropDownList ID="ddlPayMethod" runat="server" DataTextField="PayMethodName" DataValueField="PayMethodName">
                                                </asp:DropDownList></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">日期：</td>
                                            <td style="width: auto">
                                                <asp:TextBox ID="tbxDateAndTime" runat="server" Text='<%# Eval("DateAndTime") %>'></asp:TextBox></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">备注：</td>
                                            <td style="width: auto">
                                                <asp:TextBox ID="tbxRemark" runat="server" Text='<%# Eval("Remark") %>'></asp:TextBox></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">借款到期：</td>
                                            <td style="width: auto">
                                                <asp:TextBox ID="tbxCreditExpiration" runat="server" Text='<%# Eval("CreditExpiration") %>'></asp:TextBox></td>
                                        </tr>
                                        <tr>
                                            <td>办理点：</td>
                                            <td>
                                                <asp:DropDownList ID="ddlPostSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                                                </asp:DropDownList></td>
                                        </tr>
                                        <tr>
                                            <td>录入员：</td>
                                            <td><%#Eval("TrueName")%></td>
                                        </tr>
                                        <tr>
                                            <td style="height: 25px"></td>
                                            <td></td>
                                        </tr>
                                    </table>


                                    <table style="width: 100%;">
                                        <tr>
                                            <td>
                                                    <asp:LinkButton runat="server" CssClass="btn btn-default" ID="lbnUpdate" CommandArgument='<%# Eval("PaymentID")%>'
                                                        CommandName="Update" Text="更新"></asp:LinkButton>
                                            </td>
                                            <td>
                                                    <asp:LinkButton runat="server" CssClass="btn btn-default" ID="lbnCancel" CommandArgument='<%# Eval("PaymentID")%>'
                                                        CommandName="Cancel" Text="取消"></asp:LinkButton>
                                            </td>
                                        </tr>
                                    </table>

                                </asp:Panel>

                            </ItemTemplate>
                        </asp:Repeater>
                    </div>

                    <div class="pager_button">
                        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
                    </div>

                    <div class="row mt-button">
                        <div class="col-lg-12">
                            <p>
                                <label class="btn btn-success btn-block" id="__mt_labBack" runat="server" onclick="back(this)">
                                    返回
                                </label>
                            </p>
                        </div>
                    </div>

                    <div class="alert alert-info mt-remark">
                        <b>注意事项：</b><br />
                        1、退费、扣除借款请使用负数。<br />
                    </div>
                </div>
            </div>
    </form>
</body>
</html>
