﻿function __mt__GetCookieVal(offset)
//获得Cookie解码后的值
{
    var endstr = document.cookie.indexOf(";", offset);
    if (endstr == -1)
        endstr = document.cookie.length;
    return unescape(document.cookie.substring(offset, endstr));
}


function __mt__SetCookie(name, value)
//设定Cookie值
{
    __mt__DelCookie(name);

    var argv = __mt__SetCookie.arguments;
    var argc = __mt__SetCookie.arguments.length;
    var expires = (argc > 2) ? argv[2] : null; //expires，在这里表示过期时间。
    var path = (argc > 3) ? argv[3] : null;
    var domain = (argc > 4) ? argv[4] : null;
    var secure = (argc > 5) ? argv[5] : false;
    document.cookie = name + "=" + escape(value) + ((expires == null) ? "" : ("; expires=" + expires.toGMTString()))
+ ((path == null) ? "" : ("; path=" + path)) + ((domain == null) ? "" : ("; domain=" + domain))
+ ((secure == true) ? "; secure" : "");
}


function __mt__DelCookie(name)
//删除Cookie
{
    var exp = new Date();
    exp.setTime(exp.getTime() - 1);
    var cval = __mt__GetCookie(name);
    document.cookie = name + "=" + cval + "; expires=" + exp.toGMTString();
}


function __mt__GetCookie(name)
//获得Cookie的原始值
{
    var arg = name + "=";
    var alen = arg.length;
    var clen = document.cookie.length;
    var i = 0;
    while (i < clen) {
        var j = i + alen;
        if (document.cookie.substring(i, j) == arg)
            return __mt__GetCookieVal(j);
        i = document.cookie.indexOf(" ", i) + 1;
        if (i == 0) break;
    }
    return null;
}




function __mt__setSearchCookie(value) {
    var expdate = new Date();
    expdate.setTime(expdate.getTime() + (24 * 60 * 60 * 1000 * 365));
    __mt__SetCookie("__mt__Search", value, expdate, "/", null, false);
}

function __mt__getSearchCookie() {
    var cookie = __mt__GetCookie("__mt__Search");
    if (cookie == null)
        return 0;
    else
        return parseInt(cookie);
}


function __mt__setClassCookie(value) {
    var expdate = new Date();
    expdate.setTime(expdate.getTime() + (24 * 60 * 60 * 1000 * 365));
    __mt__SetCookie("__mt__Class", value, expdate, "/", null, false);
}

function __mt__getClassCookie() {
    var cookie = __mt__GetCookie("__mt__Class");
    if (cookie == null)
        return 0;
    else
        return parseInt(cookie);
}


function __mt__setModeCookie(value) {
    var expdate = new Date();
    expdate.setTime(expdate.getTime() + (24 * 60 * 60 * 1000 * 365));
    __mt__SetCookie("__mt__MobileorPC", value, expdate, "/", null, false);
}

function __mt__getModeCookie() {
    var cookie = __mt__GetCookie("__mt__MobileorPC");
    if (cookie ==null)
        return 1;
    else
        return parseInt(cookie);
}