﻿
//转换成小写
function ToLower(code) {
    var reCat = /\&lt;(.+?)\&gt;/gm;
    return code.replace(reCat, _toLower);
}

function _toLower(word) {
    if (word != null && word.length > 0) {
        word = word.toLowerCase();
        word = "<span style='color:#A31515'>" + word + "</span>";
    }
    return word;
}

//清除
function clearProperty(str) {
    //var reg1 = /(\s+\w+)\s*=\s*([^<>"\s]+)(?=[^<>]*>)/ig;
    //var reg2 = /"'([^'"]*)'"/ig;
    //str = str.replace(reg1, '$1="$2"'); //.replace(reg2, '\"$1\"');
    return str;
}



//SQL查询语法
function RenderingSource(theBox) {
    theBox.innerText = theBox.innerText;
    var code = theBox.innerText;

    code = code.replace(/\bfrom\b(\s+[a-zA-Z0-9,]+)(\s*)/ig, "from <span style='color:#2B91AF'>$1</span>$2");     //from
    code = code.replace(/([a-zA-Z0-9]+)\./ig, "<span style='color:#2B91AF'>$1</span>.");                          //table.
    code = code.replace(/\bas\b +([^, \r\n]+)/igm, " as <span style='color:#A31515'>$1</span>");                  //as

    code = code.replace(/\{\@([a-zA-Z0-9]+)\}/ig, " <span style='color:#AF5500; background-color:#FFEE62' >{@<span style='color:#000'>$1</span>}</span> ");
    code = code.replace(/\{\@([a-zA-Z0-9]+):([^\}]+)\}/ig, " <span style='color:#AF5500; background-color:#FFEE62' >{@<span style='color:#000'>$1</span>:<span style='color:#A31515'>$2</span>}</span> ");

    code = code.replace(/\b(ShowKey)\b/ig, "<span style='color:#ff0000; background-color:#FFEE62'>$1</span>");   //ShowKey
    code = code.replace(/\b(and|or|in|order|by|select|from|where|group|union|desc|asc|as|case)\b/ig, " <span style='color:#0000FF'>$1</span> ");


    //麦田语法
    code = code.replace(/\@([a-zA-Z0-9]+)/ig, " <span style='color:#AF5500; background-color:#FFEE62' >@<span style='color:#000'>$1</span></span> ");
    code = code.replace(/\btable *: *([a-zA-Z0-9,_]+)/ig, "<span style='color:#0000FF'>table:</span><span style='color:#2B91AF'>$1</span>");   //table
    code = code.replace(/\bcmd *:/ig, "<span style='color:#0000FF'>cmd:</span>");   //cmd
    code = code.replace(/\bgo\b/ig, "<span style='color:#0000FF'>GO</span>");   //go


    code = code.replace(/\n/ig, "<br>");
    code = "<span style='color:#000000'>" + code + "</span>";
    
    
    theBox.innerHTML = code;
}


//Xsl报表打印语法
function RenderingXsl(theBox) {
    theBox.innerText = theBox.innerText;
    var code = theBox.innerHTML;

//    var code = theBox.innerText; 
//    code = code.replace(/</ig, "&lt;");
//    code = code.replace(/>/ig, "&gt;");
//    code = code.replace(/ /g, "&nbsp;");

    //<内容>
    code = code.replace(/(\&lt;\/?\??)(.+?)(\/?\??\&gt;)/gm, "$1<span style='color:#A31515'>$2</span>$3");

    //<>
    code = code.replace(/&lt;(\/?\??) */g, "<span style='color:#0000FF'>&lt;$1</span>");
    code = code.replace(/(\/?\??)&gt;/g, "<span style='color:#0000FF'>$1&gt;</span>");

    
    //select=x
    code = code.replace(/\b(select)\b( *= *)"([^"]+)"/ig, "<span style='color:#0000FF'><span style='color:#FF0000'>$1</span>$2\"<span style='color:#000000; background-color:#FFEE62'>$3</span>\"</span>");

    //select=x
    code = code.replace(/\b(test)\b( *= *)"([^"]+)"/ig, "<span style='color:#0000FF'><span style='color:#FF0000'>$1</span>$2\"<span style='color:#000000; background-color:#FFEE62'>$3</span>\"</span>");
    
    //属性
    code = code.replace(/(\b[\w:]+)\b\s*=\s*("[^"]*")/g, "<span style='color:#FF0000'>$1</span><span style='color:#0000FF'>=$2</span>");

    //xsl关键字
    code = code.replace(/\b(xsl:value-of|xsl:if|xsl:for-each|xsl:param|xsl:variable|xsl:template|xsl:stylesheet)\b/ig, "<span style='color:#2B91AF'>$1</span>");
    
//    code = code.replace(/\n/ig, "<br>");
    theBox.innerHTML = code;
}