﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="AddStudent.aspx.cs" Inherits="MTCUN.Mobile.Register.AddStudent" %>

<%@ Register Src="../../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Register Src="../../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc1" %>
<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>快捷报班、续费-客服</title>
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        jQuery(document).ready(function ($) {
            if (simple == 1) {
                $('#select').hide();
                $('#info').hide();
            }
        });
    </script>
</head>
<body>
    <form id="form1" runat="server">
        <div id="web_page_contents">
            <div class="search biao_zhun_suo_jin">

                <div class="kuai">
                    <h1>选择学员</h1>
                    <div id="select">
                        请输入姓名：<span style="color: #c0c0c0">（支持姓名简码、手机号、身份证号）</span><br />
                        <asp:TextBox ID="tbxStudentID" runat="server"></asp:TextBox>
                        <div class=" lab_button">
                            <asp:Button ID="btnSearch" runat="server" OnClick="btnSearch_Click" Text="查找学员" />
                        </div>
                        <asp:Label ID="labMsg" runat="server" ForeColor="Red"></asp:Label>
                        <br />
                        <div style="overflow-y: scroll; overflow-x: auto; width: 100%; max-height: 200px; height: 100px; border: 1px solid #cccccc; background-color: white" id="divStu" runat="server" visible="false">
                            <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False"
                                DataKeyNames="StudentID">
                                <Columns>
                                    <asp:TemplateField HeaderText="学号" ItemStyle-Width="120">
                                        <ItemTemplate>
                                            <%#Eval("StudentID")%>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="姓名">
                                        <ItemTemplate>
                                            <%#Eval("StudentName")%>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="手机">
                                        <ItemTemplate>
                                            <%# PrivacyTelNumber(Eval("MobileTel"), 3)%>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="选择学员">
                                        <ItemTemplate>
                                            <div class="lab_button" id="divDelete" runat="server">
                                                <asp:HyperLink ID="dd" NavigateUrl='<%# string.Format("?StudentID={0}&LessonTimeID={1}&GetUrl={2}",Eval("StudentID"),Request.QueryString["LessonTimeID"],Server.UrlEncode(Request.QueryString["geturl"])) %>' runat="server">选择</asp:HyperLink>
                                            </div>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                            </asp:GridView>
                        </div>
                        <br />
                    </div>

                    <div class="kuai" style="margin-top: 0px; text-align: center">
                        <asp:Label ID="labStudentName" runat="server"></asp:Label>
                    </div>
                </div>

                <div class="kuai">
                    <h1>已报班级</h1>
                    <div style="width: 100%" id="divStuClass" runat="server" visible="false">
                        <asp:GridView ID="gdvStuClass" runat="server" AutoGenerateColumns="False"
                            DataKeyNames="StuClassID" GridLines="None" Width="100%">
                            <SelectedRowStyle CssClass="selected" />
                            <Columns>
                                <asp:TemplateField ShowHeader="false">
                                    <ItemTemplate>
                                        <div class="kuai" style="margin-top: 5px">
                                            <table class="table_simple_kuan">
                                                <tr>
                                                    <td style="width: 50px">班级：</td>
                                                    <td>
                                                        <asp:HyperLink ID="hlkClassShow" runat="server" Text='<%#Eval("ClassName")%>' /></td>
                                                    <td style="text-align:right">
                                                        <div class="lab_button" id="divConn" runat="server" style="width: 50px">
                                                            <asp:HyperLink ID="hlkConn" runat="server" Text="续费" NavigateUrl='<%# string.Format("PostSellBill.aspx?module={0}&PageIndex=2&action=add&StuClassID={1}&StudentID={2}&ClassID={3}&GetURL={4}", (int)ModuleType, Eval("StuClassID"),Eval("StudentID"),Eval("ClassID"),swq.Web.PathAndQuery()) %>' />
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>课时：</td>
                                                    <td colspan="2">
                                                        <uc1:Progress ID="Progress1" runat="server" QType='<%#(QType)Eval("QType") %>' MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>' StartDate='<%#Eval("DateAndTime") %>' ExpiryDate='<%#Eval("ExpiryDate") %>'
                                                            progresswidth="65%" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>状态：</td>
                                                    <td colspan="2"><%#Rs.Items.GetScState(Eval("ScStateID"))%></td>
                                                </tr>
                                            </table>

                                        </div>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                    </div>
                </div>


                <div class="kuai">
                    <h1>新加班级</h1>
                    <asp:Repeater ID="repBlock" runat="server" OnItemDataBound="repBlock_ItemDataBound">
                        <ItemTemplate>
                            <div class="kuai" style="position: relative; background-color: #fefff3; display: inline-block">
                                <div id="divDel" runat="server" style="position: absolute; border: 1px solid #c0c0c0; width: 25px; height: 25px; top: 2px; right: 2px; line-height: 25px; vertical-align: middle; text-align: center; font-size: larger; background-color: cornsilk; cursor: pointer">×</div>
                                <div class="auto_length_title" style="font-weight: bold; font-size: 14px">
                                    <asp:Image ID="imgClass" ImageUrl='<%# accTheme("Class.gif")%>' ToolTip='<%#Eval("ClassID") %>'
                                        runat="server" />
                                    <%#Eval("ClassName") %>
                                </div>

                                <table class="table" cellspacing="0" cellpadding="0" border="0">
                                    <tr>
                                        <td style="width: auto">班号：</td>
                                        <td style="width: auto"><%#Eval("ClassID") %></td>
                                    </tr>
                                    <tr>
                                        <td style="width: auto">开课日期：</td>
                                        <td style="width: auto"><%#Eval("StartDate","{0:d}") %>-<%#Eval("EndDate","{0:d}") %></td>
                                    </tr>
                                    <tr>
                                        <td>老师：</td>
                                        <td><%#Eval("TeacherName") %></td>
                                    </tr>
                                    <tr>
                                        <td>上课规律：</td>
                                        <td><%#Eval("TimeRule") %></td>
                                    </tr>
                                    <tr>
                                        <td>上课进度：</td>
                                        <td>
                                            <uc2:Progress ID="Progress3" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                                                progresswidth="50px" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>剩余名额：</td>
                                        <td style="color: red; font-weight: bold"><%#(int)Eval("PlanCount") - ((int) Eval("StuCount") + (int)Eval("ProspectStuCount")) %></td>
                                    </tr>
                                    <tr>
                                        <td>所属课程：</td>
                                        <td><%#Eval("CourseName") %></td>
                                    </tr>
                                    <tr>
                                        <td>课程单位：</td>
                                        <td><%#Eval("UnitName") %></td>
                                    </tr>
                                    <tr>
                                        <td>上课校区：</td>
                                        <td><%#Eval("SchoolName") %></td>
                                    </tr>
                                </table>
                            </div>
                        </ItemTemplate>
                    </asp:Repeater>
                </div>

                <br />
                <br />
                <div class=" lab_button">
                    <asp:Button ID="btnAddClass" runat="server" Text="继续增加班级" OnClick="btnAddClass_Click" />
                </div>
                <div class=" lab_button">
                    <asp:Button ID="btnPost" runat="server" OnClick="btnPost_Click" Text="支付" />
                </div>
                <div class="mt-back">
                    <label class="lab_button_kuan" id="__mt_labBack" runat="server">
                        <input id="btnBack" causesvalidation="false" type="button" runat="server" onclick="back(this)"
                            value="返回" />
                    </label>
                </div>

                <div class="web_foot">
                    <b>注意事项：</b><br />
                    1、【选择学员】、【选择班级】点击【支付】进入消费单处理界面：这一步需要确认一下购买的数量金额。<br />
                    2、如果是按时间收费，请编辑收费项目上的到期时间，否则系统自动根据参数进行估算一个到期时间。
                </div>
            </div>
        </div>

    </form>
</body>
</html>
