﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="EditStuClass.aspx.cs" Inherits="MTCUN.Mobile.Register.EditStuClass"
    Title="选择已选班级-客服" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../User_Col/col_Header.ascx" TagName="col_Header" TagPrefix="uc3" %>
<%@ Register Src="../User_Col/col_StuControlPanel.ascx" TagName="col_StuControlPanel" TagPrefix="uc4" %>
<%@ Register Src="../../UserCol/Progress.ascx" TagName="progress" TagPrefix="uc1" %>
<%@ Register Src="../../UserCol/EditQuantifiedCol.ascx" TagName="EditQuantifiedCol" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <uc3:col_Header ID="col_Header1" runat="server" />
        <div id="web_page_contents">
            <div class="search biao_zhun_suo_jin">
                <uc4:col_StuControlPanel ID="col_StuControlPanel1" runat="server" />
                <div class="kuai-show form">
                    <table class=" table_simple_kuan" cellspacing="0" runat="server" id="tabPost">
                        <tr>
                            <th colspan="2">选择已选班级
                            </th>
                        </tr>
                        <tr>
                            <td style="width: 60px">选班：
                            </td>
                            <td class="required">
                                <asp:DropDownList ID="ddlClass" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlClass_SelectedIndexChanged" CssClass="select_kuan">
                                </asp:DropDownList>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 60px">筛选：
                            </td>
                            <td class="required">选班状态：<asp:DropDownList ID="ddlScState" runat="server" AutoPostBack="True"
                                OnSelectedIndexChanged="ddlScState_SelectedIndexChanged">
                                <asp:ListItem Value="true">正常</asp:ListItem>
                                <asp:ListItem Value="false">全部</asp:ListItem>
                            </asp:DropDownList>
                            </td>
                        </tr>
                        <tr>
                            <td>计量：
                            </td>
                            <td>
                                <div class="inline_block" style="background-color: #ffffff; border: 1px solid #ECEB7F; border-radius: 5px; width: auto; padding: 4px; background-color: #FEFDC1">
                                    <div id="setContent">
                                        <uc2:EditQuantifiedCol ID="EditQuantifiedCol1" runat="server" Visible="False" />
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>类型：
                            </td>
                            <td>
                                <asp:DropDownList ID="ddlContinueReg" runat="server">
                                    <asp:ListItem Value="0">试听</asp:ListItem>
                                    <asp:ListItem Value="1" Selected="True">新增</asp:ListItem>
                                    <asp:ListItem Value="2">续报</asp:ListItem>
                                </asp:DropDownList>
                            </td>
                        </tr>
                        <tr>
                            <td>录入员：
                            </td>
                            <td class="required">
                                <asp:DropDownList ID="ddlUser" runat="server" DataTextField="TrueName" DataValueField="UserID">
                                </asp:DropDownList>
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;
                            </td>
                            <td>
                                <label class="lab_button">
                                    <asp:Button ID="btnSubmit" runat="server" Text="提交" OnClick="btnSubmit_Click" />
                                </label>
                                <label class="lab_button">
                                    <input causesvalidation="false" type="button" runat="server" onclick="back(this)" value="返回" />
                                </label>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="kuai-show">
                    <asp:FormView ID="fvClass" runat="server" Width="100%">
                        <ItemTemplate>
                            <table class="smallgridview" cellspacing="0" style="width: 100%">
                                <thead>
                                    <tr>
                                        <th colspan="2" style="text-align: center">班级预览
                                        </th>
                                    </tr>
                                </thead>
                                <tr>
                                    <td>班级名称：
                                    </td>
                                    <td>
                                        <%#Eval("ClassName")%>
                                    </td>
                                </tr>
                                <tr>
                                    <td>开课时间：
                                    </td>
                                    <td>
                                        <%#Eval("StartDate", "{0:d}") + " -- " + Eval("EndDate", "{0:d}")%>
                                    </td>
                                </tr>
                                <tr>
                                    <td>上课规律：
                                    </td>
                                    <td>
                                        <%#Eval("TimeRule")%>
                                    </td>
                                </tr>
                                <tr>
                                    <td>主讲老师：
                                    </td>
                                    <td>
                                        <%#Eval("TeacherName")%>
                                    </td>
                                </tr>
                                <tr>
                                    <td>教室：
                                    </td>
                                    <td>
                                        <%#Eval("ClassroomName")%>
                                    </td>
                                </tr>
                                <tr>
                                    <td>招生比例：
                                    </td>
                                    <td>
                                        <uc1:progress ID="Progress1" runat="server" Text="人" MaxNum='<%#Eval("PlanCount") %>'
                                            MinNum='<%#Eval("StuCount") %>' Width="60px" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>课时进度：
                                    </td>
                                    <td>
                                        <uc1:progress ID="Progress2" runat="server" Text="课时" MaxNum='<%#Eval("Lessons") %>'
                                            MinNum='<%#Eval("CourseProgress") %>' Width="60px" />
                                    </td>
                                </tr>
                                <tr>
                                    <td>选班状态：
                                    </td>
                                    <td>
                                        <%# Rs.Items.GetScState( Eval("ScStateID")) %>
                                    </td>
                                </tr>
                            </table>
                        </ItemTemplate>
                    </asp:FormView>
                </div>
                <div class="alert alert-info mt-remark">
                    <b>注意事项：</b><br />
                    1、按状态筛选，选择“正常”时，只显示班级状态为正常的学员。选择“全部”时，状态为转班、退学、弃学、休学等班级也将会显示出来。<br />
                    2、当勾选“同步班级结束日期”，学员到期时间会自动与班级结束日期同步，只有上课结束日期与班级结束日期相同的学员才可以选择此项，慎用。<br />
                </div>
            </div>
        </div>
    </form>
</body>
</html>
