﻿<%@ Page Language="c#" CodeBehind="StudentList.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Mobile.Register.StudentList"
    Title="学员列表-客服" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../User_Col/col_Header.ascx" TagName="col_Header" TagPrefix="uc3" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />

    <script type="text/javascript">
        function OpenSearch() {
            if (setContent.style.display == 'none') {
                setContent.style.display = 'block';
                setControl.innerHTML = '▲搜索';
                __mt__setSearchCookie(1);
            }
            else {
                setContent.style.display = 'none';
                setControl.innerHTML = '▼搜索';
                __mt__setSearchCookie(0);
            }
        }

        function defaultSearchState() {
            var num = __mt__getSearchCookie();
            if (num == 1) {
                setContent.style.display = 'block';
                setControl.innerHTML = '▲搜索';
            }
            else {
                setContent.style.display = 'none';
                setControl.innerHTML = '▼搜索';
            }
        }
    </script>

    <script type="text/javascript">
        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    e.checked = checkbox.checked;
                }
            }
        }

        function Send() {
            var StudentID = "";
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id == "id") {
                    if (e.checked) {
                        StudentID += "," + e.value;
                    }
                }
            }

            if (StudentID.length > 0) {
                StudentID = StudentID.substring(1, StudentID.length);
                document.getElementById("StudentID").value = StudentID;
                document.formStudent.action = "../sms/SendToStudent.aspx?app=true";
                document.formStudent.submit();
            }
        }
    </script>

</head>
<body onload="defaultSearchState()">
    <form id="Form1" method="post" runat="server">

        <uc3:col_Header ID="col_Header1" runat="server" />


        <div id="web_page_contents">
            <div class="search biao_zhun_suo_jin">
                <div class="container">


                    <div class="setandsearch">
                        <ul class="mt-listitems">

                            <li>
                                <table class="mt-table-m">
                                    <tr>
                                        <td>
                                            <input onclick="Checks(this)" type="checkbox" value="">
                                        </td>
                                        <td>全选
                                        </td>
                                        <td onclick="Send();" style="width: 55px"><label class="btn btn-default">发消息</label>
                                        </td>
                                        <td>
                                            <asp:DropDownList ID="ddlOrderMode" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlOrderMode_SelectedIndexChanged">
                                                <asp:ListItem Value="0">默认排序</asp:ListItem>
                                                <asp:ListItem Value="2">录入日期</asp:ListItem>
                                                <asp:ListItem Value="3">学员编号</asp:ListItem>
                                            </asp:DropDownList>
                                        </td>
                                    </tr>
                                </table>
                            </li>
                            <li>
                                <div id="setControl" onclick="OpenSearch()" class="btn btn-warning">
                                    ▼搜索
                                </div>
                            </li>
                        </ul>

                        <div id="setContent" style="display: none" class="kuai-show">
                            <h1>学员快速查询</h1>
                            <table class="mt-table-m">
                                <tr>
                                    <td>ID卡号：
                                    </td>
                                    <td>
                                        <asp:TextBox ID="tbxSignInID" runat="server"></asp:TextBox>
                                    </td>
                                </tr>
                                <tr>
                                    <td>学号：</td>
                                    <td>
                                        <asp:TextBox ID="tbxStudentID" runat="server"></asp:TextBox></td>
                                </tr>
                                <tr>
                                    <td>姓名：</td>
                                    <td>
                                        <asp:TextBox ID="tbxStudentName" runat="server"></asp:TextBox></td>
                                </tr>
                                <tr>
                                    <td>电话：</td>
                                    <td>
                                        <asp:TextBox ID="tbxTel" runat="server"></asp:TextBox></td>
                                </tr>
                                <tr>
                                    <td>校区：</td>
                                    <td>
                                        <asp:DropDownList ID="ddlSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                                        </asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td>录入员：</td>
                                    <td>
                                        <asp:DropDownList ID="ddlUser" runat="server" DataTextField="TrueName" DataValueField="UserID">
                                        </asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td>顾问：</td>
                                    <td>
                                        <asp:DropDownList ID="ddlConsultant" runat="server" DataTextField="TrueName" DataValueField="UserID">
                                        </asp:DropDownList></td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                            <asp:Button ID="btnSelect" runat="server" CssClass="btn btn-success" Text="查询" OnClick="btnSelect_Click"></asp:Button>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>


                    <asp:Repeater ID="repBlock" runat="server" OnItemCommand="repBlock_ItemCommand" OnItemDataBound="repBlock_ItemDataBound">
                        <ItemTemplate>
                            <div class="kuai">
                                <h1 class="auto_length_title">
                                    <span runat="server" id="spanBox">
                                        <input type="checkbox" id="id" value='<%#Eval("StudentID")%>' /></span><%# ShowStudent(Eval("StudentName"), Eval("Byname"), Eval("Sex"), Eval("StudentType"), Eval("SignInID"), Eval("MobileTel"), Eval("SignInSMS"), Eval("FingerState"), Eval("FingerCode"), Eval("qywxState"), Eval("mtqywxState"), Eval("wxState"), Eval("mtwxState"))%>
                                </h1>

                                <table class="mt-table-m">
                                    <tr>
                                        <td style="width: auto">学号：</td>
                                        <td style="width: auto"><%# Eval("StudentID") %></td>
                                    </tr>
                                    <tr>
                                        <td style="width: auto">报名日期：</td>
                                        <td style="width: auto"><%#Eval("DateAndTime","{0:d}") %></td>
                                    </tr>
                                    <tr>
                                        <td style="width: auto">可用余额：</td>
                                        <td style="width: auto"><%#Eval("AvailableMoney", "{0:c2}")%></td>
                                    </tr>

                                    <tr>
                                        <td>校区：</td>
                                        <td><%#Eval("SchoolName") %></td>
                                    </tr>
                                    <tr>
                                        <td>录入员：</td>
                                        <td><%#Eval("TrueName")%></td>
                                    </tr>
                                </table>

                                帐单数：<span style="color: Red"><b>
                                    <%#Eval("BillCount")%></b></span>

                                选班数：<span style="color: Red"><b><%#Eval("StuClassCount")%></b></span>
                                <table class="mt-table-m">
                                    <tr>
                                        <td>
                                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("StudentID")%>'
                                                OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                                        </td>
                                        <td>
                                            <asp:HyperLink ID="hlkEdit" runat="server" CssClass="btn btn-default" Text="编辑" NavigateUrl='<%# string.Format("PostStudent.aspx?StudentID={0}&PageIndex=0&action=edit&topURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                                        </td>
                                        <td>
                                            <asp:HyperLink ID="hlkFee" runat="server" CssClass="btn btn-default" Text="收费" NavigateUrl='<%# string.Format("PostSellBill.aspx?StudentID={0}&topURL={1}&geturl={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                                        </td>
                                        <td>
                                            <asp:HyperLink ID="hlkControlPanel" runat="server" CssClass="btn btn-default" Text="控制面板" NavigateUrl='<%# string.Format("StudentShow.aspx?StudentID={0}&topURL={1}",Eval("StudentID"),swq.Web.PathAndQuery()) %>' />
                                        </td>
                                    </tr>
                                </table>

                            </div>
                        </ItemTemplate>
                    </asp:Repeater>

                    <div class="pager_button">
                        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
                    </div>

                    <div class="row mt-button">
                        <div class="col-lg-12">
                            <p>
                                <label class="btn btn-success btn-block" id="__mt_labBack" runat="server" onclick="back(this)">
                                    返回
                                </label>
                            </p>
                        </div>
                    </div>


                    <div class="alert alert-info mt-remark">
                        <b>注意事项：</b><br />
                        1、在学员姓名栏中输入姓名拼音简写可快速查询学员（如：输入kz，可查询出孔子）。<br />
                    </div>

                </div>
            </div>

        </div>

    </form>
    <!--短信Post传递参数代码S-->
    <div style="display: none">
        <form id="formStudent" name="formStudent" method="post">
            <input id="StudentID" name="StudentID" type="hidden" value="" />
        </form>
    </div>
    <!--短信Post传递参数代码E-->

</body>
</html>
