﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SendHighToStudent.aspx.cs"
    Inherits="MTCUN.Mobile.SMS.SendHighToStudent" Title="发送到学员(高级)-消息" %>

<%@ Register Src="../User_Col/col_Header.ascx" TagName="col_Header" TagPrefix="uc3" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <uc3:col_Header ID="col_Header1" runat="server" />
        <div id="web_page_contents">
            <div class="biao_zhun_suo_jin">
                <div class="container">

                    <div class="kuai-show">
                        <table class="table_simple_kuan">
                            <tr>
                                <th colspan="2">发送消息到学员（高级模式）
                                </th>
                            </tr>
                            <tr>
                                <td style="width:80px">数据源：
                                </td>
                                <td>
                                    <asp:GridView ID="GridView1" runat="server" CssClass="mt-table-m" OnRowDeleting="GridView1_RowDeleting"
                                        EnableViewState="False">
                                        <Columns>
                                            <asp:CommandField DeleteText="删除" HeaderText="操作" ItemStyle-CssClass="btn btn-success" ButtonType="Link" ShowDeleteButton="true" />
                                        </Columns>
                                    </asp:GridView>
                                    <br />


                                    <asp:Repeater ID="repBlock" runat="server" OnItemCommand="repBlock_ItemCommand"
                                        OnItemDataBound="repBlock_ItemDataBound">
                                        <ItemTemplate>
                                            <asp:Panel ID="plItem" runat="server" CssClass="kuai">
                                                <table class="table_simple_kuan" runat="server" id="tab">
                                                </table>
                                            </asp:Panel>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </td>
                            </tr>
                            <tr runat="server" id="trmobiletel">
                                <td>接收者号码字段：
                                </td>
                                <td>
                                    <asp:DropDownList ID="ddlClientMobileTelField" runat="server">
                                    </asp:DropDownList>
                                    <span style="color: Red">*</span> 选择手机号码列。
                                </td>
                            </tr>
                            <tr runat="server" id="trclientid">
                                <td>接收者编号字段：
                                </td>
                                <td>
                                    <asp:DropDownList ID="ddlClientIDField" runat="server">
                                    </asp:DropDownList>
                                </td>
                            </tr>
                            <tr runat="server" id="trclientname">
                                <td>接收者姓名字段：
                                </td>
                                <td>
                                    <asp:DropDownList ID="ddlClientNameField" runat="server">
                                    </asp:DropDownList>
                                </td>
                            </tr>
                            <tr class="required">
                                <td>消息内容：
                                </td>
                                <td>
                                    <div id="msg" style="color: #676767">
                                    </div>
                                    <asp:TextBox ID="tbxContent" runat="server" Height="111px" TextMode="MultiLine"></asp:TextBox>
                                </td>
                            </tr>
                            <tr class="required" id="trUserLevel" runat="server">
                                <td>类别：
                                </td>
                                <td class="mt-row">
                                    <asp:DropDownList ID="ddlUserLevel" runat="server">
                                        <asp:ListItem Value="0">请选择</asp:ListItem>
                                        <asp:ListItem Value="1">通知</asp:ListItem>
                                        <asp:ListItem Value="2">广告</asp:ListItem>
                                    </asp:DropDownList>
                                    <asp:CompareValidator ID="_ddlUserLevel" runat="server" ControlToValidate="ddlUserLevel"
                                        ErrorMessage="请选择类别！" Operator="NotEqual" ValueToCompare="0"></asp:CompareValidator>
                                </td>
                            </tr>
                            <tr>
                                <td>选择模板：
                                </td>
                                <td>
                                    <asp:DropDownList ID="ddlSmsTemplate" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlSmsTemplate_SelectedIndexChanged">
                                    </asp:DropDownList>
                                </td>
                            </tr>
                            <tr>
                                <td>发送通道：</td>
                                <td>
                                    <asp:DropDownList ID="ddlGangway" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlGangway_SelectedIndexChanged">
                                        <asp:ListItem Value="1">短信+站内</asp:ListItem>
                                        <asp:ListItem Value="2">短信</asp:ListItem>
                                        <asp:ListItem Value="3">站内</asp:ListItem>
                                    </asp:DropDownList>
                                </td>
                            </tr>
                            <tr>
                                <td>发送时间：
                                </td>
                                <td>
                                    <asp:TextBox ID="tbxDateAndTime" runat="server"></asp:TextBox>
                                </td>
                            </tr>
                        </table>
                    </div>

                    <div class="row mt-button">
                        <div class="col-lg-12">
                            <p>
                                <asp:Button ID="btnPost" runat="server" CssClass="btn btn-success btn-block" Text="发送" OnClick="btnPost_Click" />
                                <label class="btn btn-success btn-block" id="__mt_labBack" runat="server" onclick="back(this)">
                                    返回
                                </label>
                            </p>
                        </div>
                    </div>

                    <div class="alert alert-info mt-remark">
                        <b>注意事项：</b><br />
                        1、消息内容中，使用<b>{列名}</b>可引用到数据源中的值。<br />
                        2、当接收者非自定义时同时支持如下变量：<b>{学号}{姓名}{手机}{日期时间}{日期}{时间}</b>。<br />
                        3、当接收者是自定义时同时支持如下变量：<b>{日期时间}{日期}{时间}</b>。<br />
                        4、当数据源中的列，出现名称为“学号”时，自动设置接收者为学员，否则模式为自定义接收者。<br />
                    </div>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
