﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="LessonDay.aspx.cs"
    Inherits="MTCUN.Mobile.Student.LessonDay" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../User_Col/col_LessonDay.ascx" TagName="col_LessonDay" TagPrefix="uc1" %>
<%@ Register Src="../../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<%@ Register Src="../User_Col/col_StuHeader.ascx" TagName="col_StuHeader" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>我的课表</title>
    <link id="mobileCss" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <style type="text/css">
        .style1 {
            width: 100%;
            background-color: #ffffff;
            padding: 0px;
            margin: 0px;
        }

            .style1 td {
                border-left: 0px solid #cccccc;
            }

        .code {
            color: #838383;
        }

        .code {
            color: #838383;
        }

        .calendar_day {
            border-radius: 5px;
            background-color: khaki;
            width: 11%;
            height: 50px;
            padding: 2px;
            margin: 2px;
            position: relative;
            text-align: center;
        }

        .calendar_day_striking {
            border-radius: 15px;
            background-color: red;
            height: 15px;
            width: 15px;
            padding: 2px;
            margin: 2px;
            position: absolute;
            bottom: 2px;
            right: 2px;
            color: white;
            text-align: center;
            line-height: 15px;
            vertical-align: middle;
        }

        .calendar_day_lesson {
            background-color: darkorange;
            cursor: pointer;
        }

        .calendar_today {
            /*font-weight: bold;
            color: red;*/
            background-color: hotpink;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <div id="web_page_contents">
            <div class="biao_zhun_suo_jin">
                <div class="container">

                    <div style="text-align: center">
                        <asp:Label ID="labDateAndTime" runat="server" Font-Bold="true"></asp:Label>
                    </div>


                                <asp:Label ID="labMonth" runat="server"></asp:Label>
                                <asp:Repeater ID="repBlock" runat="server">
                                    <ItemTemplate>
                                        <div class="kuai-show">
                                            <table class="mt-table-b" border="0" style="table-layout: fixed; word-break: break-all; word-wrap: break-word">
                                                <tr>
                                                    <td style="width: 80px"><%# (int)Eval("LeStateID") == 0 ? "<span class ='label label-default'>未上课</span>": "<span class ='label label-success'>已上课</span>"%></td>
                                                    <td style="width: auto"></td>
                                                </tr>
                                                <tr>
                                                    <td style="width: auto">时段：</td>
                                                    <td style="width: auto; font-weight: bold">
                                                        <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),EndDate(Eval("EndDate")))%>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="width: auto">班级：</td>
                                                    <td style="width: auto">
                                                        <%# Eval("ClassName")%>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="width: auto">班号：</td>
                                                    <td style="width: auto">
                                                        <%# Eval("ClassID")%>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="width: 80px">课题：</td>
                                                    <td style="width: auto"><%#Eval("Subject")%></td>
                                                </tr>
                                                <tr>
                                                    <td style="width: 80px">课时：</td>
                                                    <td style="width: auto"><%#Eval("LDLessons")%></td>
                                                </tr>
                                                <tr>
                                                    <td style="width: auto">类型：</td>
                                                    <td style="width: auto">
                                                        <asp:Label runat="server" ID="labLessonType" Text='<%#(int)Eval("LessonType") == 1 ? "正常" : "补课"%>'></asp:Label><asp:Label
                                                            runat="server" ID="labPlace" ForeColor="Red" Text='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)" : "(本)") : ""%>'
                                                            ToolTip='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)表示在他班补课" : "(本)表示在本班补课") : ""%>'></asp:Label></td>
                                                </tr>
                                                <tr>
                                                    <td style="width: auto">讲师：</td>
                                                    <td style="width: auto">
                                                        <%#Eval("TeacherName")%></td>
                                                </tr>
                                                <tr>
                                                    <td style="width: auto">助教：</td>
                                                    <td style="width: auto">
                                                        <%#Eval("AssistantName")%></td>
                                                </tr>
                                                <tr>
                                                    <td>教室：</td>
                                                    <td>
                                                        <%#Eval("ClassroomName") %>
                                                    </td>
                                                </tr>
                                            </table>

                                            <div class="striking">
                                                <b>家庭作业：</b><%#Eval("LDRemark") %>
                                            </div>

                                            <div class="striking">
                                                <b>我的信息：</b>
                                                <table class="mt-table-b">
                                                    <tr>
                                                        <td style="width: 80px">出勤状态：</td>
                                                        <td><%# Rs.Items.GetAtState2(Eval("AtStateID"))%></td>
                                                    </tr>
                                                    <tr>
                                                        <td>消耗课时：</td>
                                                        <td><%#Eval("CurrentLessons") %></td>
                                                    </tr>
                                                    <tr>
                                                        <td>课堂表现：</td>
                                                        <td><%#Eval("Remark") %></td>
                                                    </tr>
                                                    <tr>
                                                        <td>课堂视频：</td>
                                                        <td><%#string.IsNullOrEmpty(Eval("VideoUrl").ToString()) ? "无" : string.Format("<label class='lab_button'><a href='video.aspx?id={0}' target='_blank'>播放</label></a>",Eval("LessonTimeID")) %></td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </ItemTemplate>
                                </asp:Repeater>


                    <div class="row mt-button">
                        <div class="col-lg-12">
                            <p>
                                <label class="btn btn-success btn-block" id="__mt_labBack" runat="server" onclick="back(this)">
                                    返回
                                </label>
                            </p>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </form>
</body>
</html>
