﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TimeConflict.aspx.cs" Inherits="MTCUN.Mobile.Student.TimeConflict" Title="排课冲突检测-学员" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title></title>
    <link id="mobileCss" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <div id="web_page_contents">
            <div class="search biao_zhun_suo_jin">
                <div class="container">
                    <div class="divpanel">
                        <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" DataKeyNames="LessonTimeID"
                            AutoGenerateColumns="false" OnRowDataBound="GridView1_RowDataBound">
                            <Columns>
                                <asp:TemplateField HeaderText="状态">
                                    <ItemTemplate>
                                        <asp:ImageButton runat="server" Enabled="false" ID="ibnLeStateID" ImageUrl='<%#String.Format(accTheme("lesson_{0}.gif"),Eval("LeStateID"))%>'
                                            ToolTip='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>' CommandName="LeStateID"
                                            CommandArgument='<%#Eval("LeStateID")%>' />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField DataField="Subject" ReadOnly="True" HeaderText="课题" />
                                <asp:TemplateField HeaderText="上课日期">
                                    <ItemTemplate>
                                        <span runat="server" id="spanDate"><%#Eval("StartDate","{0:d}")%></span><span style="color: Red; font-size: 9px">[<%#((DateTime)Eval("StartDate")).DayOfWeek.ToString("d")%>]</span>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="上课时段">
                                    <ItemTemplate>
                                        <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),swq.Tools.EndDate(Eval("EndDate")))%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField DataField="ClassroomName" ReadOnly="True" HeaderText="教室" />
                                <asp:BoundField DataField="TeacherName" ReadOnly="True" HeaderText="讲师" />
                                <asp:BoundField DataField="ClassID" ReadOnly="True" HeaderText="班号" />
                                <asp:BoundField DataField="ClassName" ReadOnly="True" HeaderText="班级名称" />
                                <asp:TemplateField HeaderText="上课类型">
                                    <ItemTemplate>
                                        <%# Rs.Items.GetLessonType(Eval("LessonType"))%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                    </div>

                    <div id="yesc" runat="server" class="striking" style="color: red; text-align: center">冲突课次如下</div>
                    <div id="noc" runat="server" class="kuai-show" style="height: 80px; text-align: center; vertical-align: middle; line-height: 80px">未发现任何冲突</div>

                    <div class="main">
                        <asp:Repeater ID="repBlock" runat="server" OnItemCommand="repBlock_ItemCommand"
                            OnItemDataBound="repBlock_ItemDataBound">
                            <ItemTemplate>
                                <asp:Panel ID="plItem" runat="server" CssClass="kuai">
                                    <h1 style="text-align: center"><%#Eval("ClassName")%></h1>
                                    <table class=" table_simple_kuan" cellspacing="0" border="0">
                                        <tr>
                                            <td style="width: 70px"><%# (int)Eval("LeStateID") == 0 ? "<span class ='weishangke'>未上课</span>": "<span class ='yishangke'>已上课</span>"%></td>
                                            <td style="width: auto"></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">班号：</td>
                                            <td style="width: auto"><%#Eval("ClassID")%></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">上课日期：</td>
                                            <td style="width: auto">
                                                <%#Eval("StartDate","{0:d}")%><span style="color: Red; font-size: 9px">[<%#GetWeek(Eval("StartDate"))%>]</span></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">上课时段：</td>
                                            <td style="width: auto">
                                                <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),EndDate(Eval("EndDate")))%>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">类型：</td>
                                            <td style="width: auto">
                                                <asp:Label runat="server" ID="labLessonType" Text='<%#(int)Eval("LessonType") == 1 ? "正常" : "补课"%>'></asp:Label><asp:Label
                                                    runat="server" ID="labPlace" ForeColor="Red" Text='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)" : "(本)") : ""%>'
                                                    ToolTip='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)表示在他班补课" : "(本)表示在本班补课") : ""%>'></asp:Label></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">讲师：</td>
                                            <td style="width: auto">
                                                <%#Eval("TeacherName")%></td>
                                        </tr>
                                        <tr>
                                            <td>教室：</td>
                                            <td>
                                                <%#Eval("ClassroomName") %>
                                            </td>
                                        </tr>
                                    </table>
                                </asp:Panel>

                            </ItemTemplate>
                        </asp:Repeater>
                    </div>

                    <div class="row mt-button">
                        <div class="col-lg-12">
                            <p>
                                <label class="btn btn-success btn-block" id="__mt_labBack" runat="server" onclick="back(this)">
                                    返回
                                </label>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
