﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="LessonTime.aspx.cs" Inherits="MTCUN.Mobile.Teacher.LessonTime"
    Title="排课信息-老师" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Register Src="../../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<%@ Register Src="../../UserCol/Ann.ascx" TagName="Ann" TagPrefix="uc3" %>
<%@ Register Src="../User_Col/col_Header.ascx" TagName="col_Header" TagPrefix="uc4" %>
<%@ Register Src="../User_Col/col_ClassControlPanel.ascx" TagName="col_ClassControlPanel" TagPrefix="uc5" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />

    <script type="text/javascript">
        function OpenSearch() {
            if (setContent.style.display == 'none') {
                setContent.style.display = 'block';
                setControl.innerHTML = '▲排课面板';
                __mt__setSearchCookie(1);
            }
            else {
                setContent.style.display = 'none';
                setControl.innerHTML = '▼排课面板';
                __mt__setSearchCookie(0);
            }
        }

        function defaultSearchState() {
            var num = __mt__getSearchCookie();
            if (num == 1) {
                setContent.style.display = 'block';
                setControl.innerHTML = '▲排课面板';
            }
            else {
                setContent.style.display = 'none';
                setControl.innerHTML = '▼排课面板';
            }
        }
    </script>


    <script type="text/javascript">
        function OpenClass() {
            if (setContent2.style.display == 'none') {
                setContent2.style.display = 'block';
                setControl2.innerHTML = '▲班级概要';
                __mt__setClassCookie(1);
            }
            else {
                setContent2.style.display = 'none';
                setControl2.innerHTML = '▼班级概要';
                __mt__setClassCookie(0);
            }
        }

        function defaultClassState() {
            var num = __mt__getClassCookie();
            if (num == 1) {
                setContent2.style.display = 'block';
                setControl2.innerHTML = '▲班级概要';
            }
            else {
                setContent2.style.display = 'none';
                setControl2.innerHTML = '▼班级概要';
            }
        }
    </script>

    <style type="text/css">
        .ld {
            margin: 0px;
            padding: 0px;
            list-style: none;
        }

            .ld li {
                display: block;
                margin: 2px;
            }

                .ld li span {
                    display: inline-block;
                }
    </style>
</head>
<body onload="defaultSearchState();defaultClassState()">
    <form id="form1" runat="server">
        <uc3:Ann ID="Ann1" runat="server" />
        <uc4:col_Header ID="col_Header1" runat="server" />
        <div id="web_page_contents">
            <div class="biao_zhun_suo_jin">
                <div class="container">

                    <uc5:col_ClassControlPanel ID="col_ClassControlPanel1" runat="server" />

                    <div class="setandsearch" style="margin-bottom: 5px; margin-top:5px">
                        <ul class="mt-listitems">
                            <li>
                                <asp:HyperLink ID="hlkAdd" runat="server" CssClass="btn btn-default">增加上课</asp:HyperLink>
                            </li>
                            <li>
                                <asp:LinkButton ID="lbnClear" runat="server" CssClass="btn btn-default" OnClick="lbnClear_Click" OnClientClick="return confirm('执行此操作，将删除所有未上课的排课信息，您确定要这么做？');">清除未上课</asp:LinkButton>
                            </li>
                            <li>
                                <div id="setControl2" onclick="OpenClass()" class="btn btn-default">
                                    ▼班级概要
                                </div>
                            </li>
                        </ul>
                        <div id="setContent2" style="display: none">

                            <div class="kuai">
                                <asp:FormView ID="fvClass" runat="server" Width="100%">
                                    <ItemTemplate>
                                        <table class="mt-table-m">
                                            <tr>
                                                <td>班号：<%#Eval("ClassID")%></td>
                                            </tr>
                                            <tr>
                                                <td>班级名称：<%#Eval("ClassName")%></td>
                                            </tr>
                                            <tr>
                                                <td>上课规律：<%#Eval("TimeRule")%></td>
                                            </tr>
                                            <tr>
                                                <td>开课时间：<%#Eval("StartDate","{0:d}")%></td>
                                            </tr>
                                            <tr>
                                                <td>总课时：<%#Eval("Lessons","{0:0.##}")%></td>
                                            </tr>
                                            <tr>
                                                <td>每课分钟：<%#Eval("LessonMinute")%></td>
                                            </tr>

                                        </table>
                                    </ItemTemplate>
                                </asp:FormView>

                                <table class="mt-table-m">
                                    <tr>
                                        <td>排课起始日：
                                        </td>
                                        <td>
                                            <asp:Label ID="labStartDate" runat="server"></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>可排课时数：
                                        </td>
                                        <td>
                                            <asp:Label ID="labLessons" runat="server"></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>排课完成度：
                                        </td>
                                        <td>
                                            <uc2:Progress ID="Progress1" runat="server" Text="课时" Width="40%" />
                                        </td>
                                    </tr>
                                </table>
                            </div>

                        </div>
                    </div>

                    <div class="main">
                        <asp:Repeater ID="repBlock" runat="server" OnItemCommand="repBlock_ItemCommand"
                            OnItemDataBound="repBlock_ItemDataBound">
                            <ItemTemplate>

                                <asp:Panel ID="plItem" runat="server" CssClass="kuai">



                                    <table class="mt-table-m">
                                        <tr>
                                            <td style="width: 80px"><%# (int)Eval("LeStateID") == 0 ? "<span class ='label label-default'>未上课</span>": "<span class ='label label-success'>已上课</span>"%></td>
                                            <td style="width: auto"></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">课题：</td>
                                            <td style="width: auto"><%#Eval("Subject")%></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">上课日期：</td>
                                            <td style="width: auto">
                                                <asp:HyperLink runat="server" ID="hlkClassInfo" Text='<%#Eval("StartDate","{0:d}")%>'
                                                    NavigateUrl='<%# string.Format("Attend.aspx?ClassID={0}&LessonTimeID={1}&GetUrl={2}",Eval("ClassID"),Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                                                <span style="color: Red;">[<%#GetWeek(Eval("StartDate"))%>]</span></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">上课时段：</td>
                                            <td style="width: auto">
                                                <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),EndDate(Eval("EndDate")))%>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">类型：</td>
                                            <td style="width: auto">
                                                <asp:Label runat="server" ID="labLessonType" Text='<%#(int)Eval("LessonType") == 1 ? "正常" : "补课"%>'></asp:Label><asp:Label
                                                    runat="server" ID="labPlace" ForeColor="Red" Text='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)" : "(本)") : ""%>'
                                                    ToolTip='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)表示在他班补课" : "(本)表示在本班补课") : ""%>'></asp:Label></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">课时：</td>
                                            <td style="width: auto"><%#Eval("Lessons","{0:0.##}")%></td>
                                        </tr>

                                        <tr>
                                            <td style="width: auto">讲师：</td>
                                            <td style="width: auto">
                                                <%#Eval("TeacherName")%></td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">助教：</td>
                                            <td style="width: auto">
                                                <%#Eval("AssistantName")%></td>
                                        </tr>
                                        <tr>
                                            <td>教室：</td>
                                            <td>
                                                <%#Eval("ClassroomName") %>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="width: auto">出勤：</td>
                                            <td style="width: auto">实到:<%#Eval("FactCount")%>旷课:<%#Eval("TruancyCount")%>请假:<%#Eval("LeaveCount")%></td>
                                        </tr>
                                    </table>

                                    <table class="mt-table-m">
                                        <tr>
                                            <td>
                                                <asp:HyperLink runat="server" CssClass="btn btn-default" NavigateUrl='<%#string.Format("PostLessonTime.aspx?LessonTimeID={0}&ClassID={1}&GetUrl={2}",Eval("LessonTimeID"),Eval("ClassID"),swq.Web.PathAndQuery())%>'
                                                    ID="hlkEdit" Text="编辑" />
                                            </td>
                                            <td>
                                                <asp:HyperLink runat="server" CssClass="btn btn-success" ID="hlkAttend" Text="点名" NavigateUrl='<%# string.Format("Attend.aspx?ClassID={0}&LessonTimeID={1}&GetUrl={2}",Eval("ClassID"),Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                                            </td>
                                        </tr>
                                    </table>


                                </asp:Panel>

                            </ItemTemplate>
                        </asp:Repeater>
                    </div>

                    <div class="pager_button">
                        <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
                    </div>

                    <div class="row mt-button">
                        <div class="col-lg-12">
                            <p>
                                <label class="btn btn-success btn-block" id="__mt_labBack" runat="server" onclick="back(this)">
                                    返回
                                </label>
                            </p>
                        </div>
                    </div>

                    <div class="alert alert-info mt-remark">
                        <b>注意事项：</b><br />
                        1、点击“清除未上课”仅删除未上课的排课，不影响已考勤的排课。<br />
                    </div>

                </div>
            </div>
        </div>
    </form>
</body>
</html>
