﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Index.aspx.cs"
    Inherits="MTCUN.Mobile.frame.Index" Title="首页" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../User_Col/col_Header.ascx" TagName="col_Header" TagPrefix="uc1" %>
<%@ Register Src="../User_Col/col_Slide.ascx" TagName="col_Slide" TagPrefix="uc2" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="mobileCss" runat="server" href="../themes/mobile.css" rel="stylesheet"
        type="text/css" />

    <style type="text/css">
        * {
            margin: 0;
            padding: 0;
            list-style-type: none;
        }

        .banner {
            width: 100%;
            /*height: 560px;*/
            /*background: black;*/
            /*子绝父相*/
            position: relative;
            /*超出部分全部隐藏，解决横向滚动条*/
            overflow: hidden;
        }

            .banner ul {
                position: absolute;
            }

                .banner ul li {
                    /*这个100%是相对于父盒子的（会把父盒子的宽度继承过来,如父盒子300%,这这里的100%就会相当于300%）*/
                    width: 100%;
                    height: 200px;
                    float: left;
                    background: no-repeat center center;
                    background-size: cover;
                }
            /*.banner ul li:nth-child(1){*/
            /*background: url('../themes/image/1.jpg') no-repeat center center;*/
            /*}*/
            /*.banner ul li:nth-child(2){*/
            /*background: url('../themes/image/2.jpg') no-repeat center center;*/
            /*}*/
            /*.banner ul li:nth-child(3){*/
            /*background: url('../themes/image/3.jpg') no-repeat center center;*/
            /*}*/
            .banner ol {
                /*width: 60px;*/
                height: 20px;
                background: rgba(0,0,0,0.5);
                position: absolute;
                left: 50%;
                /*margin-left: -40px;*/
                bottom: 30px;
                padding: 0 10px;
                border-radius: 10px;
                display: none; /**圆点按键隐藏了**/
            }

                .banner ol li {
                    width: 10px;
                    height: 10px;
                    float: left;
                    margin: 5px 5px;
                    background: rgba(255,255,255,0.5);
                    border-radius: 50%;
                    cursor: pointer;
                }

                .banner ol .current {
                    background: rgba(255,255,255,1);
                }

            .banner i {
                width: 58px;
                height: 120px;
                position: absolute;
                top: 50%;
                margin-top: -60px;
                cursor: pointer;
                border-radius: 5px;
                display: none;
            }

            .banner .left {
                left: 60px;
                background: url('../themes/image/left_right.png') no-repeat 0 0px;
            }

            .banner .right {
                right: 60px;
                background: url('../themes/image/left_right.png') no-repeat 0px -120px;
            }

                .banner .left:hover, .banner .right:hover {
                    background-color: rgba(0, 0, 0, 0.31);
                }

        select {
            background-color: #4bbd2b;
            border-width: 1px;
            border: 1px solid #ffffff;
            color: white;
            padding-right: 10px;
        }
    </style>

    <script type="text/javascript">
        function onlink(url) {
            //alert(url);
            if (url != '')
                window.location = url;
        }

        $(function () { //页面加载完毕才执行

            //=========设置参数==========
            //图片统一高度：
            var images_height = '200px';
            //图片路径/链接(数组形式):
            var images_count = images_url.length;

            //创建节点
            //图片列表节点
            for (var j = 0; j < images_count + 1; j++) {
                $('.banner ul').append('<li></li>')
            }
            //轮播圆点按钮节点
            for (var j = 0; j < images_count; j++) {
                if (j == 0) {
                    $('.banner ol').append('<li class="current"></li>')
                } else {
                    $('.banner ol').append('<li></li>')
                }
            }

            //载入图片
            $('.banner ul li').css('background-image', 'url(' + images_url[0] + ')');
            $('.banner ul li').unbind("click").click(function () { onlink(images_link[0]); });
            $.each(images_url, function (key, value) {
                $('.banner ul li').eq(key).css('background-image', 'url(' + value + ')');
            });

            $('.banner').css('height', images_height);

            $('.banner ul').css('width', (images_count + 1) * 100 + '%');

            $('.banner ol').css('width', images_count * 20 + 'px');
            $('.banner ol').css('margin-left', -images_count * 20 * 0.5 - 10 + 'px');

            //=========================

            var num = 0;
            //获取窗口宽度
            var window_width = $(window).width();
            $(window).resize(function () {
                window_width = $(window).width();
                $('.banner ul li').css({ width: window_width });
                clearInterval(timer);
                nextPlay();
                timer = setInterval(nextPlay, 2000);
            });
            //console.log(window_width);
            $('.banner ul li').width(window_width);
            //轮播圆点
            $('.banner ol li').mouseover(function () {//用hover的话会有两个事件(鼠标进入和离开)
                $(this).addClass('current').siblings().removeClass('current');
                //第一张图： 0 * window_width
                //第二张图： 1 * window_width
                //第三张图： 2 * window_width
                //获取当前编号
                var i = $(this).index();
                //console.log(i);
                $('.banner ul').stop().animate({ left: -i * window_width }, 500);
                num = i;
                $('.banner ul li').unbind("click").click(function () { onlink(images_link[num]); });

            });
            //自动播放
            var timer = null;
            function prevPlay() {
                num--;

                if (num < 0) {
                    //悄悄把图片跳到最后一张图(复制页,与第一张图相同),然后做出图片播放动画，left参数是定位而不是移动的长度
                    $('.banner ul').css({ left: -window_width * images_count }).stop().animate({ left: -window_width * (images_count - 1) }, 500);
                    num = images_count - 1;
                } else {
                    //console.log(num);
                    $('.banner ul').stop().animate({ left: -num * window_width }, 500);
                }
                if (num == images_count - 1) {
                    $('.banner ol li').eq(images_count - 1).addClass('current').siblings().removeClass('current');
                } else {
                    $('.banner ol li').eq(num).addClass('current').siblings().removeClass('current');

                }

                $('.banner ul li').unbind("click").click(function () { onlink(images_link[num]); });
            }
            function nextPlay() {
                num++;

                if (num > images_count) {
                    //播放到最后一张(复制页)后,悄悄地把图片跳到第一张,因为和第一张相同,所以难以发觉,
                    $('.banner ul').css({ left: 0 }).stop().animate({ left: -window_width }, 500);
                    //css({left:0})是直接悄悄改变位置，animate({left:-window_width},500)是做出移动动画
                    //随后要把指针指向第二张图片,表示已经播放至第二张了。
                    num = 1;
                } else {
                    //在最后面加入一张和第一张相同的图片，如果播放到最后一张，继续往下播，悄悄回到第一张(肉眼看不见)，从第一张播放到第二张
                    //console.log(num);
                    $('.banner ul').stop().animate({ left: -num * window_width }, 500);
                }
                if (num == images_count) {
                    $('.banner ol li').eq(0).addClass('current').siblings().removeClass('current');
                    $('.banner ul li').unbind("click").click(function () { onlink(images_link[0]); });
                } else {
                    $('.banner ol li').eq(num).addClass('current').siblings().removeClass('current');
                    $('.banner ul li').unbind("click").click(function () { onlink(images_link[num]); });
                }
            }
            timer = setInterval(nextPlay, 2000);
            //鼠标经过banner，停止定时器,离开则继续播放
            $('.banner').mouseenter(function () {
                clearInterval(timer);
                //左右箭头显示(淡入)
                $('.banner i').fadeIn();
            }).mouseleave(function () {
                timer = setInterval(nextPlay, 2000);
                //左右箭头隐藏(淡出)
                $('.banner i').fadeOut();
            });
            //播放下一张
            $('.banner .right').click(function () {
                nextPlay();
            });
            //返回上一张
            $('.banner .left').click(function () {
                prevPlay();
            });
        });
    </script>

    <script type="text/javascript">
        function GetPGID() {
            var pd = document.getElementById("ddlPurviewGroup");
            return pd.options[pd.selectedIndex].value;
        }

        function RemindNum() {
            var rn = document.getElementById("divRemindNum");
            if (rn == null)
                return;
            if (remindCount > 0) {
                if (remindCount > 99) {
                    remindCount = 99 + "+";
                }
                rn.innerText = remindCount;
                rn.style.display = "inline-table";
            }
            else {
                rn.innerText = "";
                rn.style.display = "none";
            }

            //Cover();
        }

        function Cover() {
            var pd = document.getElementById("ddlPurviewGroup");
            var sid = pd.options[pd.selectedIndex].value;
            var mr1 = document.getElementById("divRemind");
            var mr2 = document.getElementById("divMsg");
            var mr3 = document.getElementById("divSearch");


            var div_pd = document.getElementById("pg" + sid);
            if (mr1 != null) { div_pd.innerHTML += mr1.innerHTML; }
            if (mr2 != null) { div_pd.innerHTML += mr2.innerHTML; }
            if (mr3 != null) { div_pd.innerHTML += mr3.innerHTML; }


        }
    </script>
</head>
<body onload="Cover();RemindNum();">
    <form id="form1" runat="server" class="cover_bg1">
        <uc1:col_Header ID="col_Header1" runat="server" />
        <uc2:col_Slide ID="col_Slide1" runat="server" />

        <div id="web_page_contents">

            <ul class="mt-listitems">
                <li>
                    <div style="font-weight: bold; width: 60px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; text-align: center">
                        <asp:Literal ID="litName" runat="server"></asp:Literal>
                    </div>
                </li>
                <li>校区：</li>
                <li>
                    <asp:DropDownList ID="ddlSchool" Width="100px" runat="server" CssClass="schoollist" DataTextField="SchoolName" DataValueField="SchoolID"
                        AutoPostBack="True" OnSelectedIndexChanged="ddlSchool_SelectedIndexChanged">
                    </asp:DropDownList></li>
                <li>角色：</li>
                <li>
                    <asp:DropDownList ID="ddlPurviewGroup" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlPurviewGroup_SelectedIndexChanged" DataTextField="PurviewGroupName" DataValueField="PurviewGroupID">
                    </asp:DropDownList></li>
            </ul>

            <div style="border-bottom: 1px solid #c0c0c0"></div>
            <div class="search biao_zhun_suo_jin">
                <div style="margin-top: 30px">

                    <div style="display: none" class="inline_block" id="pg1" runat="server">
                        <div class="pg1_yxdj cover_link" onmouseover="__mt_NavMouseover(this,'pg1_yxdj cover_link')" onmouseout="__mt_NavMouseout(this,'pg1_yxdj cover_link')" onclick="window.location = '../Consultant/PostPotential.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">意向登记</div>
                        </div>

                        <div class="pg1_yxhf cover_link" onmouseover="__mt_NavMouseover(this,'pg1_yxhf cover_link')" onmouseout="__mt_NavMouseout(this,'pg1_yxhf cover_link')" onclick="window.location = '../Consultant/PotentialList.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">意向回访</div>
                        </div>

                        <%--                        <div class="pg1_xybm cover_link" onmouseover="__mt_NavMouseover(this,'pg1_xybm cover_link')" onmouseout="__mt_NavMouseout(this,'pg1_xybm cover_link')" onclick="window.location = '../Register/PostStudent.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">学员报名</div>
                        </div>

                        <div class="pg1_kjbb cover_link" onmouseover="__mt_NavMouseover(this,'pg1_kjbb cover_link')" onmouseout="__mt_NavMouseout(this,'pg1_kjbb cover_link')" onclick="window.location = '../Register/AddStudent.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">快捷报班</div>
                        </div>

                        <div class="pg1_xycx cover_link" onmouseover="__mt_NavMouseover(this,'pg1_xycx cover_link')" onmouseout="__mt_NavMouseout(this,'pg1_xycx cover_link')" onclick="window.location = '../Register/StudentList.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">查询学员</div>
                        </div>--%>

                        <div class="pg1_kbcx cover_link" onmouseover="__mt_NavMouseover(this,'pg1_kbcx cover_link')" onmouseout="__mt_NavMouseout(this,'pg1_kbcx cover_link')" onclick="window.location = '../Register/ClassList.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">开班查询</div>
                        </div>
                    </div>

                    <div style="display: none" class="inline_block" id="pg2" runat="server">
                        <div class="pg2_wdbj cover_link" onmouseover="__mt_NavMouseover(this,'pg2_wdbj cover_link')" onmouseout="__mt_NavMouseout(this,'pg2_wdbj cover_link')" onclick="window.location = '../Teacher/ClassList.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">我的班级</div>
                        </div>

                        <div class="pg2_wdkb cover_link" onmouseover="__mt_NavMouseover(this,'pg2_wdkb cover_link')" onmouseout="__mt_NavMouseout(this,'pg2_wdkb cover_link')" onclick="window.location = '../Teacher/LessonTable.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">我的课表</div>
                        </div>

                        <%--                        <div class="pg2_xyqd cover_link" onmouseover="__mt_NavMouseover(this,'pg2_xyqd cover_link')" onmouseout="__mt_NavMouseout(this,'pg2_xyqd cover_link')" onclick="window.location = '../Tools/IDSignIn.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">学员签到</div>
                        </div>--%>
                    </div>

                    <div style="display: none" class="inline_block" id="pg3" runat="server">
                                                <div class="pg3_ksbj cover_link" onmouseover="__mt_NavMouseover(this,'pg3_ksbj cover_link')" onmouseout="__mt_NavMouseout(this,'pg3_ksbj cover_link')" onclick="window.location = '../Class/PostClass.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">开设班级</div>
                        </div>

                        <div class="pg1_kbcx cover_link" onmouseover="__mt_NavMouseover(this,'pg1_kbcx cover_link')" onmouseout="__mt_NavMouseout(this,'pg1_kbcx cover_link')" onclick="window.location = '../Class/ClassList.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">班级查询</div>
                        </div>

                        <div class="pg3_kczb cover_link" onmouseover="__mt_NavMouseover(this,'pg3_kczb cover_link')" onmouseout="__mt_NavMouseout(this,'pg3_kczb cover_link')" onclick="window.location = '../Class/LessonTable.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">课程总表</div>
                        </div>

                        <div class="pg3_jrbj cover_link" onmouseover="__mt_NavMouseover(this,'pg3_jrbj cover_link')" onmouseout="__mt_NavMouseout(this,'pg3_jrbj cover_link')" onclick="window.location = '../Class/LessonDay.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">今日班级</div>
                        </div>

                        <div class="pg3_kstj cover_link" onmouseover="__mt_NavMouseover(this,'pg3_kstj cover_link')" onmouseout="__mt_NavMouseout(this,'pg3_kstj cover_link')" onclick="window.location = '../Affairs/TeacherLessons.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">课时统计</div>
                        </div>
                    </div>

                    <div style="display: none" class="inline_block" id="pg4" runat="server">
                        <div class="pg4_xfd cover_link" onmouseover="__mt_NavMouseover(this,'pg4_xfd cover_link')" onmouseout="__mt_NavMouseout(this,'pg4_xfd cover_link')" onclick="window.location = '../Finance/Bills.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">消费单</div>
                        </div>

                        <div class="pg4_czd cover_link" onmouseover="__mt_NavMouseover(this,'pg4_czd cover_link')" onmouseout="__mt_NavMouseout(this,'pg4_czd cover_link')" onclick="window.location = '../Finance/Payments.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">充值单</div>
                        </div>

                        <div class="pg4_qfd cover_link" onmouseover="__mt_NavMouseover(this,'pg4_qfd cover_link')" onmouseout="__mt_NavMouseout(this,'pg4_qfd cover_link')" onclick="window.location = '../Finance/Arrearage.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">欠费单</div>
                        </div>

                        <div class="pg4_dzd cover_link" onmouseover="__mt_NavMouseover(this,'pg4_dzd cover_link')" onmouseout="__mt_NavMouseout(this,'pg4_dzd cover_link')" onclick="window.location = '../Finance/FeeTable.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">对账单</div>
                        </div>
                    </div>

                    <div style="display: none" class="inline_block" id="pg7" runat="server">
                        <div class="pg7_jrfx cover_link" onmouseover="__mt_NavMouseover(this,'pg7_jrfx cover_link')" onmouseout="__mt_NavMouseout(this,'pg7_jrfx cover_link')" onclick="window.location = '../Report/Analysis.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                            <div class="cover_name">今日分析</div>
                        </div>
                    </div>

                    <div style="display: none">

                        <div style="display: none" id="divRemind" runat="server">
                            <div class="pg_tx cover_link" onmouseover="__mt_NavMouseover(this,'pg_tx cover_link')" onmouseout="__mt_NavMouseout(this,'pg_tx cover_link')" onclick="window.location = '../frame/remind.aspx?remindtype='+GetPGID() + '&geturl=<%=swq.Web.PathAndQuery() %>';">
                                <div class="cover_name">提醒</div>
                                <div id="divRemindNum" style="display: none; border-radius: 10px; position: absolute; background-color: rgba(255, 0, 0,0.9); color: #ffffff; width: 18px; height: 18px; left: 1px; top: 5px; line-height: 18px; vertical-align: middle; text-align: center"></div>
                            </div>
                        </div>

                        <div style="display: none;" id="divMsg" runat="server">
                            <div class="pg_xx cover_link" onmouseover="__mt_NavMouseover(this,'pg_xx cover_link')" onmouseout="__mt_NavMouseout(this,'pg_xx cover_link')" onclick="window.location = '../Msg/Topic.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                                <div class="cover_name">消息</div>
                                <div id="divMsgNum" style="display: none; border-radius: 10px; position: absolute; background-color: rgba(255, 0, 0,0.9); color: #ffffff; width: 18px; height: 18px; left: 1px; top: 5px; line-height: 18px; vertical-align: middle; text-align: center"></div>
                            </div>
                        </div>

                        <div style="display: none;" id="divSearch" runat="server">
                            <div class="pg_cx cover_link" onmouseover="__mt_NavMouseover(this,'pg_xx cover_link')" onmouseout="__mt_NavMouseout(this,'pg_xx cover_link')" onclick="window.location = '../Search/SearchList.aspx?geturl=<%=swq.Web.PathAndQuery() %>'">
                                <div class="cover_name">查询</div>
                            </div>
                        </div>

                    </div>

                </div>
            </div>

            <div style="margin-top: 30px; border-top-left-radius: 5px; border-top-right-radius: 5px; background-color: #4bbd2b; width: 80px; padding: 6px; color: #ffffff; text-align: center">学校头条</div>
            <div style="border-bottom: 1px solid #e6e6e6"></div>
            <div class="annkuai" style="">
                <asp:Repeater ID="repAnns" runat="server">
                    <ItemTemplate>
                        <div class="annrowline" style="" onclick="window.location = '<%#string.Format("../User/AnnShow.aspx?AnnID={0}&geturl={1}",Eval("AnnID"),swq.Web.PathAndQuery()) %>'">
                            <div class="annrow">
                                <div class="name">
                                    <div class="ann_ico" style="float: left; background-position: left; padding-left: 25px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; width: 220px">
                                        <%# swq.Tools.HtmlEncode(Eval("Subject")) %>
                                    </div>
                                </div>
                                <div class="time">
                                    <%#Eval("DateAndTime","{0:yy-MM-dd}")%>
                                </div>
                            </div>
                        </div>

                    </ItemTemplate>
                </asp:Repeater>
            </div>

        </div>
    </form>
</body>
</html>
