﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="sendmsg.aspx.cs"
    Inherits="MTCUN.Mobile.sendmsg" Title="发送微信消息" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <link id="mobileCss" runat="server" href="https://cdn.staticfile.org1/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />

    <style type="text/css">
        .wx_form {
            border-radius: 5px;
            background-color: white;
            padding: 10px;
            border: 1px solid #e8e8e8;
            margin: 1px;
            margin-top: 5px;
        }

        .smallimgs {
            margin: 4px;
            border-radius: 0px;
            width: 6em;
            height: 6em;
        }

        textarea {
            width: 100%;
        }

        .weui-navbar a {
            text-decoration: none;
            color: #333;
        }

        .weui_tab_bd_item {
            display: none;
            height: 100%;
            overflow: auto;
        }

            .weui_tab_bd_item.weui_tab_bd_item_active {
                display: block;
            }
    </style>

    <script type="text/javascript">

        var localIds = null;
        var index = 0;

        wx.ready(function () {
            document.querySelector('#chooseImage').onclick = function () {
                localIds = null;
                index = 0;
                wx.chooseImage({
                    count: 3, // 最多可以选择的图片张数，默认9
                    sizeType: ['compressed'],
                    success: function (res) {
                        alert('已选择 ' + res.localIds.length + ' 张图片');
                        localIds = res.localIds;
                        $("#previewImage").text = "";
                        document.getElementById("hfdArticleImages").value = "";

                        upload();
                    }
                });
            };


            function upload() {

                wx.uploadImage({
                    localId: localIds[index], // 须要上传的图片的本地ID，由chooseImage接口获得
                    isShowProgressTips: 1, // 默觉得1，显示运行进度提示
                    success: function (res) {
                        var serverId = res.serverId; // 返回图片的服务器端ID
                        document.getElementById("hfdArticleImages").value += serverId + ",";//保存上传后的文件ID
                        var html = '<img class="smallimgs" src="' + localIds[index] + '">';
                        $("#previewImage").append(html);

                        index++;
                        if (index < localIds.length)
                            setTimeout(upload, 800);
                    }
                });
            }

        });

        $(function () {
            $('.weui-navbar__item').on('click', function () {
                $(this).addClass('weui-bar__item_on').siblings('.weui-bar__item_on').removeClass('weui-bar__item_on');

                //内容切换
                $(".weui-tab__panel .weui_tab_bd_item_active").removeClass('weui_tab_bd_item_active');
                var data_toggle = jQuery(this).attr("href");
                $(data_toggle).addClass("weui_tab_bd_item_active");
                document.getElementById("hfdArticleType").value = data_toggle;
            });


            $("#rblMsgType").change(function () {
                //code...}); //为Select添加事件，当选择其中一项时触发
                var checkText = $("#rblMsgType").find("option:selected").text(); //获取Select选择的text
                var checkValue = $("#rblMsgType").val(); //获取Select选择的Value
                var checkIndex = $("#rblMsgType").get(0).selectedIndex; //获取Select选择的索引值
                var maxIndex = $("#rblMsgType option:last").attr("index"); //获取Select最大的索引值
                $("#div7").hide();
                $("#div8").hide();
                $("#div9").hide();
                $("#div13").hide();
                $("#div14").hide();
                $("#divXQ").hide();

                $("#div" + checkValue).show();
                if (checkValue == "7" || checkValue == "13" || checkValue == "14") {
                    $("#divXQ").show();
                }

            });

        });
    </script>
</head>
<body>

    <form id="form1" runat="server">
        <div id="web_page_contents">
            <div class="search biao_zhun_suo_jin">
                <div class="container">

                    <div class="kuai-show form">
                        <div class="wx_form1">
                            <h1>模版消息</h1>


                            <div class="mt-row">
                                <span class="weui-cells__title">消息类型：</span>
                                <asp:DropDownList ID="rblMsgType" runat="server" CssClass="weui-select weui-btn weui-btn_default" Width="100%">
                                    <asp:ListItem Value="0" Text="==请选择=="></asp:ListItem>
                                    <asp:ListItem Value="7">作业通知</asp:ListItem>
                                    <asp:ListItem Value="8">放假通知</asp:ListItem>
                                    <asp:ListItem Value="9">调课通知</asp:ListItem>
                                    <asp:ListItem Value="13">上课表现</asp:ListItem>
                                    <asp:ListItem Value="14">作品展示</asp:ListItem>
                                </asp:DropDownList>
                            </div>

                            <div runat="server" id="div7" style="display: none">
                                <div class="weui-cells__title">作业内容：</div>
                                <asp:TextBox ID="tbxWork" runat="server" CssClass="weui-textarea" Height="63px" TextMode="MultiLine"></asp:TextBox>

                                <asp:CheckBox ID="cbxUpdate" runat="server" Checked="True" Text="同步更新到排课信息" />


                                <div class="weui-cells__title">作业要求：</div>

                                <asp:TextBox ID="tbxWork2" CssClass="weui-textarea" runat="server" Height="40px" TextMode="MultiLine"></asp:TextBox>
                            </div>

                            <div runat="server" id="div8" style="display: none">
                                <div class="weui-cells__title">放假原因：</div>
                                <asp:TextBox ID="tbxHoliday" CssClass="weui-textarea" runat="server" Height="66px" TextMode="MultiLine"></asp:TextBox>
                            </div>

                            <div runat="server" id="div9" style="display: none">
                                <div class="weui-cells__title">所在班级：</div>

                                <asp:TextBox ID="tbxClassName" CssClass="weui-textarea" runat="server" TextMode="MultiLine"></asp:TextBox>

                                <div class="weui-cells__title">调课原因：</div>
                                <asp:TextBox ID="tbxChangeCourse" CssClass="weui-textarea" runat="server" Height="54px" TextMode="MultiLine"></asp:TextBox>

                                <div class="weui-cells__title">时间调整到：</div>
                                <asp:TextBox ID="tbxToDate" CssClass="weui-textarea" runat="server" TextMode="MultiLine"></asp:TextBox>
                            </div>

                            <div runat="server" id="div13" style="display: none">
                                <div class="weui-cells__title">上课表现：</div>
                                <asp:TextBox ID="tbxLessonShow" CssClass="weui-textarea" runat="server" Height="57px" TextMode="MultiLine"></asp:TextBox>
                            </div>

                            <div runat="server" id="div14" style="display: none">
                                <div class="weui-cells__title">作品说明：</div>
                                <asp:TextBox ID="tbxZP" runat="server" CssClass="weui-textarea" Height="57px" TextMode="MultiLine"></asp:TextBox>
                            </div>

                            <asp:CheckBox ID="cbxSMS" Visible="false" Checked="false" Text="同时短信通知" runat="server" />
                        </div>
                    </div>

                    <div class="kuai-show form1  wx_form1" id="divXQ" style="display: none;">
                        <h1>图文详情</h1>
                        <div class="weui-tab1">
                            <div class="weui-navbar" style="position: relative">
                                <a class="weui-navbar__item weui-bar__item_on" href="#tab1">图片
                                </a>
                                <a class="weui-navbar__item" href="#tab4">文库
                                </a>
                            </div>

                            <div class="weui-tab__panel" style="margin-bottom: 20px; padding-top: 10px; padding-bottom: 5px; border-bottom-width: 0px">
                                <div id="tab1" class="weui_tab_bd_item weui_tab_bd_item_active">
                                    <div id="chooseImage" class=" weui-btn weui-btn_plain-default" style="width: 120px">上传图片</div>
                                    <div id="previewImage"></div>
                                </div>
                                <div id="tab4" class="weui_tab_bd_item">
                                    <div style="text-align: center">
                                        <asp:DropDownList ID="ddlArticle" CssClass="weui-select weui-btn weui-btn_default" Width="100%" runat="server">
                                        </asp:DropDownList>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div>

                            <div>
                                <div class="weui-cells__title">备注：</div>
                                <asp:TextBox ID="tbxArticleContent" CssClass="weui-textarea" runat="server" Height="57px" TextMode="MultiLine"></asp:TextBox>
                            </div>
                        </div>
                    </div>

                    <div style="margin-top: 5px">
                        <asp:Button ID="btnPost" runat="server" CssClass="btn btn-success btn-block" Text="发送" OnClick="btnPost_Click" />
                        <label class="btn btn-success btn-block" id="__mt_labBack" runat="server" onclick="back(this)">
                            返回
                        </label>
                    </div>

                </div>
            </div>
        </div>
        <asp:HiddenField ID="hfdArticleType" Value="#tab1" runat="server" />
        <asp:HiddenField ID="hfdArticleImages" runat="server" />
        <asp:HiddenField ID="hfdVoiceID" runat="server" />
    </form>

</body>
</html>
