﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="UserReward.aspx.cs" Inherits="MTCUN.Personnel.UserReward"
    Title="奖罚管理-人事" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <div class=" kuai-show">
            <table id="FeeTable" cellspacing="0" class="table form">
                <thead>
                    <tr>
                        <th colspan="2">奖罚处理
                        </th>
                    </tr>
                </thead>
                <tr>
                    <td align="right" style="width: 124px">员工：
                    </td>
                    <td class="required">
                        <asp:ListBox ID="lbxUsers" runat="server" SelectionMode="Multiple" DataTextField="TrueName"
                            DataValueField="UserID" Height="163px" Width="158px"></asp:ListBox>
                    </td>
                </tr>
                <tr>
                    <td align="right" style="width: 124px; height: 11px">类型：
                    </td>
                    <td style="height: 11px" class="required">
                        <asp:DropDownList ID="ddlReward" runat="server" DataTextField="RewardName" DataValueField="RewardID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td align="right" style="width: 124px; height: 11px">金额：
                    </td>
                    <td class="required">
                        <asp:TextBox ID="tbxPay" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td align="right" style="width: 124px; height: 11px">时间：
                    </td>
                    <td style="height: 11px" class="required">
                        <asp:TextBox ID="tbxDateAndTime" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td align="right" style="width: 124px; height: 11px">理由：
                    </td>
                    <td style="height: 11px">
                        <asp:TextBox ID="tbxRemark" runat="server" Width="489px"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td align="right" style="width: 124px; height: 11px"></td>
                    <td style="height: 11px">
                        <asp:Button ID="btnAdd" runat="server" CssClass="btn btn-default" Text="增加" OnClick="btnAdd_Click" />
                    </td>
                </tr>
            </table>

            <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" DataKeyNames="UserRewardID"
                CssClass="table" OnRowDeleting="GridView1_RowDeleting" Width="100%" OnRowCancelingEdit="GridView1_RowCancelingEdit"
                OnRowEditing="GridView1_RowEditing" OnRowDataBound="GridView1_RowDataBound" OnRowUpdating="GridView1_RowUpdating">
                <Columns>
                    <asp:BoundField DataField="UserRewardID" HeaderText="编号" InsertVisible="False"
                        ReadOnly="True" SortExpression="UserRewardID">
                        <ItemStyle HorizontalAlign="Left" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="员工" SortExpression="ToTrueName">
                        <ItemTemplate>
                            <asp:Label ID="labToTrueName" runat="server" Text='<%# Bind("ToTrueName") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList runat="server" ID="ddlUser"
                                DataTextField="TrueName" DataValueField="UserID">
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="类型" SortExpression="RewardID">
                        <ItemTemplate>
                            <asp:Label ID="labRewardName" runat="server" Text='<%# Bind("RewardName") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlReward" DataSource='<%# swq.Cache.GetReward() %>' runat="server"
                                SelectedValue='<%# Bind("RewardID") %>' DataTextField="RewardName" DataValueField="RewardID">
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="金额" SortExpression="Pay">
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxPay" runat="server" Text='<%# Bind("Pay","{0:f2}") %>' Width="50px"></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labPay" runat="server" Text='<%# Bind("Pay","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="时间" SortExpression="DateAndTime">
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField SortExpression="Remark" HeaderText="理由">
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxRemark" runat="server" Text='<%# Bind("Remark") %>' Width="150px"></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="录入员" ShowHeader="False">
                        <ItemTemplate>
                            <asp:Label ID="labTrueName" runat="server" Text='<%# Bind("TrueName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <div class="lab_button_sub">
                                <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                            </div>
                            <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除" ShowHeader="False">
                        <ItemTemplate>
                            <asp:LinkButton ID="LinkButton2" runat="server" CssClass="btn btn-default" CausesValidation="False" CommandName="Delete"
                                Text="删除" OnClientClick="<%# Rs.Messages.确定删除 %>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
    </form>
</body>
</html>
