﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="AddStudent.aspx.cs" Inherits="MTCUN.Register.AddStudent" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc1" %>
<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>快捷报班、续费-客服</title>
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <!--#include file="../include/modal.htm"-->

    <script type="text/javascript">
        jQuery(document).ready(function ($) {
            if (simple == 1) {
                $('#select').hide();
                $('#info').hide();
            }
        });
    </script>
    <form id="Form1" runat="server">
        <div id="__mt_SelectedPage" style="display: none"></div>
        <div style="margin: 10px">
            <div id="select" style="margin-top: 50px">
                <div style="display: none">
                    校区：
                        <asp:DropDownList ID="ddlSchool" runat="server" AutoPostBack="True"
                            DataTextField="SchoolName" DataValueField="SchoolID">
                        </asp:DropDownList>
                </div>

                <ul class="mt-listitems">
                    <li class="mt-row">请刷卡：<asp:TextBox ID="tbxStudentID" runat="server" CssClass="form-control"></asp:TextBox>
                    </li>
                    <li>
                        <asp:Button ID="btnSearch" CssClass="btn btn-default" runat="server" OnClick="btnSearch_Click" Text="查找学员" />
                    </li>
                    <li>
                        <input type="button" value="新增学员" class="btn btn-default" data-url="../register/poststudent.aspx?box=true" data-action="pz" onclick="openweb(this)" /><!--//带PZ标识,表示页面可以拍照.//-->
                    </li>
                </ul>
                <br />

                <div class="alert alert-info">
                    （可输入ID卡号、学号、姓名、姓名简码、手机号、身份证号查询）<br />

                    <asp:Label ID="labMsg" runat="server" ForeColor="Red"></asp:Label>
                </div>
                <br />

                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title">学员信息
                        </h3>
                    </div>
                    <div class="panel-body">

                        <div class="kuai" style="margin-top: 0px; text-align: center">
                            <asp:Label ID="labStudentName" runat="server"></asp:Label>
                        </div>

                        <div style="overflow-y: scroll; overflow-x: auto; min-width: 800px; height: auto; border: 0px solid #cccccc; background-color: white">
                            <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False"
                                DataKeyNames="StudentID" Width="100%">
                                <Columns>
                                    <asp:TemplateField HeaderText="学号" ItemStyle-Width="120">
                                        <ItemTemplate>
                                            <%#Eval("StudentID")%>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="姓名">
                                        <ItemTemplate>
                                            <%#Eval("StudentName")%>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="手机">
                                        <ItemTemplate>
                                            <%# PrivacyTelNumber(Eval("MobileTel"), 3)%>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="所属校区">
                                        <ItemTemplate>
                                            <%# Eval("SchoolName")%>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="选择学员">
                                        <ItemTemplate>
                                            <asp:HyperLink ID="select" CssClass="btn btn-default" NavigateUrl='<%# string.Format("?StudentID={0}&ClassID={1}&&selects={2}&simple={3}&GetUrl={4}",Eval("StudentID"),Request.QueryString["classid"],Request.QueryString["selects"],Request.QueryString["simple"],Request.QueryString["LessonTimeID"],Server.UrlEncode(Request.QueryString["geturl"])) %>' runat="server">选择</asp:HyperLink>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                            </asp:GridView>
                        </div>
                    </div>
                </div>
                <br />
            </div>

            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">已报班级
                    </h3>
                </div>
                <div class="panel-body">
                    <div style="overflow-y: scroll; overflow-x: auto; min-width: 800px; max-height: 150px; border: 0px solid #cccccc; background-color: white">
                        <asp:GridView ID="gdvStuClass" runat="server" AutoGenerateColumns="False"
                            DataKeyNames="StuClassID" Width="100%">
                            <SelectedRowStyle CssClass="selected" />
                            <Columns>
                                <asp:TemplateField HeaderText="选班号">
                                    <ItemTemplate>
                                        <%#Eval("StuClassID")%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="学员">
                                    <ItemTemplate>
                                        <%#Eval("StudentName")%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="班级名称">
                                    <ItemTemplate>
                                        <asp:HyperLink ID="hlkClassShow" runat="server" Text='<%#Eval("ClassName")%>' NavigateUrl='<%# string.Format("../Class/{3}.aspx?module={0}&ClassID={1}&GetURL={2}",(int)ModuleType,Eval("ClassID"),swq.Web.PathAndQuery(),(int)ModuleType == 1 ? "ClassControlPanel" : "Class") %>' />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="上课地点">
                                    <ItemTemplate>
                                        <%#Eval("SchoolName")%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="状态">
                                    <ItemTemplate>
                                        <%#Rs.Items.GetScState(Eval("ScStateID"))%>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="课时进度">
                                    <ItemTemplate>
                                        <uc1:Progress ID="Progress1" runat="server" QType='<%#(QType)Eval("QType") %>' MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>' StartDate='<%#Eval("DateAndTime") %>' ExpiryDate='<%#Eval("ExpiryDate") %>'
                                            progresswidth="65%" />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="浏览">
                                    <ItemTemplate>
                                        <asp:HyperLink ID="hlkShow" CssClass="btn btn-default" runat="server" Text="浏览" NavigateUrl='<%# string.Format("StuClassShow.aspx?module={0}&StuClassID={1}&GetURL={2}",(int)ModuleType, Eval("StuClassID"),swq.Web.PathAndQuery()) %>' />
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="续费">
                                    <ItemTemplate>
                                        <asp:HyperLink ID="hlkConn" CssClass="btn btn-default" runat="server" Text="续费" NavigateUrl='<%# string.Format("StuControlPanel.aspx?module={0}&PageIndex=2&action=add&StuClassID={1}&StudentID={2}&ClassID={3}&GetURL={4}", (int)ModuleType, Eval("StuClassID"),Eval("StudentID"),Eval("ClassID"),swq.Web.PathAndQuery()) %>' />
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </asp:GridView>
                    </div>
                </div>
            </div>

            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">新加班级
                    </h3>
                </div>
                <div class="panel-body">
                    <asp:Repeater ID="repBlock" runat="server" OnItemDataBound="repBlock_ItemDataBound">
                        <ItemTemplate>
                            <div class="kuai" style="position: relative; margin: 6px">
                                <div id="divDel" runat="server" style="position: absolute; border: 1px solid #c0c0c0; width: 25px; height: 25px; top: 2px; right: 2px; line-height: 25px; vertical-align: middle; text-align: center; font-size: larger; background-color: cornsilk; cursor: pointer">×</div>
                                <div class="auto_length_title" style="font-weight: bold; font-size: 14px">
                                    <span class="glyphicon glyphicon-home text-success"></span>
                                    <%#Eval("ClassName") %>
                                </div>

                                <table class=" table_simple" cellspacing="0" cellpadding="2" border="0">
                                    <tr>
                                        <td style="width: 80px">班号：</td>
                                        <td style="width: auto"><%#Eval("ClassID") %></td>
                                    </tr>
                                    <tr>
                                        <td style="width: auto">开课日期：</td>
                                        <td style="width: auto"><%#Eval("StartDate","{0:d}") %>-<%#Eval("EndDate","{0:d}") %></td>
                                    </tr>
                                    <tr>
                                        <td>老师：</td>
                                        <td><%#Eval("TeacherName") %></td>
                                    </tr>
                                    <tr>
                                        <td>上课规律：</td>
                                        <td><%#Eval("TimeRule") %></td>
                                    </tr>
                                    <tr>
                                        <td>上课进度：</td>
                                        <td>
                                            <uc1:Progress ID="Progress3" runat="server" MaxNum='<%#Eval("Lessons") %>' MinNum='<%#Eval("CourseProgress") %>'
                                                progresswidth="50px" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>剩余名额：</td>
                                        <td style="color: red; font-weight: bold"><%#(int)Eval("PlanCount") - ((int) Eval("StuCount") + (int)Eval("ProspectStuCount")) %></td>
                                    </tr>
                                    <tr>
                                        <td>所属课程：</td>
                                        <td><%#Eval("CourseName") %></td>
                                    </tr>
                                    <tr>
                                        <td>课程单位：</td>
                                        <td><%#Eval("UnitName") %></td>
                                    </tr>
                                    <tr>
                                        <td>上课校区：</td>
                                        <td><%#Eval("SchoolName") %></td>
                                    </tr>
                                </table>
                            </div>
                        </ItemTemplate>
                    </asp:Repeater>
                    <div class="btn btn-warning" data-url="../register/TimeConflict.aspx" data-action="ct" onclick="openweb(this)" runat="server" id="ct">
                        检测上课冲突
                    </div>
                </div>
            </div>

            <div style="margin: 5px">
                <asp:Button ID="btnAddClass" CssClass="btn btn-success" runat="server" Text="继续增加班级" OnClick="btnAddClass_Click" />
                <asp:Button ID="btnPost" CssClass="btn btn-success" runat="server" OnClick="btnPost_Click" Text="支付" />
            </div>
        </div>

        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、【选择学员】、【选择班级】进入【消费单】处理界面：这一步需要确认一下购买的数量金额。<br />
            2、如果是按时间收费，系统自动根据参数进行估算一个到期时间，如有不准需要进入选班信息进行修改。
        </div>

    </form>
</body>
</html>
