﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="GoPayment.aspx.cs" Inherits="MTCUN.Register.GoPayment"
    Title="账户管理-客服" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/ReportServer.ascx" TagName="ReportServer" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function StudentBox() {
            window.showModelessDialog('../Tools/StudentBox.aspx', window, 'dialogWidth=750px;dialogHeight=500px');
        }
    </script>
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <uc1:ReportServer ID="ReportServer1" runat="server" />

        <div runat="server" id="divSellInfo" visible="false" class="alert alert-warning mt-warning">
            <table>
                <tr>
                    <th>订单提示
                    </th>
                </tr>
                <tr>
                    <td>
                        <asp:Label ID="labStudentID" runat="server"></asp:Label>
                        <asp:Label ID="labStudentName" runat="server"></asp:Label>
                        单号：<asp:Label ID="labBillID" runat="server"></asp:Label>
                        应付金额：<asp:Label ID="labPayables" runat="server"></asp:Label>
                        实付金额：<asp:Label ID="labPayed" runat="server"></asp:Label>
                        &nbsp;<asp:Label ID="labArrears" runat="server"></asp:Label>
                        &nbsp;钱包余额：<asp:Label ID="labAvailable" runat="server" ForeColor="Red"></asp:Label>
                    </td>
                </tr>
            </table>
        </div>

        <div class="kuai-show">

            <table class="table">
                <thead>
                    <tr>
                        <th colspan="3">&nbsp; 增加收费记录
                        </th>
                    </tr>
                </thead>
                <tr>
                    <td>收款方式：
                    </td>
                    <td class="required">
                        <asp:DropDownList ID="ddlPayMethod" CssClass="mt-dropdownlist" DataTextField="PayMethodName" DataValueField="PayMethodID" runat="server">
                        </asp:DropDownList>
                    </td>
                    <td rowspan="4" style="width: 350px">&nbsp;</td>
                </tr>
                <tr>
                    <td>金额：
                    </td>
                    <td class="required">
                        <asp:TextBox ID="tbxPayMoney" runat="server" Width="100px"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>日期：
                    </td>
                    <td class="required">
                        <asp:TextBox ID="tbxDateAndTime" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>备注：
                    </td>
                    <td>
                        <asp:TextBox ID="tbxRemark" runat="server" Width="409px"></asp:TextBox>
                    </td>
                </tr>
                <tr runat="server" id="trCredit" visible="false">
                    <td>借款到期：
                    </td>
                    <td colspan="2" class="required">
                        <asp:TextBox ID="tbxCreditExpiration" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>交费点：
                    </td>
                    <td colspan="2" class="required">
                        <asp:DropDownList ID="ddlPostSchool" runat="server" CssClass="mt-dropdownlist" DataTextField="SchoolName" DataValueField="SchoolID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>收费文员：
                    </td>
                    <td colspan="2" class="required">
                        <asp:DropDownList ID="ddlUser" CssClass="mt-dropdownlist" runat="server" DataTextField="TrueName" DataValueField="UserID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>短信通知：
                    </td>
                    <td colspan="2">
                        <asp:CheckBox ID="cbxSMS" runat="server" Checked="True" />
                    </td>
                </tr>
                <tr>
                    <td>&nbsp;
                    </td>
                    <td colspan="2">
                        <asp:Button ID="btnPost" CssClass="btn btn-default" runat="server" Text="确定" OnClick="btnPost_Click" />
                    </td>
                </tr>
            </table>
        </div>
        <div class="kuai-list">
            <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="table table-hover"
                OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowDeleting="GridView1_RowDeleting"
                OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" DataKeyNames="PaymentID"
                OnRowDataBound="GridView1_RowDataBound" OnRowCommand="GridView1_RowCommand">
                <Columns>
                    <asp:BoundField DataField="PaymentID" HeaderText="编号" ReadOnly="true" />
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <asp:Label ID="labPaymentType" runat="server" Text='<%#Eval("PaymentTypeName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="金额">
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxPayMoney" runat="server" Width="80px" Text='<%# Bind("PayMoney") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labPayMoney" runat="server" Text='<%# Bind("PayMoney", "{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="支付方式">
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlPayMethod" runat="server" DataTextField="PayMethodName" DataValueField="PayMethodID">
                            </asp:DropDownList>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labPayMethod" runat="server" Text='<%# Bind("PayMethodName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="日期">
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxDateAndTime" runat="server" Width="140px" Text='<%# Bind("DateAndTime") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="备注">
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="办理点">
                        <ItemTemplate>
                            <asp:Label ID="labPostSchoolName" runat="server" Text='<%# Bind("PostSchoolName") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlPostSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="收费文员">
                        <ItemTemplate>
                            <asp:Label ID="labTrueName" runat="server" Text='<%# Bind("TrueName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="打印">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkPrint" CssClass="glyphicon glyphicon-print btn btn-default" runat="server" NavigateUrl='<%#string.Format("javascript:Print({0});void(0);",Eval("PaymentID")) %>'>
                                <span class="badge"><%#Eval("PrintCount") %></span></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnEdit" CssClass="btn btn-default" runat="server" Text="编辑" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:LinkButton ID="lbnUpdate" CssClass="btn btn-default" runat="server" Text="更新" CommandName="Update"></asp:LinkButton>
                            <asp:LinkButton ID="lbnCancel" CssClass="btn btn-default" runat="server" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" CssClass="btn btn-default" runat="server" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>

        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>

        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            <span style="color: Red">1、收款方式选择【钱包扣款】，表示从钱包里扣款，类型为业务扣费。</span><br />
            2、退费、扣除借款请使用负数。<br />
            3、如果您发现充值信息无法编辑或删除，请到财务模块：学员控制面板-账户信息-编辑或删除，因为交费信息的管理工作由财务负责。<br />
            4、微信扫码支付：输入支付金额，点击“生成支付二维码”跳转到二维码界面，让学员登录微信扫一扫后完成支付，支付成功时页面自动返回本页面。<br />
        </div>
    </form>
</body>
</html>
