﻿<%@ Page Language="c#" CodeBehind="PostStuClass.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Register.PostStuClass"
    Title="选班办理-客服" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc1" %>
<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<%@ Register Src="../UserCol/Ann.ascx" TagName="Ann" TagPrefix="uc2" %>
<%@ Register Src="../UserCol/QuantifiedCol.ascx" TagName="QuantifiedCol" TagPrefix="uc3" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />

</head>
<body>
<!--#include file="../include/modal.htm"-->
    
    <form id="Form1" method="post" runat="server">
        <div class="kuai-show">
            <uc2:Ann ID="Ann1" runat="server" />
            <table class="table">
                <thead>
                    <tr>
                        <th colspan="3">学员选班表
                        </th>
                    </tr>
                </thead>
                <tr>
                    <td style="width: 10%">上课校区：
                    </td>
                    <td style="width: 40%" class="required">
                        <asp:DropDownList ID="ddlSchool" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlSchool_SelectedIndexChanged"
                            DataTextField="SchoolName" DataValueField="SchoolID">
                        </asp:DropDownList>
                    </td>
                    <td align="center" rowspan="9" valign="top" style="vertical-align: top  !important; width:350px;" runat="server" id="tdRow">
                        <asp:FormView ID="fvClass" runat="server" Width="100%">
                            <ItemTemplate>
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h3 class="panel-title">班级信息</h3>
                                    </div>
                                    <div class="panel-body">
                                        <table class="table">
                                            <tr>
                                                <td>班级名称：
                                                </td>
                                                <td>
                                                    <%#Eval("ClassName")%>
                                        (<%#Eval("ClassID")%>)
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>开课时间：
                                                </td>
                                                <td>
                                                    <%#Eval("StartDate", "{0:d}") + " -- " + Eval("EndDate", "{0:d}")%>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>上课规律：
                                                </td>
                                                <td>
                                                    <%#Eval("TimeRule")%>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>主讲老师：
                                                </td>
                                                <td>
                                                    <%#Eval("TeacherName")%>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>教室：
                                                </td>
                                                <td>
                                                    <%#Eval("ClassroomName")%>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>招生比例：
                                                </td>
                                                <td>
                                                    <uc1:Progress ID="Progress1" runat="server" Text="人" MaxNum='<%#Eval("PlanCount") %>'
                                                        MinNum='<%#Eval("StuCount") %>' Width="60px" />
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>课时进度：
                                                </td>
                                                <td>
                                                    <uc1:Progress ID="Progress2" runat="server" Text="课时" MaxNum='<%#Eval("Lessons") %>'
                                                        MinNum='<%#Eval("CourseProgress") %>' Width="60px" />
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </ItemTemplate>
                        </asp:FormView>
                    </td>
                </tr>

                <tr>
                    <td>班级选择：
                    </td>
                    <td>
                        <div class="striking_head">
                            <table style="border-collapse: separate; border-spacing: 0px">
                                <tr>
                                    <td>
                                        <div class="input-group" style="width: 120px; border-spacing: 0px; margin-bottom:4px">
                                            <span class="input-group-addon">状态：</span>
                                            <span class="input-group-addon">
                                                <asp:RadioButtonList ID="rblDateFilter" runat="server" AutoPostBack="True" RepeatDirection="Horizontal"
                                                    OnSelectedIndexChanged="rblDateFilter_SelectedIndexChanged">
                                                    <asp:ListItem Value="1" Text="未开课"></asp:ListItem>
                                                    <asp:ListItem Value="2" Text="开课中"></asp:ListItem>
                                                    <asp:ListItem Value="3" Text="已结束"></asp:ListItem>
                                                </asp:RadioButtonList>
                                            </span>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="input-group" style="border-spacing: 0px">
                                            <span class="input-group-addon">讲师：</span>
                                            <asp:DropDownList ID="ddlTeacher" runat="server" DataTextField="TrueName" DataValueField="UserID"
                                                OnSelectedIndexChanged="ddlTeacher_SelectedIndexChanged" AutoPostBack="True">
                                            </asp:DropDownList>
                                            <span class="input-group-addon"></span>
                                            <uc1:SimpleCode ID="SimpleCode1" runat="server" UsersControlID="ddlTeacher" />
                                        </div>
                                    </td>
                                    <td><span class="btn btn-warning" data-action="tc" runat="server" id="tc" onclick="openweb(this)">检测排课冲突
                                    </span></td>
                                </tr>
                            </table>
                        </div>
                        <div class="striking_content">
                            <div class="input-group" style="border-spacing: 0px">
                                <span class="input-group-addon">班号：</span>
                                <asp:DropDownList ID="ddlClass" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlClass_SelectedIndexChanged">
                                </asp:DropDownList>
                            </div>

                        </div>
                    </td>
                </tr>
                <tr>
                    <td>计量方式：
                    </td>
                    <td>
                        <div style="background-color: #ffffff; border: 1px solid #ECEB7F; border-radius: 5px; width: auto; padding: 4px; background-color: #FEFDC1">

                            <div id="setContent" style="float: left;">
                                <uc3:QuantifiedCol ID="QuantifiedCol1" runat="server" />
                            </div>
                            <div style="clear: both; height: 0px; font-size: 0px">
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>状态：
                    </td>
                    <td class="required">
                        <asp:DropDownList ID="ddlScState" CssClass="mt-dropdownlist" runat="server" Enabled="False">
                            <asp:ListItem Value="1" Text="正常"></asp:ListItem>
                            <asp:ListItem Value="3" Text="转班"></asp:ListItem>
                            <asp:ListItem Value="4" Text="休学"></asp:ListItem>
                            <asp:ListItem Value="5" Text="退学"></asp:ListItem>
                            <asp:ListItem Value="6" Text="弃学"></asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>选班日期：
                    </td>
                    <td class="required">
                        <asp:TextBox ID="tbxDateAndTime" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>原班：</td>
                    <td align="left" valign="top" class="required">
                        <asp:DropDownList ID="ddlSourceClass" CssClass="mt-dropdownlist" runat="server" DataTextField="ClassName" DataValueField="ClassID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>类型：
                    </td>
                    <td align="left" valign="top" class="required">
                        <asp:DropDownList ID="ddlContinueReg" CssClass="mt-dropdownlist" runat="server">
                            <asp:ListItem Value="0">试听</asp:ListItem>
                            <asp:ListItem Value="1" Selected="True">新增</asp:ListItem>
                            <asp:ListItem Value="2">续报</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>备注：
                    </td>
                    <td align="left" rowspan="1" valign="top">
                        <asp:TextBox ID="tbxRemark" runat="server" Width="70%" TextMode="MultiLine" Height="51px"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>报名点：
                    </td>
                    <td colspan="2" class="required">
                        <asp:DropDownList ID="ddlPostSchool" CssClass="mt-dropdownlist" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>录入员：
                    </td>
                    <td colspan="2" class="required">
                        <asp:DropDownList ID="ddlUser" CssClass="mt-dropdownlist" runat="server" DataTextField="TrueName" DataValueField="UserID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>短信通知：
                    </td>
                    <td colspan="2">
                        <asp:CheckBox ID="cbxSMS" runat="server" Checked="True" />
                    </td>
                </tr>
                <tr>
                    <td></td>
                    <td colspan="2">
                        <asp:Button ID="btnSave" CssClass=" btn btn-default" runat="server" Text="保存" OnClick="btnSave_Click"></asp:Button>
                        <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                            返回
                        </label>
                    </td>
                </tr>
            </table>
        </div>
    </form>
        <div class="alert alert-info mt-remark">
        <b>注意事项：</b><br />
        1、计量方式：是指量化学员上课资源的方式，分为按课时数量量化与按到期时间量化。<br />
        2、当课程单位为课时，系统强制按课时进行量化，当课程单位为学期时，系统同时提供两种方式供选择，但如果学期后面存在二级单位，如：天，周，月，季，年时，系统强制按到期时间进行量化。<br />
        3、当勾选“同步班级总课时”，课时数量会自动与班级总课时同步，只有报整班课时的学员才可以选择此项，慎用。<br />
        4、当勾选“同步班级结束日期”，学员到期时间会自动与班级结束日期同步，只有上课结束日期与班级结束日期相同的学员才可以选择此项，慎用。
    </div>
</body>
</html>
