﻿<%@ Page Language="c#" CodeBehind="StuBill.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Register.StuBill"
    Title="学员消费单-客服" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/ReportServer.ascx" TagName="ReportServer" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script src="../Jscript/CreateSubMenu.js" type="text/javascript"></script>
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="Form1" runat="server">
        <div class="kuai-list">
            <div class="control_bg" id="divAddBill" runat="server">
                <input id="btnAdd" causesvalidation="false" class="btn btn-success" type="button" onclick="<%="__mt_location('PostSellBill.aspx?StudentID="+Request.QueryString["StudentID"] +"')"%>"
                    value="增加消费单" />
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="BillID" OnRowEditing="GridView1_RowEditing" OnRowDeleting="GridView1_RowDeleting"
                OnRowDataBound="GridView1_RowDataBound" OnSelectedIndexChanging="GridView1_SelectedIndexChanging"
                OnRowCommand="GridView1_RowCommand">
                <SelectedRowStyle CssClass="selected" />
                <Columns>
                    <asp:TemplateField InsertVisible="False" HeaderText="基本信息" SortExpression="BillID">
                        <ItemTemplate>
                            <asp:ImageButton ID="ibnSelect" CommandName="Select" ImageUrl='<%# accTheme("node_close.gif") %>'
                                runat="server" />
                            <asp:LinkButton ID="lbnSelect" runat="server" Text='<%# Eval("BillID") %>' CommandName="Select" />
                            <asp:Label ID="labBillTypeID" runat="server" CssClass='<%#(int)Eval("BillTypeID") == 1 ? "label label-success" : "label label-warning"%>' Text='<%#(int)Eval("BillTypeID") == 1 ? "购买" : "退货"%>'></asp:Label>
                            <br />
                            日期：<asp:Label ID="labDateAndTime" runat="server" Text='<%#Eval("DateAndTime")%>'></asp:Label>

                            <br />
                            应交：<asp:Label ID="labPayables" runat="server" Text='<%# Eval("Pay","{0:c2}") %>'></asp:Label>
                            优惠：<asp:Label ID="labDiscount" runat="server" Text='<%# Eval("Discount","{0:c2}") %>'></asp:Label>
                            实收：  
                            <asp:Label ID="labPayed" runat="server" Text='<%# Eval("Payed","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="">
                        <ItemTemplate>
                            办理点：<asp:Label ID="labPostSchoolName" runat="server" Text='<%#Eval("PostSchoolName")%>'></asp:Label>
                            <br />
                            经办人：<%#Eval("TrueName")%>
                            <br />
                            备注：<asp:Literal runat="server" ID="litRemark" Text='<%# Eval("Remark") %>' Mode="Encode"></asp:Literal>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="欠费">
                        <ItemTemplate>
                            <asp:Label ID="labArrearage" runat="server" Text='<%#  Eval("Arrearage","{0:c2}") %>' ForeColor='<%# (decimal)Eval("Arrearage") > 0 ? System.Drawing.Color.Red : System.Drawing.Color.Empty %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="支付状态">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkCode" CssClass="btn btn-default" runat="server">
                                支付记录
                                    <span class="badge"><%#Eval("PayCount") %></span>
                            </asp:HyperLink>
                            <asp:HyperLink ID="hlkState" runat="server" Height="20px"></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="打印">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkPrint" CssClass="glyphicon glyphicon-print btn btn-default" runat="server" NavigateUrl='<%#string.Format("javascript:Print({0});void(0);",Eval("BillID")) %>'>
                                    <span class="badge"><%#Eval("PrintCount") %></span>
                            </asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkEdit" runat="server" CssClass="btn btn-default" Text="编辑" NavigateUrl='<%# string.Format("{4}.aspx?StudentID={0}&BillID={1}&module={2}&GetUrl={3}",Eval("StudentID"),Eval("BillID"), (int)ModuleType,swq.Web.PathAndQuery(),(int)Eval("BillTypeID") == 1 ? "PostSellBill" : "PostOutBill") %>' />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" CssClass="btn btn-default" runat="server" Text="删除" CommandArgument='<%#Eval("UserID")%>'
                                CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </div>

        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>

        <div id="divItems" style="visibility: hidden; display:none">
            <div style="display: inline-block" id="sub">
                <div class="triangle-up"></div>
                <div class=" details">
                    <asp:GridView ID="gvItems" runat="server" CssClass="table table-hover" AutoGenerateColumns="false">
                        <Columns>
                            <asp:BoundField DataField="ProductID" HeaderText="编号" ReadOnly="True" />
                            <asp:TemplateField HeaderText="项目">
                                <ItemTemplate>
                                    <%# Eval("ProductName") %><%#swq.Tools.AddBrackets(Eval("PackageName")) %>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="单价">
                                <ItemTemplate>
                                    <asp:Label ID="labUnitPrice" runat="server" Text='<%# Bind("UnitPrice","{0:c2}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="数量">
                                <ItemTemplate>
                                    <asp:Label ID="labAmount" runat="server" Text='<%# Bind("Amount","{0:0.##}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="单位">
                                <ItemTemplate>
                                    <asp:Label ID="labUnitName" runat="server" Text='<%# Eval("UnitName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="优惠">
                                <ItemTemplate>
                                    <asp:Label ID="labDiscount" runat="server" Text='<%# Eval("Discount","{0:c2}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="合计">
                                <ItemTemplate>
                                    <asp:Label ID="labTotalPrice" runat="server" Text='<%# Bind("TotalPrice","{0:c2}") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="班级/仓库">
                                <ItemTemplate>
                                    <asp:Label ID="labServiceName" runat="server" Text='<%# Bind("ServiceName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                </div>
            </div>
        </div>
        <uc1:ReportServer ID="ReportServer1" runat="server" />

        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、如果您发现消费单无法编辑或删除，请到财务模块：学员控制面板-消费单-编辑或删除，因为消费信息的管理工作由财务负责。<br />
        </div>
    </form>
</body>
</html>
