﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="StuPayment.aspx.cs" Inherits="MTCUN.Register.StuPayment"
    Title="钱包管理-客服" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/ReportServer.ascx" TagName="ReportServer" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript">
        function StudentBox() {
            window.showModelessDialog('../Tools/StudentBox.aspx', window, 'dialogWidth=750px;dialogHeight=500px');
        }
    </script>
</head>
<body>
    <!--#include file="../include/modal.htm"-->

    <form id="form1" runat="server">
        <uc1:ReportServer ID="ReportServer1" runat="server" />
        <div class="kuai-show  form">
            <div class=" striking" runat="server" id="divSellInfo" visible="false">
                <b>订单提示：</b>需<span runat="server" id="spanMissing" visible="false">充值 ：<asp:Label
                    ID="labMissing" runat="server" ForeColor="Red"></asp:Label>
                    元</span>
            </div>
            <div class="divpanel">
                <table class="table mt-form">
                    <thead>
                        <tr>
                            <th colspan="3">学员账户管理
                            </th>
                        </tr>
                    </thead>
                    <tr>
                        <td>学号：
                        </td>
                        <td>
                            <asp:Label ID="labStudentID" runat="server"></asp:Label>
                        </td>
                        <td rowspan="8" style="width: 450px">
                            <asp:FormView ID="fvStudent" runat="server" Width="100%">
                                <ItemTemplate>
                                    <div class="panel panel-default">
                                        <div class="panel-heading">
                                            <h3 class="panel-title">账户信息</h3>
                                        </div>
                                        <div class="panel-body">
                                            <table class="table">
                                                <tr>
                                                    <td style="width: 30%">学号：
                                                    </td>
                                                    <td>
                                                        <%#Eval("StudentID")%>
                                                    </td>
                                                    <td rowspan="2"></td>
                                                </tr>
                                                <tr>
                                                    <td>姓名：
                                                    </td>
                                                    <td>
                                                        <%#Eval("StudentName")%>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>可用余额：
                                                    </td>
                                                    <td colspan="2">
                                                        <span style="color: Red">
                                                            <%=swq.CurrentCurrencySymbol %><%#Eval("AvailableMoney", "{0:0.00##}")%></span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>消费总额：
                                                    </td>
                                                    <td colspan="2">
                                                        <%#Eval("ConsumedMoney","{0:c2}")%>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>赠送金额：
                                                    </td>
                                                    <td colspan="2">
                                                        <%=swq.CurrentCurrencySymbol %><%#Eval("GiveMoney", "{0:0.00##}")%>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>借款金额：
                                                    </td>
                                                    <td colspan="2">
                                                        <%#Eval("CreditMoney", "{0:c2}")%>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>积分：
                                                    </td>
                                                    <td colspan="2">
                                                        <%#Eval("Points")%>分
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </ItemTemplate>
                            </asp:FormView>
                        </td>
                    </tr>
                    <tr>
                        <td>姓名：
                        </td>
                        <td>
                            <asp:Label ID="labStudentName" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td>交费类型：
                        </td>
                        <td class="required">
                            <asp:DropDownList ID="ddlPaymentType" CssClass="mt-dropdownlist" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlPaymentType_SelectedIndexChanged">
                                <asp:ListItem Value="1">交费</asp:ListItem>
                                <asp:ListItem Value="2">退费</asp:ListItem>
                                <asp:ListItem Value="3">借款</asp:ListItem>
                                <asp:ListItem Value="4">扣除借款</asp:ListItem>
                                <asp:ListItem Value="7">赠送</asp:ListItem>
                                <asp:ListItem Value="8">扣除赠送</asp:ListItem>
<%--                                <asp:ListItem Value="11">增加余额</asp:ListItem>--%>
                                <asp:ListItem Value="12">扣除余额</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td>支付方式：
                        </td>
                        <td class="required">
                            <asp:DropDownList ID="ddlPayMethod" CssClass="mt-dropdownlist" DataTextField="PayMethodName" DataValueField="PayMethodID" runat="server">
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td>金额：
                        </td>
                        <td class="required">
                            <asp:TextBox ID="tbxPayMoney" runat="server" Width="100px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td>日期：
                        </td>
                        <td class="required">
                            <asp:TextBox ID="tbxDateAndTime" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td>备注：
                        </td>
                        <td>
                            <asp:TextBox ID="tbxRemark" runat="server" Width="209px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr runat="server" id="trCredit" visible="false">
                        <td>借款到期：
                        </td>
                        <td class="required">
                            <asp:TextBox ID="tbxCreditExpiration" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td>交费点：
                        </td>
                        <td class="required">
                            <asp:DropDownList ID="ddlPostSchool" CssClass="mt-dropdownlist" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td>收费文员：
                        </td>
                        <td colspan="2" class="required">
                            <asp:DropDownList ID="ddlUser" CssClass="mt-dropdownlist" runat="server" DataTextField="TrueName" DataValueField="UserID">
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr>
                        <td>短信通知：
                        </td>
                        <td colspan="2">
                            <asp:CheckBox ID="cbxSMS" runat="server" Checked="True" />
                        </td>
                    </tr>
                    <tr>
                        <td>&nbsp;
                        </td>
                        <td colspan="2">
                            <asp:Button ID="btnPost" runat="server" CssClass="btn btn-default" Text="确定" OnClick="btnPost_Click" />
                        </td>
                    </tr>
                </table>
            </div>
        </div>

        <div class="kuai-list">
            <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" CssClass="table table-hover"
                OnRowCancelingEdit="GridView1_RowCancelingEdit" OnRowDeleting="GridView1_RowDeleting"
                OnRowEditing="GridView1_RowEditing" OnRowUpdating="GridView1_RowUpdating" DataKeyNames="PaymentID"
                OnRowDataBound="GridView1_RowDataBound" OnRowCommand="GridView1_RowCommand">
                <Columns>
                    <asp:BoundField DataField="PaymentID" HeaderText="编号" ReadOnly="true" />
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <%#ShowPaymentType(Eval("BillID"), Eval("RelaPaymentID"), Eval("LockState"),Eval("PaymentTypeID"),Eval("PayMethodID")) %>
                            <asp:Label ID="labPaymentType" runat="server" Text='<%#Eval("PaymentTypeName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="金额">
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxPayMoney" runat="server" Text='<%# Bind("PayMoney") %>' Width="80px"></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labPayMoney" runat="server" Text='<%# getMoney(Eval("PayMoney")) %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="支付方式">
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlPayMethod" runat="server" DataTextField="PayMethodName" DataValueField="PayMethodID">
                            </asp:DropDownList>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labPayMethod" runat="server" Text='<%# Bind("PayMethodName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="日期">
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labDateAndTime" runat="server" Text='<%# Bind("DateAndTime") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="备注">
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labRemark" runat="server" Text='<%# Bind("Remark") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="借款到期">
                        <EditItemTemplate>
                            <asp:TextBox ID="tbxCreditExpiration" runat="server" Text='<%# Bind("CreditExpiration") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="labCreditExpiration" runat="server" Text='<%# Bind("CreditExpiration") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="办理点">
                        <ItemTemplate>
                            <asp:Label ID="labPostSchoolName" runat="server" Text='<%# Bind("PostSchoolName") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="ddlPostSchool" runat="server" DataTextField="SchoolName" DataValueField="SchoolID">
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="收费文员">
                        <ItemTemplate>
                            <asp:Label ID="labTrueName" runat="server" Text='<%# Bind("TrueName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="打印">
                        <ItemTemplate>
                            <asp:HyperLink ID="hlkPrint" runat="server" CssClass="glyphicon glyphicon-print btn btn-default" NavigateUrl='<%#string.Format("javascript:Print({0});void(0);",Eval("PaymentID")) %>'>
                                <span class="badge"><%#Eval("PrintCount") %></span></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnEdit" runat="server" CssClass="btn btn-default" Text="编辑" CommandName="Edit"></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:LinkButton ID="lbnUpdate" runat="server" CssClass="btn btn-default" Text="更新" CommandName="Update"></asp:LinkButton>
                            <asp:LinkButton ID="lbnCancel" runat="server" CssClass="btn btn-default" Text="取消" CommandName="Cancel"></asp:LinkButton>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>


            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>

        </div>
        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>
        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、退费、扣除借款请使用负数。<br />
            2、如果您发现充值信息无法编辑或删除，请到财务模块：学员控制面板-账户信息-编辑或删除，因为交费信息的管理工作由财务负责。<br />
            3、微信扫码支付：输入支付金额，点击“生成支付二维码”跳转到二维码界面，让学员登录微信扫一扫后完成支付，支付成功时页面自动返回本页面。<br />
        </div>
    </form>
</body>
</html>
