﻿<%@ Page Language="c#" CodeBehind="StuProduct.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Register.StuProduct"
    Title="已购项目-客服" %>

<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="Form1" runat="server">
        <div class="kuai-list">

            <div class="control_bg">
                <asp:Button ID="btnBack" CssClass="btn btn-default" runat="server" Text="退货办理" OnClick="btnBack_Click" />
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="BillItemID" OnRowDataBound="GridView1_RowDataBound" OnRowEditing="GridView1_RowEditing"
                OnRowUpdating="GridView1_RowUpdating" OnRowCommand="GridView1_RowCommand" OnRowCancelingEdit="GridView1_RowCancelingEdit">
                <SelectedRowStyle CssClass="selected" />
                <Columns>
                    <asp:TemplateField HeaderText="项目">
                        <ItemTemplate>
                            <span style="font-size: 1.2em">
                                <input id="cbxProductID" value='<%# Eval("BillItemID") %>' runat="server" type="checkbox" />
                                <asp:Label ID="labProductName" runat="server" Text='<%# Bind("ProductName") %>'></asp:Label><%#swq.Tools.AddBrackets(Eval("PackageName")) %>
                            </span>
                            <br />
                            时间：<asp:Label ID="labDateAndTime" runat="server" Text='<%# Eval("DateAndTime") %>'></asp:Label>
                            <br />
                            单号：<asp:Label ID="labBillID" runat="server" Text='<%# Eval("BillID") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <input id="cbxProductID" value='<%# Eval("BillItemID") %>' runat="server" type="checkbox" />
                            <asp:Label ID="labProductName" runat="server" Text='<%# Bind("ProductName") %>'></asp:Label><%#swq.Tools.AddBrackets(Eval("PackageName")) %></span>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnEdit" CssClass="btn btn-default" runat="server" CommandName="edit" Text='<%# "(" + Rs.Items.GetStuClassType(Eval("ContinueReg")) + ")" %>'></asp:LinkButton>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <ul class="mt-listitems">
                                <li>
                                    <asp:DropDownList ID="ddlContinueReg" Width="60px" runat="server">
                                        <asp:ListItem Value="0">试听</asp:ListItem>
                                        <asp:ListItem Value="1" Selected="True">新增</asp:ListItem>
                                        <asp:ListItem Value="2">续报</asp:ListItem>
                                    </asp:DropDownList></li>
                                <li>
                                    <asp:LinkButton ID="lbnSave" CssClass="btn btn-default" runat="server" CommandName="update">保存</asp:LinkButton>
                                    <asp:LinkButton ID="lbnCancel" CssClass="btn btn-default" runat="server" Text="取消" CommandName="Cancel"></asp:LinkButton></li>
                            </ul>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="单价">
                        <ItemTemplate>
                            <asp:Label ID="labUnitPrice" runat="server" Text='<%# Eval("UnitPrice","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="数量">
                        <ItemTemplate>
                            <asp:Label ID="labAmount" runat="server" Text='<%# Eval("Amount","{0:0.##}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="单位">
                        <ItemTemplate>
                            <asp:Label ID="labUnitName" runat="server" Text='<%# Eval("UnitName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="优惠">
                        <ItemTemplate>
                            <asp:Label ID="labDiscount" runat="server" Text='<%# Eval("Discount","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="合计">
                        <ItemTemplate>
                            <asp:Label ID="labTotalPrice" runat="server" Text='<%# Bind("TotalPrice","{0:c2}") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="班级/仓库">
                        <ItemTemplate>
                            <asp:Label ID="labServiceName" runat="server" Text='<%# Bind("ServiceName") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" ID="hlkState" CssClass="btn btn-default"></asp:HyperLink>
                            <asp:LinkButton ID="lbnState" runat="server" CssClass="btn btn-warning" CommandName="ChangeState" CommandArgument='<%#Eval("BillItemID") %>'></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>


        </div>
        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>
    </form>
    <div class="alert alert-info mt-remark">
        <b>注意事项：</b><br />
        1、已经选班的课程就不能退货了，特别是已经上课的学员只能办理退学流程(位置：教务-学员管理-学员列表-此学员控制面板-选班信息-异动办理-退学)。<br />
    </div>
</body>
</html>
