﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TimeConflict.aspx.cs" Inherits="MTCUN.Register.TimeConflict" Title="排课冲突检测-客服" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <div class="kuai-list">
            <div id="yesc" runat="server" class="striking" style="color: red; text-align: center">冲突课次如下</div>
            <div id="noc" runat="server" class="kuai-show" style="height: 80px; text-align: center; vertical-align: middle; line-height: 80px">未发现任何冲突</div>
            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" DataKeyNames="LessonTimeID"
                AutoGenerateColumns="false" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
<label runat="server" class='<%# (int)Eval("LeStateID") == 0 ? "label label-default": "label label-success"%>' data-toggle="tooltip" title='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>'>课</label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="Subject" ReadOnly="True" HeaderText="课题" />
                    <asp:TemplateField HeaderText="上课日期">
                        <ItemTemplate>
                            <span runat="server" id="spanDate"><%#Eval("StartDate","{0:d}")%></span><span style="color: Red; font-size: 9px">[<%#((DateTime)Eval("StartDate")).DayOfWeek.ToString("d")%>]</span>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="上课时段">
                        <ItemTemplate>
                            <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),swq.Tools.EndDate(Eval("EndDate")))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="ClassroomName" ReadOnly="True" HeaderText="教室" />
                    <asp:BoundField DataField="TeacherName" ReadOnly="True" HeaderText="讲师" />
                    <asp:BoundField DataField="ClassID" ReadOnly="True" HeaderText="班号" />
                    <asp:BoundField DataField="ClassName" ReadOnly="True" HeaderText="班级名称" />
                    <asp:TemplateField HeaderText="上课类型">
                        <ItemTemplate>
                            <%# Rs.Items.GetLessonType(Eval("LessonType"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
    </form>
</body>
</html>
