﻿<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:MTString">

  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="TitlePrefix"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>

  <xsl:template match="/">

    <html>
      <head>
        <pagesetting>
          <landscape>true</landscape>
          <paperkind>Custom</paperkind>
          <paperwidth>10cm</paperwidth>
          <paperheight>21cm</paperheight>
          <pageleft>1cm</pageleft>
          <pageright>0.6cm</pageright>
          <pagetop>0.8cm</pagetop>
          <pagebottom>0.5cm</pagebottom>
          <fontname>宋体</fontname>
          <fontsize>8</fontsize>
          <doctype>1</doctype>
        </pagesetting>
      </head>
      <body>
        <div x="0cm" y="0">
          <span x="0" y="0.2cm"  style="text-align:center;font-size:22;font-family:黑体;" width="11cm" height="1.3cm">
            <xsl:value-of select="$TitlePrefix" />充值单</span>
          <span x="0" y="1.3cm" align="left" width="7.6cm" height="1.3cm">
            姓名：<xsl:value-of select="ds/Payment/StudentName" />$nbsp;学号：<xsl:value-of select="ds/Payment/StudentID" />
          </span>
          <span x="0" y="1.6cm" align="left" width="7.6cm" height="1.3cm">
            日期：<xsl:value-of select="String:FormatDate('{0:yyyy-MM-dd HH:mm:ss}',ds/Payment/DateAndTime)" />
          </span>
          <span x="0" y="2cm" align="left" width="7.6cm" height="1.3cm">
            编号：<xsl:value-of select="ds/Payment/PaymentID" />
          </span>
          <span x="0" y="2.4cm" align="left" width="7.6cm" height="1.3cm">
            类型：<xsl:value-of select="ds/Payment/PaymentTypeName" />
          </span>
          <span x="0" y="3.3cm" style="text-align:left;font-size:18" width="7.6cm" height="1.3cm">
            金额：<xsl:value-of select="String:FormatNumber('{0:c}',ds/Payment/PayMoney)" />
          </span>
          <span x="0" y="4.3cm" style="text-align:left;font-size:10" width="7.6cm" height="1.3cm">
            （大写）<xsl:value-of select="String:CHSMoney(ds/Payment/PayMoney)"/>
          </span>
          <span x="0" y="4.8cm" style="text-align:left;font-size:10" width="7.6cm" height="1.3cm">客户签字：______________________</span>
          <span x="0" y="5.3cm" style="text-align:left;font-size:10" width="7.6cm" height="1.3cm">
            备注：<xsl:value-of select="ds/Payment/Remark" />
          </span>
          <span x="0" y="6.5cm" style="text-align:left" width="11.4cm" height="1.3cm">
            录入员：<xsl:value-of select="ds/Payment/TrueName" />$nbsp;办理点：<xsl:value-of select="ds/Payment/PostSchoolName" />
          </span>
          <span x="0" y="6.9cm" style="text-align:left;font-size:6;font-style:italic" width="11.4cm" height="1.3cm">
            打印者：<xsl:value-of select="$PrintTrueName" />$nbsp;打印时间：<xsl:value-of select="$PrintDateTime" />
          </span>
        </div>

        <line x="9.5cm" y="0" endx="9.5cm" endy="7.9cm" style="border:0.1;border-style:dot"></line>

        <div x="10.2cm" y="0">
          <span x="0" y="0.2cm" style="text-align:center;font-size:22;font-family:黑体;" width="7.6cm" height="1.3cm">
            <xsl:value-of select="$TitlePrefix" />充值单</span>
          <span x="0" y="1.3cm" style="text-align:left" width="7.6cm" height="1.3cm">
            姓名：<xsl:value-of select="ds/Payment/StudentName" /> 学号：<xsl:value-of select="ds/Payment/StudentID" />
          </span>
          <span x="0" y="1.6cm" style="text-align:left" width="7.6cm" height="1.3cm">
            日期：<xsl:value-of select="String:FormatDate('{0:yyyy-MM-dd HH:mm:ss}',ds/Payment/DateAndTime)" />
          </span>
          <span x="0" y="2cm" style="text-align:left" width="7.6cm" height="1.3cm">
            编号：<xsl:value-of select="ds/Payment/PaymentID" />
          </span>
          <span x="0" y="2.4cm" style="text-align:left" width="7.6cm" height="1.3cm">
            类型：<xsl:value-of select="ds/Payment/PaymentTypeName" />
          </span>
          <span x="0" y="3.3cm" style="text-align:left;font-size:18" width="7.6cm" height="1.3cm" >
            金额：<xsl:value-of select="String:FormatNumber('{0:c}',ds/Payment/PayMoney)" />
          </span>
          <span x="0" y="4.3cm" style="text-align:left;font-size:10" width="7.6cm" height="1.3cm">
            （大写）<xsl:value-of select="String:CHSMoney(ds/Payment/PayMoney)"/>
          </span>
          <span x="0" y="4.8cm" style="text-align:left;font-size:10" width="7.6cm" height="1.3cm">单位盖章：______________________</span>
          <span x="0" y="5.3cm" style="text-align:left;font-size:10" width="7.6cm" height="1.3cm">
            备注：<xsl:value-of select="ds/Payment/Remark" />
          </span>
          <span x="0" y="6.5cm" style="text-align:left" width="7.6cm" height="1.3cm">
            录入员：<xsl:value-of select="ds/Payment/TrueName" />$nbsp;办理点：<xsl:value-of select="ds/Payment/PostSchoolName" />
          </span>
          <span x="0" y="6.9cm" style="text-align:left;font-size:6;font-style:italic" width="11.4cm" height="1.3cm">
            打印者：<xsl:value-of select="$PrintTrueName" />$nbsp;打印时间：<xsl:value-of select="$PrintDateTime" />
          </span>
        </div>




<table x="6.7cm" y="1.45cm" width="2cm">
 <tbody>
<tr height="1.9cm">
              <td width="2cm" format="child">
                <image x="0cm" y="0cm" width="2cm" height="2cm" twocode="true">
                  <xsl:value-of select="String:BindCode(ds/Payment/StudentID)" />
                </image>
              </td>
            </tr>
            <tr height="0.6cm">
              <td width="2cm" style="font-size:6">
                绑定公众号
              </td>
            </tr>
 </tbody>
</table>







<table x="17cm" y="1.45cm" width="2cm">
 <tbody>
<tr height="1.9cm">
              <td width="2cm" format="child">
                <image x="0cm" y="0cm" width="2cm" height="2cm" twocode="true">
                  <xsl:value-of select="String:BindCode(ds/Payment/StudentID)" />
                </image>
              </td>
            </tr>
            <tr height="0.6cm">
              <td width="2cm" style="font-size:6">
                绑定公众号
              </td>
            </tr>
 </tbody>
</table>




      </body>
    </html>









  </xsl:template>
</xsl:stylesheet>