﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:MTString">

  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="TitlePrefix"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>
  <xsl:template match="/">
    <html>
      <head>
        <pagesetting>
          <landscape>false</landscape>
          <paperkind>Custom</paperkind>
          <paperwidth>21.5cm</paperwidth>
          <paperheight>9cm</paperheight>
          <pageleft>5cm</pageleft>
          <pageright>0.6cm</pageright>
          <pagetop>0.8cm</pagetop>
          <pagebottom>0.5cm</pagebottom>
          <fontname>宋体</fontname>
          <fontsize>8</fontsize>
          <doctype>1</doctype>
        </pagesetting>
      </head>
      <body>
        <div x="0cm" y="0">
          <span x="0" y="0.6cm"  style="text-align:center;font-size:22;font-family:黑体;" width="14cm" height="1.3cm">
            <xsl:value-of select="$TitlePrefix" />充值单</span>
          <span x="0" y="2cm" align="left" width="20cm" height="1.3cm">
            编号：<xsl:value-of select="ds/Payment/PaymentID" />$nbsp;姓名：<xsl:value-of select="ds/Payment/StudentName" />$nbsp;学号：<xsl:value-of select="ds/Payment/StudentID" />$nbsp;日期：<xsl:value-of select="String:FormatDate('{0:yyyy-MM-dd}',ds/Payment/DateAndTime)" />$nbsp;类型：<xsl:value-of select="ds/Payment/PaymentTypeName" />
          </span>
          <span x="0" y="2.5cm" style="text-align:left;font-size:18" width="20cm" height="1.3cm">
            金额：<xsl:value-of select="String:FormatNumber('{0:c}',ds/Payment/PayMoney)" />
          </span>
          <span x="0" y="3.3cm" style="text-align:left;font-size:10" width="20cm" height="1.3cm">
            （大写）<xsl:value-of select="String:CHSMoney(ds/Payment/PayMoney)"/>
          </span>
          <span x="0" y="4.2cm" style="text-align:left;font-size:10" width="7.6cm" height="4cm">
            备注：<xsl:value-of select="ds/Payment/Remark" />
          </span>
          <span x="7cm" y="3.3cm" style="text-align:left;font-size:12" width="8cm" height="1.3cm">客户签字：<br />___________________________</span>
          <span x="0" y="6.5cm" style="text-align:left" width="20cm" height="1.3cm">
            打印者：<xsl:value-of select="$PrintTrueName" />$nbsp;打印时间：<xsl:value-of select="$PrintDateTime" />$nbsp;录入员：<xsl:value-of select="ds/Payment/TrueName" />$nbsp;办理点：<xsl:value-of select="ds/Payment/PostSchoolName" />
          </span>




<table x="-3cm" y="0.5cm" width="3cm">
 <tbody>
<tr height="3cm">
              <td width="3cm" format="child">
                <image x="0cm" y="0cm" width="3cm" height="3cm" twocode="true">
                  <xsl:value-of select="String:BindCode(ds/Payment/StudentID)" />
                </image>
              </td>
            </tr>
            <tr height="0.5cm">
              <td width="3cm">
                扫码绑定公众号
              </td>
            </tr>
 </tbody>
</table>


        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>