﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:MTString">

  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="TitlePrefix"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>
  <xsl:template match="/">
    <html>
      <head>
        <pagesetting>
          <landscape>false</landscape>
          <paperkind>Custom</paperkind>
          <paperwidth>5.8cm</paperwidth>
          <paperheight>17.5cm</paperheight>
          <pageleft>0mm</pageleft>
          <pageright>5mm</pageright>
          <pagetop>8mm</pagetop>
          <pagebottom>5mm</pagebottom>
          <fontname>微软雅黑</fontname>
          <fontsize>9</fontsize>
          <doctype>1</doctype>
          <resolutionkind>3</resolutionkind>
        </pagesetting>
        <style>
          .thead{
          border-top-width:0.5mm;
          border-left-width:0.5mm;
          border-bottom-width:0.5mm;
          border-right-width:0.5mm;
          text-align:center;
          font-style:bold
          }
          .bottom{
          border-left-width:0.5mm;
          border-bottom-width:0.5mm;
          border-right-width:0.5mm;
          font-style:bold
          }
          .left{
          border-left-width:0.5mm;
          font-style:bold
          }
          .right{
          border-right-width:0.5mm;
          font-style:bold
          }
          .leftright{
          border-left-width:0.5mm;
          border-right-width:0.5mm;
          font-style:bold
          }
        </style>
      </head>
      <body>

          <span x="0" y="0.2cm"  style="text-align:center;font-size:14;font-family:黑体;" width="4.8cm" height="1.3cm">
           <xsl:value-of select="$TitlePrefix" /><xsl:value-of select="ds/Payment/PaymentTypeName" />单</span>
          <span x="0" y="1.5cm" align="left" width="4.8cm" height="2.8cm">
            姓名：<xsl:value-of select="ds/Payment/StudentName" /> <br />
            学号：<xsl:value-of select="ds/Payment/StudentID" /> <br />
            日期：<xsl:value-of select="String:FormatDate('{0:yyyy-MM-dd HH:mm:ss}',ds/Payment/DateAndTime)" /> <br />
            编号：<xsl:value-of select="ds/Payment/PaymentID" /> <br />
          </span>
          <span x="0" y="4cm" style="text-align:left;font-size:14" width="4.8cm" height="1.3cm">
            金额：<xsl:value-of select="String:FormatNumber('{0:c}',ds/Payment/PayMoney)" />
          </span>
          <span x="0" y="5cm" style="text-align:left;font-size:9" width="4.8cm" height="3cm">
            （大写）<xsl:value-of select="String:CHSMoney(ds/Payment/PayMoney)"/> <br />
            备注：<xsl:value-of select="ds/Payment/Remark" />
          </span>
        
        <span x="0cm" y="6.8cm" style="width:4.8cm;height:3cm;text-align:left;font-size:8">
                  录入员：<xsl:value-of select="ds/Payment/TrueName" /><br />
                  收费点：<xsl:value-of select="ds/Payment/PostSchoolName" /><br />
                  地址：<xsl:value-of select ="ds/School/Address" /><br />
                  电话：<xsl:value-of select ="ds/School/Tel" /><br />
                  打印者：<xsl:value-of select="$PrintTrueName" /><br />
                  打印时间：<xsl:value-of select="$PrintDateTime" />
        </span>




        <span x="0" y="9.8cm" style="text-align:left;font-size:11" width="4.8cm" height="1.3cm">客户签字：</span>

<table x="0cm" y="10.5cm" width="4.8cm">

 <tbody>
<tr height="4cm">
              <td width="4.8cm" format="child">
                <image x="0.5cm" y="0.4cm" width="4cm" height="4cm" twocode="true">
                  <xsl:value-of select="String:BindCode(ds/Payment/StudentID)" />
                </image>
              </td>
            </tr>
            <tr height="0.8cm">
              <td width="4.8cm">
                扫码绑定公众号
              </td>
            </tr>

            <tr height="2cm">
              <td width="4.8cm" format="child">
                <line x="0cm" y="1cm" endx="6cm" endy="1cm" style="border:0.1mm; border-style:dot"></line>
              </td>
            </tr>

 </tbody>
</table>

      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>