﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:MTString">

  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="TitlePrefix"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>
  <xsl:template match="/">
    <html>
      <head>
        <pagesetting>
          <landscape>false</landscape>
          <paperkind>Custom</paperkind>
          <paperwidth>5.8cm</paperwidth>
          <paperheight>15.5cm</paperheight>
          <pageleft>0mm</pageleft>
          <pageright>5mm</pageright>
          <pagetop>8mm</pagetop>
          <pagebottom>5mm</pagebottom>
          <fontname>微软雅黑</fontname>
          <fontsize>8</fontsize>
          <doctype>4</doctype>
          <resolutionkind>3</resolutionkind>
        </pagesetting>
        <style>
          .thead{
          border-top-width:0.5mm;
          border-left-width:0.5mm;
          border-bottom-width:0.5mm;
          border-right-width:0.5mm;
          text-align:center;
          font-style:bold
          }
          .bottom{
          border-left-width:0.5mm;
          border-bottom-width:0.5mm;
          border-right-width:0.5mm;
          font-style:bold
          }
          .left{
          border-left-width:0.5mm;
          font-style:bold
          }
          .right{
          border-right-width:0.5mm;
          font-style:bold
          }
          .leftright{
          border-left-width:0.5mm;
          border-right-width:0.5mm;
          font-style:bold
          }
        </style>
      </head>
      <body>

          <span x="0" y="0.2cm"  style="text-align:center;font-size:14;font-family:黑体;" width="4.8cm" height="1.3cm">
            <xsl:value-of select="$TitlePrefix" />考勤单</span>


<div x="0" y="5">
          <span x="0" y="0.8cm" align="left" width="4.8cm" height="1.3cm">
            学号：<xsl:value-of select="ds/Merger/StudentID" />
          </span>

          <span x="0" y="1.2cm" align="left" width="4.8cm" height="1.3cm">
            姓名：<xsl:value-of select="ds/Merger/StudentName" />          
          </span>

          <span x="0" y="1.8cm" align="left" width="4.8cm" height="1.3cm" style="font-style:bold">
            上课日期：<xsl:value-of select="String:FormatDate('{0:yyyy-MM-dd HH:mm}',ds/Merger/StartDate)" />
          </span>
          <span x="0" y="2.2cm" align="left" width="4.8cm" height="1.3cm">
            班号：<xsl:value-of select="ds/Merger/ClassID" />
          </span>
          <span x="0" y="2.6cm" align="left" width="4.8cm" height="1.3cm">
            班级名称：<xsl:value-of select="ds/Merger/ClassName" />
          </span>

          <span x="0" y="3cm" align="left" width="4.8cm" height="1.3cm">
            课题：<xsl:value-of select="ds/Merger/Subject" />
          </span>

        
          <span x="0" y="3.4cm" align="left" width="4.8cm" height="1.3cm">
            讲师：<xsl:value-of select="ds/Merger/TeacherName" />
          </span>

          <span x="0" y="3.8cm" align="left" width="4.8cm" height="1.3cm">
            教室：<xsl:value-of select="ds/Merger/ClassroomName" />
          </span>

          <span x="0" y="4.2cm" align="left" width="4.8cm" height="1.3cm">
            考勤时间：<xsl:value-of select="String:FormatDate('{0:yyyy-MM-dd HH:mm}',ds/Merger/SignOn)" />
          </span>

          <span x="0" y="4.6cm" align="left" width="4.8cm" height="1.3cm">
            课时进度：<xsl:value-of select="ds/Merger/CourseProgress" /> /<xsl:value-of select="ds/Merger/TotalLessons" />
          </span>

          <span x="0" y="5cm" align="left" width="4.8cm" height="1.3cm">
            备注：<xsl:value-of select="ds/Merger/Remark" />          
          </span>

</div>




        <span x="0" y="6.5cm" style="text-align:left;font-size:10" width="7.6cm" height="1.3cm">机构盖章：________________</span>
        <span x="0cm" y="7.8cm" style="width:4.8cm;height:1.5cm;text-align:left;font-size:8">
                  打印者：<xsl:value-of select="$PrintTrueName" /><br />
                  打印时间：<xsl:value-of select="$PrintDateTime" />
        </span>



<table x="0cm" y="8.5cm" width="4.8cm">

 <tbody>
<tr height="4cm">
              <td width="4.8cm" format="child">
                <image x="0.5cm" y="0.4cm" width="4cm" height="4cm" twocode="true">
                  <xsl:value-of select="String:BindCode(ds/Merger/StudentID)" />
                </image>
              </td>
            </tr>
            <tr height="0.8cm">
              <td width="4.8cm">
                扫码绑定公众号
              </td>
            </tr>

            <tr height="1.5cm">
              <td width="4.8cm" format="child">
                <line x="0cm" y="1cm" endx="6cm" endy="1cm" style="border:0.1mm; border-style:dot"></line>
              </td>
            </tr>

 </tbody>
</table>

      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>