﻿<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:MTString">

  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="TitlePrefix"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>

  <xsl:template match="/">

    <html>
      <head>
        <pagesetting>
          <landscape>true</landscape>
          <paperkind>A4</paperkind>
          <pageleft>1.8cm</pageleft>
          <pageright>1.8cm</pageright>
          <pagetop>0.5cm</pagetop>
          <pagebottom>0.4cm</pagebottom>
          <pageno style="font-size:9">页码：{0}/{1}</pageno>
          <fontsize>10</fontsize>
          <fontname>宋体</fontname>
          <doctype>3</doctype>
        </pagesetting>

        <style>
          .thead{
          border-top-width:0.3mm;
          border-left-width:0.3mm;
          border-bottom-width:0.3mm;
          border-right-width:0.3mm;
          text-align:center;
          font-style:bold
          }

          .bottom{
          border-left-width:0.3mm;
          border-bottom-width:0.3mm;
          border-right-width:0.3mm;
          font-style:bold;
          border:0.1;
          }

          .left{
          border-left-width:0.3mm;
          font-style:bold
          }

          .right{
          border-right-width:0.3mm;
          font-style:bold
          }

          .leftright{
          border-left-width:0.3mm;
          border-right-width:0.3mm;
          font-style:bold
          }

          .border{
          border:0.2;
          }

          .bold
          {
          font-style:bold;
          }

          .rightborder
          {
          border-right-width:0.2mm;
          }

        </style>
      </head>
      <body>
        <span x="0" y="1.27cm"  style="font-size:25;font-family:黑体;text-align:center" width="27cm" height="1.27cm">
          <xsl:value-of select="$TitlePrefix" /><xsl:value-of select="ds/Class/ClassName" />点名表
        </span>
        <span x="0" y="3cm" style="text-align:left" width="20cm" height="0.5cm">
          班级编号：<xsl:value-of select="ds/Class/ClassID" />$nbsp;讲师：<xsl:value-of select="ds/Class/TeacherName" />$nbsp;开课时间：<xsl:value-of select="String:FormatDate('{0:yyyy年MM月dd日}',ds/Class/StartDate)" />$nbsp;上课规律：<xsl:value-of select="ds/Class/TimeRule" />
        </span>
        <span x="0" y="18.2cm" style="text-align:right" width="20cm" height="1.27cm">
          制表人：<xsl:value-of select="$PrintTrueName" />$nbsp;时间：<xsl:value-of select="String:FormatDate('{0:d}',$PrintDateTime)" />
        </span>
        <span x="0" y="18.2cm" style="text-align:left" width="20cm" height="1.27cm">
          总数：<xsl:value-of select="count(ds/StuClass[ScStateID=1 or ScStateID=2])" />人
        </span>
        <span x="5cm" y="18.2cm" align="left" width="27cm" height="1.27cm">
          正常√迟到＼早退／ 请假 △ 缺课 ○
        </span>

        <table x="0" y="3.5cm" class="border" maxlines="35">

          <thead class="thead">
            <tr height="0.6cm">
              <td width="1.27cm" class="bold" >序号</td>
              <td width="2.2cm" class="bold">姓名</td>
              <td width="2.2cm" class="bold">别名</td>
              <td width="2.2cm" class="bold" format="child" style="padding:0">
                <span style="font-size:8;border:0;text-align:left;text-valign:bottom;padding:0.6">学号</span>
                <line style="border:0.1mm"  x="0" y="0" endx="2.2cm" endy="0.6cm" />
                <span style="font-size:8;border:0;text-align:right;text-valign:top;padding:0.6">日期</span>
              </td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="0.6cm" class="bold"></td>
              <td width="4cm" class="bold">备注</td>
            </tr>

          </thead>


          <tbody class="bottom">
            <xsl:for-each select="ds/StuClass[ScStateID=1 or ScStateID=2]">
              <xsl:variable name="StudentID" select="StudentID" ></xsl:variable>
              <tr height="0.4cm">
                <td width="1.27cm" style="border-right-width:0.3mm;font-size:8">
                  <xsl:number value="position()" format="1" />
                </td>
                <td width="2.2cm" style="border-right-width:0.3mm;font-size:8">
                  <xsl:value-of select="StudentName" />
                </td>
                <td width="2.2cm" style="border-right-width:0.3mm;font-size:8">
                  <xsl:value-of select="/ds/Student[StudentID=$StudentID]/Byname" />
                </td>
                <td width="2.2cm" style="border-right-width:0.3mm;font-size:8">
                  <xsl:value-of select="StudentID" />
                </td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="0.6cm"></td>
                <td width="4cm" align="center"></td>
              </tr>
            </xsl:for-each>
            <filltr height="0.4cm">
              <td width="1.27cm" style="border-right-width:0.3mm;font-size:8">
              </td>
              <td width="2.2cm"  style="border-right-width:0.3mm;font-size:8">
              </td>
              <td width="2.2cm"  style="border-right-width:0.3mm;font-size:8">
              </td>
              <td width="2.2cm" style="border-right-width:0.3mm;font-size:8">
              </td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="0.6cm"></td>
              <td width="4cm" align="center"></td>
            </filltr>
          </tbody>

        </table>

      </body>

    </html>

  </xsl:template>
</xsl:stylesheet>