﻿<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:MTString">

  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="TitlePrefix"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>

  <xsl:template match="/">

    <html>
      <head>
        <pagesetting>
          <landscape>false</landscape>
          <paperkind>Custom</paperkind>
          <paperwidth>21.5cm</paperwidth>
          <paperheight>9cm</paperheight>
          <pageleft>45mm</pageleft>
          <pageright>5mm</pageright>
          <pagetop>10mm</pagetop>
          <pagebottom>5mm</pagebottom>
          <fontname>宋体</fontname>
          <fontsize>8</fontsize>
          <doctype>1</doctype>
          <resolutionkind>3</resolutionkind>
        </pagesetting>

        <style>
          .thead{
          border-top-width:0.2mm;
          border-left-width:0.2mm;
          border-bottom-width:0.2mm;
          border-right-width:0.2mm;
          text-align:center;
          font-style:bold
          }

          .bottom{
          border-left-width:0.2mm;
          border-bottom-width:0.2mm;
          border-right-width:0.2mm;
          font-style:bold
          }

          .left{
          border-left-width:0.2mm;
          font-style:bold
          }

          .right{
          border-right-width:0.2mm;
          font-style:bold
          }

          .leftright{
          border-left-width:0mm;
          border-right-width:0mm;
          font-style:bold
          }

        </style>
      </head>
      <body>

        <span x="0" y="0.1cm" style="width:14cm; height:1cm;text-align:center;font-size:18;font-family:黑体;">
          <xsl:if test="ds/Bill/BillTypeID = 1">
            <xsl:value-of select="$TitlePrefix" />报名凭据
          </xsl:if>
          <xsl:if test="ds/Bill/BillTypeID = 0">
            <xsl:value-of select="$TitlePrefix" />退货凭据
          </xsl:if>
        </span>
        <span x="10cm" y="1cm">
          欠费：<xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Payables - ds/Bill/Payed)" />
        </span>

        <span x="12cm" y="1cm">
          付款方式：<xsl:value-of select="ds/Bill/PayMethodName" />
        </span>
        <span x="0" y="1cm" align="left" width="14cm" height="1.27cm">
          姓名：<xsl:value-of select="ds/Bill/StudentName" />$nbsp;学号：<xsl:value-of select="ds/Bill/StudentID" />$nbsp;日期：<xsl:value-of select="String:FormatDate('{0:yyyy-MM-dd}',ds/Bill/DateAndTime)" />$nbsp;流水号：<xsl:value-of select="ds/Bill/BillID" />
        </span>

        <table x="0" y="1.5cm" minlines="6" style="border:0.1mm;" class="leftright">

          <thead>
            <tr height="0.5cm" class="thead leftright">
              <td width="4.5cm" style="font-style:bold" class="leftright">收费项</td>
              <td width="1.5cm" style="font-style:bold" class="leftright">单价</td>
              <td width="1cm" style="font-style:bold" class="leftright">数量</td>
              <td width="1cm" style="font-style:bold" class="leftright">单位</td>
              <td width="1.5cm" style="font-style:bold" class="leftright">小计</td>
              <td width="5cm" style="font-style:bold" class="leftright">备注</td>
            </tr>
            <tr x="9.5cm" height="0cm" class="leftright">
              <td width="5cm" style="height:4cm;">

                      <xsl:for-each select="/ds/Class">
                            班号：<xsl:value-of select="ClassID" />
                            名称：<xsl:value-of select="ClassName" />
                            上课规律：<xsl:value-of select="TimeRule" />
                            教室：<xsl:value-of select="ClassroomName" />
                            老师：<xsl:value-of select="TeacherName" />
                      </xsl:for-each>
                <xsl:value-of select="ds/Bill/Remark" />
              </td>
            </tr>
          </thead>


          <tbody>

            <xsl:for-each select="ds/BillItem">
              <tr height="0.5cm" style="border-top-width:0mm;border-bottom-width:0mm;" class="leftright">
                <td width="4.5cm" style="text-formatflags:linelimit" class="leftright">
                  <xsl:value-of select="ProductName" /><xsl:value-of select="String:AddBrackets(PackageName)" />
                </td>
                <td width="1.5cm" style="font-size:7" class="leftright">
                  <xsl:value-of select="String:FormatNumber('{0:c}',UnitPrice)" />
                </td>
                <td width="1cm" class="leftright">
                  <xsl:value-of select="Amount" />
                </td>
                <td width="1cm" class="leftright">
                  <xsl:value-of select="UnitName" />
                </td>
                <td width="1.5cm" style="font-size:7" class="leftright">
                  <xsl:value-of select="String:FormatNumber('{0:c}',Amount * UnitPrice)" />
                </td>
              </tr>
            </xsl:for-each>
            <filltr height="0.5cm" style="border-top-width:0mm;border-bottom-width:0mm;">
              <td width="4.5cm"  class="leftright">
              </td>
              <td width="1.5cm" class="leftright">
              </td>
              <td width="1cm" class="leftright">
              </td>
              <td width="1cm" class="leftright">
              </td>
              <td width="1.5cm" class="leftright">
              </td>
            </filltr>
          </tbody>

          <tfoot>
            <tr height="0.5cm" style="border-top-width:0.25mm;border-bottom-width:0.25mm;">
              <td width="4.5cm" class="leftright">合计：</td>
              <td width="5cm" class="leftright">
                <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Pay)" />
              </td>
            </tr>
            <tr height="0.5cm" style="border-top-width:0.25mm;border-bottom-width:0.25mm;">
              <td width="4.5cm" class="leftright">
                <xsl:if test="ds/Bill/BillTypeID = 1">优惠：</xsl:if>
                <xsl:if test="ds/Bill/BillTypeID = 0">扣除：</xsl:if>
              </td>
              <td width="5cm" class="leftright">
                <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Discount)" />
              </td>
            </tr>
            <tr height="0.75cm" class="bottom">
              <td width="14.5cm" class="leftright">
                <xsl:if test="ds/Bill/BillTypeID = 1">实收金额：</xsl:if><xsl:if test="ds/Bill/BillTypeID = 0">实退金额：</xsl:if>
                <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Payed)"/> （大写）<xsl:value-of select="String:CHSMoney(ds/Bill/Payed)"/> $nbsp;客户签字：______________________
              </td>
            </tr>



          </tfoot>

        </table>

        <span x="0" y="6.8cm" width="13.8cm" height="1.3cm" style="text-align:right">
          录入员：<xsl:value-of select="ds/Bill/TrueName" />$nbsp;收费点：<xsl:value-of select="ds/Bill/PostSchoolName" />
        </span>

        <span x="0" y="6.8cm" width="11cm" height="1.3cm" style="font-size:6; font-style:italic;">
          打印者：<xsl:value-of select="$PrintTrueName" />$nbsp;打印时间：<xsl:value-of select="$PrintDateTime" />
        </span>








<table x="-3cm" y="0cm" width="3cm">
 <tbody>
<tr height="3cm">
              <td width="3cm" format="child">
                <image x="0cm" y="0cm" width="3cm" height="3cm" twocode="true">
                  <xsl:value-of select="String:BindCode(ds/Bill/StudentID)" />
                </image>
              </td>
            </tr>
            <tr height="0.5cm">
              <td width="3cm">
                扫码绑定公众号
              </td>
            </tr>
 </tbody>
</table>



      </body>
    </html>

  </xsl:template>
</xsl:stylesheet>