﻿<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:msxsl="urn:schemas-microsoft-com:xslt"
xmlns:fo="http://www.w3.org/1999/XSL/Format"
xmlns:String="urn:MTString">

  <xsl:param name="SystemName"/>
  <xsl:param name="SchoolName"/>
  <xsl:param name="TitlePrefix"/>
  <xsl:param name="SiteUrl"/>
  <xsl:param name="Email"/>
  <xsl:param name="Tel"/>
  <xsl:param name="Fax"/>
  <xsl:param name="Address"/>
  <xsl:param name="PostCode"/>
  <xsl:param name="CurrencySymbol"/>
  <xsl:param name="PrintTrueName"/>
  <xsl:param name="PrintUserID"/>
  <xsl:param name="PrintSchoolName"/>
  <xsl:param name="PrintSchoolID"/>
  <xsl:param name="PrintDateTime"/>
  <xsl:template match="/">
    <html>
      <head>
        <pagesetting>
          <landscape>false</landscape>
          <paperkind>Custom</paperkind>
          <paperwidth>7.6cm</paperwidth>
          <paperheight>0</paperheight>
          <pageleft>4mm</pageleft>
          <pageright>4mm</pageright>
          <pagetop>0mm</pagetop>
          <pagebottom>0mm</pagebottom>
          <fontname>微软雅黑</fontname>
          <fontsize>10</fontsize>
          <doctype>1</doctype>
          <resolutionkind>3</resolutionkind>
          <copies>1</copies>
        </pagesetting>
        <style>
          .thead{
          border-top-width:0mm;
          border-left-width:0mm;
          border-bottom-width:0mm;
          border-right-width:0mm;
          text-align:center;
          font-style:bold
          }
          .bottom{
          border-left-width:0mm;
          border-bottom-width:0mm;
          border-right-width:0mm;
          }
          .left{
          border-left-width:0mm;
          font-style:bold
          }
          .right{
          border-right-width:0mm;
          font-style:bold
          }
          .leftright{
          border-left-width:0mm;
          border-right-width:0mm;
          font-style:bold
          }
        </style>
      </head>
      <body>
        <table x="0cm" y="0"  style="border:0mm">
          <thead>
            
            <tr height="3.2cm">
              <td width="6.3cm" format="child">
                <span x="0" y="0.5cm" style="width:6.3cm; height:1cm;text-align:center;font-size:14;">
                  <xsl:if test="ds/Bill/BillTypeID = 1">
                    <xsl:value-of select="$TitlePrefix" />消费单</xsl:if>
                  <xsl:if test="ds/Bill/BillTypeID = 0">
                    <xsl:value-of select="$TitlePrefix" />退货单</xsl:if>
                </span>
                <span x="0" y="1.4cm">
                  姓名：<xsl:value-of select="ds/Bill/StudentName" /><br />
                  学号：<xsl:value-of select="ds/Bill/StudentID" /><br />
                  日期：<xsl:value-of select="String:FormatDate('{0:D}',ds/Bill/DateAndTime)" /><br />
                  流水号：<xsl:value-of select="ds/Bill/BillID" />
                </span>
              </td>
            </tr>
            <tr height="0.8cm" style="border-bottom-width:0.2mm">
              <td width="3.3cm" style="text-align:left;padding-left:2mm">收费项</td>
              <td width="2cm">单价</td>
              <td width="1cm">数量</td>
            </tr>
          </thead>
          <tbody>
            <xsl:for-each select="ds/BillItem">
              <xsl:variable name="ServiceID" select="ServiceID" ></xsl:variable>
              <tr height="0.5cm" style="border-top-width:0.1mm">
                <td width="3.3cm" style="text-align:left;text-formatflags:linelimit">
                  ●<xsl:value-of select="ProductName" /><xsl:value-of select="String:AddBrackets(PackageName)" />

<xsl:if test="ProductType = 8 and /ds/Bill/BillTypeID = 1">
                    <xsl:if test="ServiceState = 0">×</xsl:if>
                    <xsl:if test="ServiceState = 1">√</xsl:if>
                  </xsl:if>
                </td>
                <td width="2cm" style="text-formatflags:linelimit;font-size:10">
                  <xsl:value-of select="String:FormatNumber('{0:c}',UnitPrice)" />
                </td>
                <td width="1cm" align="center" style="font-size:9;">
                  <xsl:value-of select="String:FormatNumber('{0:0.##}',Amount)" />
                </td>
              </tr>
              <xsl:if test="ProductType = 1 and ServiceState = 1">
                <tr height="1.2cm">
                  <td width="6.3cm" style="font-size:8;text-valign:top;text-align:left;padding-left:4mm;text-formatflags:linelimit">
                    上课时间： <xsl:value-of select="String:FormatDate('{0:D}',/ds/Class[StuClassID = $ServiceID]/StartDate)" />(<xsl:value-of select="/ds/Class[StuClassID = $ServiceID]/TimeRule" />)<br />地点：<xsl:value-of select="/ds/Class[StuClassID = $ServiceID]/SchoolName" />
                    (<xsl:value-of select="/ds/Class[ServiceID = $ServiceID]/ClassroomName" />)<br />
讲师：<xsl:value-of select="/ds/Class[StuClassID = $ServiceID]/TeacherName" />
                    <br />
                  </td>
                </tr>
              </xsl:if>
            </xsl:for-each>
          </tbody>
          <tfoot>
            <tr height="3.5cm" style="border-top-width:0.2mm">
              <td width="6.3cm" style="text-align:left">
                <xsl:if test="ds/Bill/BillTypeID = 1">优惠：</xsl:if><xsl:if test="ds/Bill/BillTypeID = 0">扣除：</xsl:if>
                <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Discount)" /><br />
                <xsl:if test="ds/Bill/BillTypeID = 1">实收：</xsl:if><xsl:if test="ds/Bill/BillTypeID = 0">实退：</xsl:if>
                <xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Payed)"/><br />
                余额：<xsl:value-of select="String:FormatNumber('{0:c}',ds/Student/AvailableMoney)"/><br />
                欠费：<xsl:value-of select="String:FormatNumber('{0:c}',ds/Bill/Payables - ds/Bill/Payed)"/><br /><br />
                签字或盖章：
              </td>
            </tr>
            <tr height="1cm">
              <td width="6.3cm" style="text-align:left;font-size:9" format="child">
                <span x="0" y="0cm">
                  付款需知：购买后概不退款，√表示教材已发，×表示教材未发。
                </span>
              </td>
            </tr>
            <tr height="4cm">
              <td width="6.3cm" style="text-align:left;font-size:10" format="child">
                <span x="0" y="0cm">
                  录入员：<xsl:value-of select="ds/Bill/TrueName" /><br />
                  校区：<xsl:value-of select="ds/Bill/PostSchoolName" /><br />
                  地址：<xsl:value-of select ="ds/School/Address" /><br />
                  电话：<xsl:value-of select ="ds/School/Tel" /><br />
                  打印者：<xsl:value-of select="$PrintTrueName" /><br />
                  打印时间：<xsl:value-of select="$PrintDateTime" />
                </span>
              </td>
            </tr>
<tr height="4cm">
              <td width="4.8cm" format="child">
                <image x="0.5cm" y="0.4cm" width="4cm" height="4cm" twocode="true">
                  <xsl:value-of select="String:BindCode(ds/Bill/StudentID)" />
                </image>
              </td>
            </tr>
            <tr height="0.8cm">
              <td width="4.8cm">
                扫码绑定公众号
              </td>
            </tr>

            <tr height="1.5cm">
              <td width="4.8cm" format="child">
                <line x="0cm" y="1cm" endx="6cm" endy="1cm" style="border:0.1mm; border-style:dot"></line>
              </td>
            </tr>
          </tfoot>
        </table>

      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>