﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Search.aspx.cs" Inherits="MTCUN.Search.Search"
    Title="更多查询-分析" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/SimpleCode.ascx" TagName="SimpleCode" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
    <style type="text/css">
        .width {
            width: auto !important;
        }

        .row td {
            white-space: nowrap !important;
        }

        .row th {
            white-space: nowrap !important;
        }

        th {
            padding-left: 3px !important;
            padding-right: 3px !important;
        }

        .style1 {
            width: 100%;
        }
    </style>



    <script type="text/javascript">
        function Checks(checkbox) {
            for (var i = 0; i < document.forms[0].elements.length; i++) {
                var e = document.forms[0].elements[i];
                if (e.type == "checkbox" && e.id.substring(0, 10) == "cblColumn_") {
                    e.checked = checkbox.checked;
                }
            }
        }
        function base64encode(str) {
            var out, i, len, base64EncodeChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
            var c1, c2, c3;
            len = str.length;
            i = 0;
            out = "";
            while (i < len) {
                c1 = str.charCodeAt(i++) & 0xff;
                if (i == len) {
                    out += base64EncodeChars.charAt(c1 >> 2);
                    out += base64EncodeChars.charAt((c1 & 0x3) << 4);
                    out += "==";
                    break;
                }
                c2 = str.charCodeAt(i++);
                if (i == len) {
                    out += base64EncodeChars.charAt(c1 >> 2);
                    out += base64EncodeChars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xF0) >> 4));
                    out += base64EncodeChars.charAt((c2 & 0xF) << 2);
                    out += "=";
                    break;
                }
                c3 = str.charCodeAt(i++);
                out += base64EncodeChars.charAt(c1 >> 2);
                out += base64EncodeChars.charAt(((c1 & 0x3) << 4) | ((c2 & 0xF0) >> 4));
                out += base64EncodeChars.charAt(((c2 & 0xF) << 2) | ((c3 & 0xC0) >> 6));
                out += base64EncodeChars.charAt(c3 & 0x3F);
            }
            return out;
        }
        function base64decode(str) {
            var c1, c2, c3, c4, base64DecodeChars = new Array(-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1);
            var i, len, out;
            len = str.length;
            i = 0;
            out = "";
            while (i < len) {
                /* c1 */
                do {
                    c1 = base64DecodeChars[str.charCodeAt(i++) & 0xff];
                } while (i < len && c1 == -1);
                if (c1 == -1) break;

                /* c2 */
                do {
                    c2 = base64DecodeChars[str.charCodeAt(i++) & 0xff];
                } while (i < len && c2 == -1);
                if (c2 == -1) break;
                out += String.fromCharCode((c1 << 2) | ((c2 & 0x30) >> 4));
                /* c3 */
                do {
                    c3 = str.charCodeAt(i++) & 0xff;
                    if (c3 == 61) return out;
                    c3 = base64DecodeChars[c3];
                } while (i < len && c3 == -1);
                if (c3 == -1) break;
                out += String.fromCharCode(((c2 & 0XF) << 4) | ((c3 & 0x3C) >> 2));
                /* c4 */
                do {
                    c4 = str.charCodeAt(i++) & 0xff;
                    if (c4 == 61) return out;
                    c4 = base64DecodeChars[c4];
                } while (i < len && c4 == -1);
                if (c4 == -1) break;
                out += String.fromCharCode(((c3 & 0x03) << 6) | c4);
            }
            return out;
        }
        function utf16to8(str) {
            var out, i, len, c;
            out = "";
            len = str.length;
            for (i = 0; i < len; i++) {
                c = str.charCodeAt(i);
                if ((c >= 0x0001) && (c <= 0x007F)) {
                    out += str.charAt(i);
                } else if (c > 0x07FF) {
                    out += String.fromCharCode(0xE0 | ((c >> 12) & 0x0F));
                    out += String.fromCharCode(0x80 | ((c >> 6) & 0x3F));
                    out += String.fromCharCode(0x80 | ((c >> 0) & 0x3F));
                } else {
                    out += String.fromCharCode(0xC0 | ((c >> 6) & 0x1F));
                    out += String.fromCharCode(0x80 | ((c >> 0) & 0x3F));
                }
            }
            return out;
        }
        function utf8to16(str) {
            var out, i, len, c;
            var char2, char3;
            out = "";
            len = str.length;
            i = 0;
            while (i < len) {
                c = str.charCodeAt(i++);
                switch (c >> 4) {
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                    case 6:
                    case 7:
                        // 0xxxxxxx
                        out += str.charAt(i - 1);
                        break;
                    case 12:
                    case 13:
                        // 110x xxxx   10xx xxxx
                        char2 = str.charCodeAt(i++);
                        out += String.fromCharCode(((c & 0x1F) << 6) | (char2 & 0x3F));
                        break;
                    case 14:
                        // 1110 xxxx  10xx xxxx  10xx xxxx
                        char2 = str.charCodeAt(i++);
                        char3 = str.charCodeAt(i++);
                        out += String.fromCharCode(((c & 0x0F) << 12) | ((char2 & 0x3F) << 6) | ((char3 & 0x3F) << 0));
                        break;
                }
            }
            return out;
        }

        function onClickLink(sender, url) {
            if (parent != null) {
                if (isExitsFunction(parent.onClickLink3)) {
                    parent.onClickLink3(sender, url);
                } else {
                    if (parent.parent != null) {
                        if (isExitsFunction(parent.parent.onClickLink3)) {
                            parent.parent.onClickLink3(sender, url);
                        }
                    }
                }
            }
        }

        function isExitsFunction(funcName) {
            try {
                if (typeof (eval(funcName)) == "function") {
                    return true;
                }
            } catch (e) { }
            return false;
        }

    </script>



</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <div class=" kuai-show form">
            <table class="table" cellspacing="0">
                <thead>
                    <tr>
                        <th colspan="2"><asp:Label ID="labSearchName" runat="server"></asp:Label>
                        </th>
                    </tr>
                </thead>
                <tr>
                    <td>参数：
                    </td>
                    <td>
                        <asp:Panel ID="panelParams" runat="server">
                        </asp:Panel>
                    </td>
                </tr>
                <tr>
                    <td>字段选择：
                    </td>
                    <td>
                            <table border="0" class="mt-boxlist inline_block">
                                <tr>
                                    <td>
                                        <input onclick="Checks(this)" type="checkbox" checked="checked" id="boxall" /><label for="boxall">全选</label>
                                    </td>
                                </tr>
                            </table>
                        <div class="inline_block">
                            <asp:CheckBoxList ID="cblColumn" runat="server" RepeatDirection="Horizontal" RepeatColumns="10" CssClass="mt-boxlist">
                            </asp:CheckBoxList>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>&nbsp;
                    </td>
                    <td>
                        <asp:Button ID="btnPost" runat="server" Text="加载" OnClick="btnPost_Click" CssClass="btn btn-default" />
                        <asp:Button ID="btnExportExcel" runat="server" OnClick="btnExportExcel_Click" CssClass="btn btn-default" Text="导出" ToolTip="ExportExcel" />
                        <asp:LinkButton ID="lbnWX" CssClass="glyphicon glyphicon-phone btn btn-success" runat="server" OnClick="lbnWX_Click">发微信</asp:LinkButton>
                        <asp:LinkButton ID="lbnSMS" CssClass="glyphicon glyphicon-phone btn btn-default" runat="server" OnClick="lbnSMS_Click">发短信</asp:LinkButton>
                        <asp:LinkButton ID="lbnHighSMS" CssClass="glyphicon glyphicon-phone btn btn-default" runat="server" OnClick="lbnHighSMS_Click">发短信(高级)</asp:LinkButton>
                    </td>
                </tr>
                <tr>
                    <td>&nbsp;
                    </td>
                    <td>
                        <div style="background-color: #FEE7A2; width: auto">
                            <asp:Literal ID="litRemark" runat="server"></asp:Literal>
                        </div>
                    </td>
                </tr>
            </table>
            <br />
            <div id="printBody" style="padding: 5px; padding-left: 20px; padding-right: 20px; border: 1px solid #c0c0c0; background-color: #FFFFFF; width: auto; overflow-x:auto">
                <div style="margin-top: 20px; margin-bottom: 50px">
                    <asp:Panel ID="Panel1" runat="server">
                        <br />
                        <table class="style1">
                            <tr>
                                <td>图表类型：<asp:DropDownList ID="ddlChartType" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlChartType_SelectedIndexChanged">
                                    <asp:ListItem Value="10">柱图</asp:ListItem>
                                    <asp:ListItem Value="17">饼图</asp:ListItem>
                                    <asp:ListItem Value="7">进度图</asp:ListItem>
                                    <asp:ListItem Value="5">线形图</asp:ListItem>
                                </asp:DropDownList>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <asp:Chart ID="Chart1" runat="server" AntiAliasing="All" BackGradientStyle="TopBottom"
                                        BackSecondaryColor="White" BorderlineDashStyle="Solid" BorderWidth="1" CssClass="bgc6 borderc1"
                                        Height="396px" ImageType="Png" Palette="BrightPastel" SuppressExceptions="False"
                                        Width="850px">
                                        <Series>
                                            <asp:Series Name="Series1">
                                            </asp:Series>
                                        </Series>
                                        <ChartAreas>
                                            <asp:ChartArea BackColor="White" Name="ChartArea1">
                                                <Area3DStyle Enable3D="True" WallWidth="0" Perspective="0" PointDepth="20" />
                                                <AxisY LineColor="64, 64, 64, 64">
                                                    <LabelStyle Font="Trebuchet MS, 8.25pt, style=Bold" />
                                                    <MajorGrid LineColor="64, 64, 64, 64" />
                                                </AxisY>
                                                <AxisX LineColor="64, 64, 64, 64">
                                                    <LabelStyle Font="Trebuchet MS, 8.25pt, style=Bold" />
                                                    <MajorGrid LineColor="64, 64, 64, 64" />
                                                </AxisX>
                                            </asp:ChartArea>
                                        </ChartAreas>
                                        <Legends>
                                            <asp:Legend Name="Legend1" Enabled="false">
                                            </asp:Legend>
                                        </Legends>
                                    </asp:Chart>
                                </td>
                            </tr>
                        </table>
                    </asp:Panel>
                    <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" OnRowDataBound="GridView1_RowDataBound"
                        CssClass="table table-hover width" AllowSorting="True" OnSorting="GridView1_Sorting"
                        CellPadding="2" EnableViewState="False">
                        <RowStyle Wrap="False" />
                        <HeaderStyle Wrap="false" HorizontalAlign="Left" />
                        
                    </asp:GridView>
                </div>
            </div>
        </div>
    </form>
</body>
</html>
