﻿<%@ Page Language="c#" CodeBehind="SearchList.aspx.cs" AutoEventWireup="True" Inherits="MTCUN.Search.SearchList"
    Title="分析-更多查询列表" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="Form1" method="post" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">

                <asp:Button ID="btnAdd" runat="server" CssClass="btn btn-default" Text="新建Sql查询" OnClick="btnAdd_Click"></asp:Button>

                <asp:Button ID="btnAddPlugIns" runat="server" CssClass="btn btn-default" Text="绑定定制程序" OnClick="btnAdd_Click"></asp:Button>

                <asp:Button ID="btnApp" runat="server" CssClass="btn btn-success" Text="应用市场" OnClick="btnApp_Click"></asp:Button>
            </div>

            <asp:GridView runat="server" DataKeyNames="SearchID" CssClass="table" ID="GridView1"
                AutoGenerateColumns="False" OnRowCommand="GridView1_RowCommand" OnRowCreated="GridView1_RowCreated"
                OnRowDeleting="GridView1_RowDeleting" OnRowDataBound="GridView1_RowDataBound">
                <Columns>
                    <asp:BoundField DataField="SearchID" HeaderText="ID" ReadOnly="true" />
                    <asp:TemplateField HeaderText="标题">
                        <ItemTemplate>
                            <table>
                                <td>
                                    <%# ShowSqlIco(Eval("SearchType"),Eval("Source")) %>
                                </td>
                                <td>
                                    <asp:HyperLink ID="hlkShow" runat="server" Text='<%#Eval("SearchName")%>' onclick='<%# url((int)Eval("SearchType"),Eval("Params").ToString(),(int)Eval("SearchID")) %>' NavigateUrl='#' />
                                </td>
                            </table>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="DateAndTime" HeaderText="时间" DataFormatString="{0:d}" />
                    <asp:TemplateField HeaderText="访问权限">
                        <ItemTemplate>
                            <%# CacheItems.GetGroupAndUsers(Eval("Allow"),Eval("GroupAndUsers"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="状态">
                        <ItemTemplate>
                            <%# Rs.Items.GetLockState((int)Eval("LockState"))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="排序">
                        <ItemTemplate>
                            <asp:LinkButton ID="btnUp" runat="server" CommandName="Up" CssClass="btn btn-default glyphicon glyphicon-arrow-up"></asp:LinkButton>
                            <asp:LinkButton ID="btnDo" runat="server" CommandName="Do" CssClass="btn btn-default glyphicon glyphicon-arrow-down"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" CssClass="btn btn-default" ID="hlkEdit" Text="编辑" NavigateUrl='<%# string.Format("PostSearch"+((int)Eval("SearchType") == 0? "": "PlugIns")+".aspx?SearchID={0}&GetUrl={1}",Eval("SearchID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" CommandArgument='<%#Eval("SearchType") %>'
                                OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            <asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
    </form>

    <div class="alert alert-info mt-remark">
        <b>注意事项：</b><br />
        1、系统里没有您要的查询，可以点击“应用市场”找找看。<br />
    </div>
</body>
</html>
