﻿
Select distinct 
Student.StudentID as 学号, 
Student.StudentName as 姓名, 
GetSex(Student.Sex) as 性别, 
FormatDate(Student.DateAndTime) as 报名时间, 
Student.Tel as 电话, 
Student.Mobiletel as 手机, 
Student.Email as 电子邮件, 
Student.School as 学校, 
Student.Grade as 年级, 
StuClass.ClassID as 班级编号, 
StuClass.ClassName as 班级名称, 
StuClass.SchoolName as 上课校区, 
FormatDate(StuClass.DateAndTime) as 选班时间, 
GetScState(StuClass.ScStateID) as 选班状态, 
(StuClass.Lessons - StuClass.CourseProgress) as 剩余课时 

from LessonTime,Attend,StuClass,Student 

where LessonTime.LessonTimeID = Attend.LessonTimeID 
and Attend.StuClassID = StuClass.StuClassID 
and StuClass.StudentID=Student.StudentID 
and StuClass.SchoolID in ( {@SchoolID:校区} ) 
and LessonTime.StartDate >= {@StartDate:开始日期} 
and LessonTime.StartDate <= {@EndDate:结束日期} 
and Attend.AtStateID in (1,2,3) 
order by StuClass.ClassID