﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="LessonTime.aspx.cs" Inherits="MTCUN.Teacher.LessonTime"
    Title="排课信息-教师" %>

<%@ Import Namespace="MTCUN" %>
<%@ Register Src="../UserCol/Progress.ascx" TagName="Progress" TagPrefix="uc2" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link id="linkStyle" runat="server" href="https://cdn.staticfile.org/twitter-bootstrap/3.3.7/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />
</head>
<body>
    <!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">
        <div class=" kuai-list">
            <div class=" control_bg">
                <asp:Button ID="btnAddOneLessonTime" runat="server" CssClass="btn btn-default" OnClick="btnAddOneLessonTime_Click"
                    Text="增加排课" />
                <asp:Button ID="btnClearLessonTime" runat="server" CssClass="btn btn-default" OnClick="btnClearLessonTime_Click"
                    Text="清除排课" OnClientClick="return mt_confirm(this,'执行此操作，将删除所有未上课的排课信息，您确定要这么做？');" />
            </div>

            <asp:GridView ID="GridView1" runat="server" CssClass="table table-hover" AutoGenerateColumns="False"
                DataKeyNames="LessonTimeID" OnRowDataBound="GridView1_RowDataBound" OnRowDeleting="GridView1_RowDeleting">
                <Columns>
                    <asp:TemplateField HeaderText="上课日期">
                        <ItemTemplate>
                            <label runat="server" class='<%# (int)Eval("LeStateID") == 0 ? "label label-default": "label label-success"%>' data-toggle="tooltip" title='<%# (int)Eval("LeStateID") == 0 ? "未上课": "已上课"%>'>课</label>
                            <asp:HyperLink runat="server" ID="hlkClassInfo" Text='<%#Eval("StartDate","{0:d}")%>'
                                NavigateUrl='<%# string.Format("../class/attend.aspx?module=3&ClassID={0}&LessonTimeID={1}&GetUrl={2}",Eval("ClassID"),Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                            <span class="label label-warning"><%#GetWeek(Eval("StartDate"))%></span>
                            <%#Eval("Subject")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="上课时段">
                        <ItemTemplate>
                            <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),EndDate(Eval("EndDate")))%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="类型">
                        <ItemTemplate>
                            <asp:Label runat="server" ID="labLessonType" Text='<%#(int)Eval("LessonType") == 1 ? "正常" : "补课"%>'></asp:Label><asp:Label
                                runat="server" ID="labPlace" ForeColor="Red" Text='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)" : "(本)") : ""%>' ToolTip='<%#(int)Eval("LessonType") == 0 ? (swq.Tools.GetInt(Eval("Place")) == 1 ? "(他)表示在他班补课" : "(本)表示在本班补课") : ""%>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="Lessons" HeaderText="课时" DataFormatString="{0:0.##}"></asp:BoundField>
                    <asp:BoundField DataField="FactCount" HeaderText="出勤" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="TruancyCount" HeaderText="旷课" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="LateCount" HeaderText="迟到" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="AdvanceCount" HeaderText="早退" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="LeaveCount" HeaderText="请假" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="TeacherName" HeaderText="讲师" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="AssistantName" HeaderText="助教" ReadOnly="True"></asp:BoundField>
                    <asp:BoundField DataField="ClassroomName" HeaderText="教室" ReadOnly="True"></asp:BoundField>
                    <asp:TemplateField HeaderText="点名">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" CssClass="btn btn-default" ID="hlkAttend" Text="点名" NavigateUrl='<%# string.Format("../class/attend.aspx?module=3&ClassID={0}&LessonTimeID={1}&GetUrl={2}",Eval("ClassID"),Eval("LessonTimeID"),swq.Web.PathAndQuery()) %>'></asp:HyperLink>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="编辑" ShowHeader="False">
                        <ItemTemplate>
                            <asp:HyperLink runat="server" CssClass="btn btn-default" NavigateUrl='<%#string.Format("../class/PostLessonTime.aspx?module=3&LessonTimeID={0}&ClassID={1}&GetUrl={2}",Eval("LessonTimeID"),Eval("ClassID"),swq.Web.PathAndQuery())%>'
                                ID="hlkEdit" Text="编辑" />
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="删除">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbnDelete" runat="server" CssClass="btn btn-default" Text="删除" CommandName="Delete" OnClientClick="<%# Rs.Messages.确定删除%>"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>

            &nbsp;<asp:Literal ID="litPagerButton" runat="server"></asp:Literal>
        </div>
        <div class="mt-back">
            <label class=" btn btn-default" id="__mt_labBack" runat="server" onclick="back(this)">
                返回
            </label>
        </div>
        <div class="alert alert-info mt-remark">
            <b>注意事项：</b><br />
            1、日期后面红色数字表示当天是星期几。<br />
            2、点击“清除排课”仅删除未上课的排课，不影响已考勤的排课。<br />
        </div>
    </form>
</body>
</html>
