﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="readme.aspx.cs" Inherits="MTCUN.api.readme" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>麦田API接口教程（测试版v0.81）</title>
    <link id="mobileCss" runat="server" href="../mobile/themes/mobile.css" rel="stylesheet"
        type="text/css" />

    <style type="text/css">
        body, form {
            margin: 0px;
            padding: 0px;
        }

        .kuai {
            display: inherit;
            width: 98%;
            padding: 10px;
            margin-left: auto;
            margin-right: auto;
            margin-bottom: 50px;
            font-size: 1.2em;
        }

        .right {
            text-align: right;
        }

        .tb {
            background-color: #c0c0c0;
            font-size: 1em;
        }

            .tb td, .tb th {
                padding: 4px;
                background-color: white;
            }



        pre {
            background-color: gainsboro;
        }

        .lab_button {
            margin-left: auto;
            margin-right: auto;
            display: block;
            width: 90%;
            border-radius:5px;
            padding:6px;
            cursor:pointer;
        }

        .selected {
            background-color: darkseagreen;
        }

        .type {
            background-color: #3B5A22;
            /*color:aquamarine;*/
            color:#d9ebd7;
        }
    </style>

    <script type="text/javascript">
        var lastid = "";
        function Selected(typeid, id) {

            if (typeid > 0 && id > 0) {
                if (lastid != "") {
                    document.getElementById("div" + lastid).style.display = "none";
                    document.getElementById("b" + lastid).className = "lab_button";
                }

                lastid = (typeid + "_" + id);

                document.getElementById("div" + lastid).style.display = "block";
                document.getElementById("b" + lastid).className = "lab_button selected";
                document.getElementById("divitem" + typeid).style.display = "block";
            }

            if (typeid > 0 && id == 0) {
                var obj = document.getElementById("divitem" + typeid);
                if (obj.style.display == "block") {
                    obj.style.display = "none";
                } else {
                    obj.style.display = "block";
                }
            }
        }
    </script>
</head>
<body onload="Selected(1,1)">
    <form id="form1" runat="server">
        <div style="margin: 0px; padding: 0px">


            <div style="display: inline-block; vertical-align: top; width: 200px; height: 90%; padding: 5px; position: fixed; margin-top: 0px;" class="kuai">

                <div style="margin-bottom: 20px; height: 100%; overflow-y: auto;">
                    <div style="margin: 10px; font-weight: bold; font-family: 'Microsoft YaHei'">麦田API接口测试版v0.8</div>

                    <div id="title1" class="lab_button type" onclick="Selected(1,0)">基础类</div>
                    <div id="divitem1" style="display: none">
                        <div id="b1_1" class="lab_button" onclick="Selected(1,1)">token获取</div>
                        <div id="b1_2" class="lab_button" onclick="Selected(1,2)">返回校区信息</div>
                        <div id="b1_3" class="lab_button" onclick="Selected(1,3)">返回课程信息</div>
                        <div id="b1_4" class="lab_button" onclick="Selected(1,4)">返回教室信息</div>
                        <div id="b1_5" class="lab_button" onclick="Selected(1,5)">返回员工信息</div>
                        <div id="b1_6" class="lab_button" onclick="Selected(1,6)">返回班级信息</div>
                    </div>

                    <div id="title2" class="lab_button type" onclick="Selected(2,0)">学员类</div>
                    <div id="divitem2" style="display: none">
                        <div id="b2_1" class="lab_button" onclick="Selected(2,1)">验证学员</div>
                        <div id="b2_2" class="lab_button" onclick="Selected(2,2)">获取学员基本信息</div>
                        <div id="b2_3" class="lab_button" onclick="Selected(2,3)">返回学员班级信息</div>
                        <div id="b2_4" class="lab_button" onclick="Selected(2,4)">返回学员课表信息</div>
                        <div id="b2_5" class="lab_button" onclick="Selected(2,5)">更新学员头像</div>
                        <div id="b2_6" class="lab_button" onclick="Selected(2,6)">增加学员</div>
                    </div>

                    <div id="title3" class="lab_button type" onclick="Selected(3,0)">支付类</div>
                    <div id="divitem3" style="display: none">
                        <div id="b3_1" class="lab_button" onclick="Selected(3,1)">充值单</div>
                        <div id="b3_2" class="lab_button" onclick="Selected(3,2)">消费单</div>
                        <div id="b3_3" class="lab_button" onclick="Selected(3,3)">返回产品价格</div>
                        <div id="b3_4" class="lab_button" onclick="Selected(3,4)">返回课程价格</div>
                    </div>

                </div>
            </div>

            <div style="width: auto; vertical-align: top; margin-left: 220px;">
                <div style="margin: 10px">

                    <!--#include file="doc/1_1.aspx"-->
                    <!--#include file="doc/1_2.aspx"-->
                    <!--#include file="doc/1_3.aspx"-->
                    <!--#include file="doc/1_4.aspx"-->
                    <!--#include file="doc/1_5.aspx"-->
                    <!--#include file="doc/1_6.aspx"-->
                    <!--#include file="doc/2_1.aspx"-->
                    <!--#include file="doc/2_2.aspx"-->
                    <!--#include file="doc/2_3.aspx"-->
                    <!--#include file="doc/2_4.aspx"-->
                    <!--#include file="doc/2_5.aspx"-->
                    <!--#include file="doc/2_6.aspx"-->
                    <!--#include file="doc/3_1.aspx"-->
                    <!--#include file="doc/3_2.aspx"-->
                    <!--#include file="doc/3_3.aspx"-->
                    <!--#include file="doc/3_4.aspx"-->

                    <div class="kuai" id="divx" style="display: none">
                        <b style="font-size: 1.1em">返回学员班级信息：</b><br />
                        <br />
                        返回学员已选班级的详细信息。<br />
                        <br />
                        <b>请求方式：</b>GET。
                    <br />
                        <br />
                        <b>请求地址：</b><%=baseUrl %>api/student.ashx?access_token=TOKEN&action=getclasslist&id=STUDENTID
                <br />
                        <br />

                        <b>参数说明： </b>
                        <br />
                        <br />
                        <table class="tb" cellspacing="1">
                            <tr>
                                <th>字段</th>
                                <th>必须</th>
                                <th>说明</th>
                            </tr>
                            <tr>
                                <td>access_token</td>
                                <td>是</td>
                                <td>调用接口凭证。</td>
                            </tr>
                            <tr>
                                <td>id</td>
                                <td>是</td>
                                <td>学号。</td>
                            </tr>
                        </table>

                        <br />
                        <br />
                        <b>返回结果：</b><br />
                        <br />

                        <pre>
{
  "classlist": [
    {
      "classid": 20170022,
      "classname": "周日4：20一二年级",
      "courseid": 0,
      "coursename": null,
      "classtype": 0,
      "teacherid": 7,
      "teachername": "王星光",
      "headteacherid": 0,
      "headteachername": "",
      "classroomid": 1,
      "classroomname": "1号",
      "lessons": 96.00,
      "progress": 24.00,
      "arrangelessons": 96.00,
      "timerule": "",
      "schoolid": 1,
      "schoolname": "学校总部",
      "stucount": 0,
      "startdate": "2017/12/24 0:00:00",
      "enddate": "2019/10/20 17:50:00"
    },
    {
      "classid": 20180021,
      "classname": "学前18-21班",
      "courseid": 0,
      "coursename": null,
      "classtype": 0,
      "teacherid": 3,
      "teachername": "龙常伟",
      "headteacherid": 0,
      "headteachername": "",
      "classroomid": 1,
      "classroomname": "1号",
      "lessons": 20.00,
      "progress": 0.00,
      "arrangelessons": 0.00,
      "timerule": "",
      "schoolid": 1,
      "schoolname": "学校总部",
      "stucount": 0,
      "startdate": "2018/7/18 0:00:00",
      "enddate": "2028/7/3 23:59:59"
    },
    {
      "classid": 20180012,
      "classname": "周六4：20三四年级",
      "courseid": 0,
      "coursename": null,
      "classtype": 0,
      "teacherid": 11,
      "teachername": "王阳",
      "headteacherid": 0,
      "headteachername": "",
      "classroomid": 1,
      "classroomname": "1号",
      "lessons": 96.00,
      "progress": 9.00,
      "arrange": 26.00,
      "timerule": "",
      "schoolid": 1,
      "schoolname": "学校总部",
      "stucount": 0,
      "startdate": "2018/3/24 0:00:00",
      "enddate": "2020/1/25 17:50:00"
    }
  ],
  "errcode": 0,
  "errmsg": "ok"
}
</pre>

                        <b>参数说明：</b>
                        <br />
                        <br />
                        <table class="tb" cellspacing="1">
                            <tr>
                                <th>字段</th>
                                <th>说明</th>
                            </tr>
                            <tr>
                                <td>classid</td>
                                <td>班号。</td>
                            </tr>
                            <tr>
                                <td>classname</td>
                                <td>班级名称。</td>
                            </tr>
                            <tr>
                                <td>courseid</td>
                                <td>课程号。</td>
                            </tr>
                            <tr>
                                <td>coursename</td>
                                <td>课程名称。</td>
                            </tr>
                            <tr>
                                <td>classtype</td>
                                <td>班级类型，0一对多，1一对一。</td>
                            </tr>
                            <tr>
                                <td>teacherid</td>
                                <td>教师编号。</td>
                            </tr>
                            <tr>
                                <td>teachername</td>
                                <td>教师名称。</td>
                            </tr>
                            <tr>
                                <td>headteacherid</td>
                                <td>助教编号。</td>
                            </tr>
                            <tr>
                                <td>headteachername</td>
                                <td>助教名称。</td>
                            </tr>
                            <tr>
                                <td>classroomid</td>
                                <td>教室编号。</td>
                            </tr>
                            <tr>
                                <td>classroomname</td>
                                <td>教室名称。</td>
                            </tr>
                            <tr>
                                <td>lessons</td>
                                <td>总课时。</td>
                            </tr>
                            <tr>
                                <td>progress</td>
                                <td>课时进度。</td>
                            </tr>
                            <tr>
                                <td>arrange</td>
                                <td>已排课数。</td>
                            </tr>
                            <tr>
                                <td>timerule</td>
                                <td>上课规律。</td>
                            </tr>
                            <tr>
                                <td>stucount</td>
                                <td>学员数。</td>
                            </tr>
                            <tr>
                                <td>startdate</td>
                                <td>开课时间。</td>
                            </tr>
                            <tr>
                                <td>enddate</td>
                                <td>结课时间。</td>
                            </tr>
                            <tr>
                                <td>schoolid</td>
                                <td>校区编号。</td>
                            </tr>
                            <tr>
                                <td>schoolname</td>
                                <td>校区名称。</td>
                            </tr>
                            <tr>
                                <td>errcode</td>
                                <td>错误码，0表示成功。</td>
                            </tr>
                            <tr>
                                <td>errmsg</td>
                                <td>错误说明。</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </form>
</body>
</html>
