﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="signIn.aspx.cs" Inherits="MTCUN.weixin.signIn" %>

<%@ Import Namespace="MTCUN" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>微信考勤</title>
    <style type="text/css">
        table {
            color: #FF6600;
        }

        .font_title {
            font-size: 16px;
            color: #FF0000;
            font-weight: bold;
        }
    </style>
    <link id="mobileCss" runat="server" href="../mobile/themes/mobile.css" rel="stylesheet"
        type="text/css" />
    <script type="text/javascript" src="http://res2.wx.qq.com/open/js/jweixin-1.4.0.js"></script>
    <script type="text/javascript">

        function toRad(d) { return d * Math.PI / 180; }
        function getDisance(lat1, lng1, lat2, lng2) {
            //#lat为纬度, lng为经度, 一定不要弄错
            var dis = 0;
            var radLat1 = toRad(lat1);
            var radLat2 = toRad(lat2);
            var deltaLat = radLat1 - radLat2;
            var deltaLng = toRad(lng1) - toRad(lng2);
            var dis = 2 * Math.asin(Math.sqrt(Math.pow(Math.sin(deltaLat / 2), 2) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(deltaLng / 2), 2)));
            return dis * 6378137;
        }

        //alert(  getDisance(39.91917,116.3896,39.91726,116.3940) );

        function GetSchoolName(lat, lng) {
            document.getElementById("hfdZB").value = "0";
            var min_m = -1;
            var schoolname = "";
            for (i = 0; i < _schools.length; i++) {
                var values = _schools[i].split(',');
                var m = getDisance(values[0], values[1], lat, lng);
                if (m < 2000) {
                    if (min_m == -1 || m < min_m) {
                        min_m = m;
                        schoolname = values[2];
                        document.getElementById("hfdZB").value = "1";
                    }
                }
            }

            if (min_m > -1) {
                $("#labSchoolName").text(schoolname + "(约" + Math.round(min_m) + "米)");
            } else {
                $("#labSchoolName").text("不在有效考勤范围。");
            }
        }
    </script>
</head>
<body>
<!--#include file="../include/modal.htm"-->
    <form id="form1" runat="server">

        <bgsound id="bgsound" src="" loop="1" />
        <audio id="html5_bgsound" src="" autoplay="true" playcount="1"></audio>

        <asp:HiddenField ID="hfdZB" runat="server" Value="0" />

        <div id="web_page_contents">
            <div class="search biao_zhun_suo_jin">
                <div class="kuai-show" style="margin-top: 60px">

                    <table align="center" class="mt-table-m" style="width:100%">
                        <tr>
                            <td align="center" class="font_title" colspan="2">微信考勤</td>
                        </tr>
                        <tr>
                            <td align="right">学员：</td>
                            <td align="left">
                                <asp:Label ID="labStudentName" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right" style="width: 120px">坐标：</td>
                            <td align="left">
                                <asp:Label ID="lblLoacation" runat="server"></asp:Label></td>
                        </tr>
                        <tr>
                            <td align="right">靠近校区：</td>
                            <td align="left">
                                <asp:Label ID="labSchoolName" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">班级：</td>
                            <td align="left">
                                <asp:Label ID="labClassName" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">开课时间：</td>
                            <td align="left">
                                <asp:Label ID="labStartDate" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">教室：</td>
                            <td align="left">
                                <asp:Label ID="labClassroomName" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">消息：</td>
                            <td align="left">
                                <asp:Label ID="labMsg" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td align="center" colspan="2">
                                <asp:Button ID="btnPost" runat="server" cssclass="btn btn-success btn-sm btn-block" Text="签到" OnClick="btnPost_Click" />
                            </td>
                        </tr>
                        <tr>
                            <td align="center" colspan="2">
                                <input type="button" value="关闭" class="btn btn-default btn-sm btn-block" onclick="wx.closeWindow();" />
                            </td>
                        </tr>
                    </table>


                    <asp:GridView ID="gvStu2" runat="server" AutoGenerateColumns="False" CssClass="table"
                        DataKeyNames="StuClassID" OnRowCommand="gvStu2_RowCommand" Width="100%">
                        <Columns>
                            <asp:TemplateField HeaderText="班号">
                                <ItemTemplate>
                                    <asp:Label ID="ClassID" runat="server" Text='<%# Eval("ClassID") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="班级名称">
                                <ItemTemplate>
                                    <asp:Label ID="ClassName" runat="server" Text='<%# Eval("ClassName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="选择">
                                <ItemTemplate>
                                        <asp:LinkButton ID="lbnSelect" runat="server" CssClass="btn btn-default" CommandName="Select" CommandArgument='<%#Eval("StudentID") +"$"+Eval("StuClassID") %>'
                                            OnClientClick="return mt_confirm(this,'你确定选择的班级是正确的？');" Text="选择"></asp:LinkButton>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>

                    <asp:GridView ID="gvStu3" runat="server" AutoGenerateColumns="False" CssClass="table"
                        DataKeyNames="AttendID,StuClassID,LessonTimeID" OnRowCommand="gvStu3_RowCommand"
                        OnRowDataBound="gvStu3_RowDataBound">
                        <Columns>
                            <asp:TemplateField HeaderText="班级名称">
                                <ItemTemplate>
                                    <asp:Label ID="ClassName" runat="server" Text='<%# Eval("ClassName") %>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="上课时段">
                                <ItemTemplate>
                                    <%# string.Format("{0}-{1}", Eval("StartDate", "{0:HH:mm}"),EndDate(Eval("EndDate")))%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="出勤状态">
                                <ItemTemplate>
                                    <asp:Label runat="server" ID="AtStateID" Text='<%# Rs.Items.GetAtState(Eval("AtStateID"))%>'></asp:Label>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="选择">
                                <ItemTemplate>
                                        <asp:LinkButton ID="lbnSelect" runat="server" CssClass="btn btn-default" CommandName="Select" CommandArgument='<%#Eval("StudentID") +"$"+ Eval("LessonTimeID") +"$"+Eval("StuClassID") %>'
                                            OnClientClick="return mt_confirm(this,'你确定选择的班级是正确的？');" Text="选择"></asp:LinkButton>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </asp:GridView>
                </div>
            </div>
        </div>
    </form>
</body>
</html>

