﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="wxpayment.aspx.cs" Inherits="MTCUN.wxpayment" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>扫码支付</title>
    <link id="mobileCss" runat="server" href="Themes/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet"
        type="text/css" />

    <script type="text/javascript">

        var xmlHttp = null;
        //var newcount = 0;

        //接收消息并返回本地未读消息数。
        function ReceiveMsg() {
            try {
                if (window.XMLHttpRequest) {
                    xmlHttp = new XMLHttpRequest();
                }
                else if (window.ActiveXObject) {
                    xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
                }
                xmlHttp.open("GET", __mt_requesturl + "&action=4&s=" + Math.random(), false);
                xmlHttp.send("");

                var text = xmlHttp.responseText;
                var count = parseInt(text);

                if (count > 0) {
                    var sound = true;

                    //显示消息数。
                    ToBack(count, sound);
                }
            }
            catch (ex) {
            }
        }

        //心跳程序，保持与服务器连接。
        function HeartRequest() {
            try {

                if (window.XMLHttpRequest) {
                    xmlHttp = new XMLHttpRequest();
                }
                else if (window.ActiveXObject) {
                    xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
                }

                //连接心跳程序。
                xmlHttp.open("GET", __mt_requesturl + "&action=4&s=" + Math.random(), false);
                xmlHttp.send("");

                //存在新消息，需要更新。
                if (xmlHttp.responseText == "1") {
                    ToBack(1, true);
                } else {
                    ReceiveMsg();
                }

                window.setTimeout(HeartRequest, 5000);
            }
            catch (ex) {
                window.setTimeout(HeartRequest, 5000);
            }
        }
        window.setTimeout(HeartRequest, 5000);

        //点击返回。
        function ToBack(num, sound) {
            if (num > 0) {
                if (sound)
                    PaySound();
                document.getElementById("btnBack").click();
            }
        }

        //播放声音。
        function PaySound() {
            try {
                document.getElementById('bgaudio').play();
            } catch (e) {
            }
        }
    </script>

</head>
<body>
    <form id="form1" runat="server">

        <span style="display: none; visibility: hidden">
            <audio id="bgaudio">
                <source src="Sound/msg.mp3" type="audio/mpeg">
            </audio>
        </span>

        <table style="margin-left: auto; margin-right: auto; width: 300px" class="kuai-show">
            <tr>
                <td align="center">
                    <asp:Image ID="Image1" runat="server" /></td>
            </tr>
            <tr>
                <td>充入帐户：<asp:Label ID="labClientName" runat="server"></asp:Label></td>
            </tr>
            <tr>
                <td>充值金额：<asp:Label ID="labPrice" runat="server" ForeColor="Red"></asp:Label></td>
            </tr>
            <tr>
                <td style="color: red">请登录手机微信，扫一扫完成支付。</td>
            </tr>
        </table>
        <br />
        <div class="mt-back" style="margin-left:auto; margin-right:auto; text-align:center">
            <asp:Button ID="btnBack" runat="server" CssClass=" btn btn-success" Text="支付成功(返回)" OnClick="btnBack_Click" />
        </div>
    </form>
</body>
</html>
