import sys
import shutil
import os


def one_file(file_path, classes_dict):
    file = open(file_path, "r")

    new_file = []
    lines = file.read().split("\n")
    is_checking = 0
    rewrite = []
    c_key = ""
    for i in range(len(lines)):
        line = lines[i]
        new_file.append(line + "\n")
        if is_checking > 0:
            is_checking += 1
            if "MP_order_id" in line:
                rewrite.append([i, classes_dict[c_key]])
        if "class " in line:
            # print(line)
            c = line.split("(")[0][6:]
            for key in classes_dict.keys():
                if c == key:
                    is_checking = 1
                    c_key = key
    file.close()

    for i in rewrite:
        new_file[i[0]] = "    MP_order_id = " + str(i[1]) + "\n"

    with open(file_path, "w") as file:
        file.writelines(new_file)


def one_pass(file_path, classes_dict):
    if not os.path.exists("backup"):
        os.makedirs("backup")
    shutil.copyfile(file_path, "backup\\" + file_path.replace(os.sep, "_"))
    one_file(file_path, classes_dict)

    print(file_path, "fineshed a pass")


def main():
    files = [
        ".\\Panels\\domain.py",
        ".\\Panels\\effector.py",
        ".\\Panels\\ember.py",
        ".\\Panels\\flow.py",
        ".\\Panels\\force.py",
        ".\\Panels\\other.py",

        ".\\Gas\\Panels\\domain.py",
        ".\\Gas\\Panels\\effector.py",
        ".\\Gas\\Panels\\flow.py",

        ".\\Liquid\\Panels\\domain.py",
        ".\\Liquid\\Panels\\effector.py",
        ".\\Liquid\\Panels\\flow.py",
    ]

    classes = {
        'OBJECT_UL_domains': 0,
        'OBJECT_UL_flows': 1,
        'OBJECT_UL_effector': 2,
        'OBJECT_UL_force': 3,
        'VIEW3D_PT_AutoOpsSettings': 4,
        'VIEW3D_PT_MantaPro': 5,
        'VIEW3D_PT_MantaProDomain': 6,
        'VIEW3D_PT_MantaProFlowMain': 7,
        'VIEW3D_PT_GasBlender': 8,
        'VIEW3D_PT_MantaProFlow': 9,
        'VIEW3D_PT_DissolveBlender': 10,
        'VIEW3D_PT_FlowSourceSub': 11,
        'VIEW3D_PT_NoiseBlender': 12,
        'VIEW3D_PT_MantaProEffectorMain': 13,
        'VIEW3D_PT_FireBlender': 14,
        'VIEW3D_PT_MantaProEffector': 15,
        'VIEW3D_PT_EffectorDisplaySubGas': 16,
        'VIEW3D_PT_MantaProForceMain': 17,
        'VIEW3D_PT_MantaProForce': 18,
        'VIEW3D_PT_MantaProForceFalloff': 19,
        'VIEW3D_PT_MantaProForceKink': 20,
        'VIEW3D_PT_MantaProForceTexture': 21,
        'VIEW3D_PT_MantaProForceTextureSettings': 22,
        'VIEW3D_PT_ForceTextureColorSub': 23,
        'VIEW3D_PT_MantaProForceFalloffRadial': 24,
        'VIEW3D_PT_MantaProPanelPaint': 25,
        'VIEW3D_PT_SaveSetup': 26,
        'VIEW3D_PT_RemoveSetup': 27,
        'VIEW3D_PT_ExportImportSetup': 28,
        'VIEW3D_PT_ViewSetup': 29,
        'VIEW3D_PT_DomainParticelsSub': 30,
        'VIEW3D_PT_DomainParticelsCustomSub': 31,
        'VIEW3D_PT_AdvancedParticelsSub': 32,
        'VIEW3D_PT_DomainNoiseSub': 33,
        'VIEW3D_PT_DomainFireSub': 34,
        'VIEW3D_PT_FlowVertexGroupSub': 35,
        'VIEW3D_PT_DomainMaterialSub': 36,
        'VIEW3D_PT_DomainGuidesSub': 37,
        'VIEW3D_PT_DomainCollectionsSub': 38,
        'VIEW3D_PT_DomainBorderSub': 39,
        'VIEW3D_PT_DomainFieldSub': 40,
        'VIEW3D_PT_DomainAdvancedSub': 41,
        'VIEW3D_PT_FlowVelocitySub': 42,
        'VIEW3D_PT_BlenderLiquid': 43,
        'VIEW3D_PT_DomainBorderBlenderSub': 44,
        'VIEW3D_PT_BlenderViscosity': 45,
        'VIEW3D_PT_BlenderDiffusion': 46,
        'VIEW3D_PT_BlenderParticles': 47,
        'VIEW3D_PT_BlenderMesh': 48,
        'VIEW3D_PT_BlenderGuides': 49,
        'VIEW3D_PT_BlenderCollections': 50,
        'VIEW3D_PT_BlenderCache': 51,
        'VIEW3D_PT_BlenderCacheAdvanced': 52,
        'VIEW3D_PT_BlenderFieldWeights': 53,
        'VIEW3D_PT_CacheBlenderToolsSub': 54,
        'VIEW3D_PT_Viewport': 55,
        'VIEW3D_PT_BlenderViewport': 56,
        'VIEW3D_PT_ViewportSlice': 57,
        'VIEW3D_PT_BlenderViewportSlice': 58,
        'VIEW3D_PT_ViewportGrid': 59,
        'VIEW3D_PT_BlenderViewportGrid': 60,
        'VIEW3D_PT_ViewportVector': 61,
        'VIEW3D_PT_BlenderViewportVector': 62,
        'VIEW3D_PT_DomainParticleBlenderToolsSub': 63,
        'VIEW3D_PT_DomainBlenderToolsSub': 64,
        'VIEW3D_PT_DomainMaterailBlenderToolsSub': 65,
        'VIEW3D_PT_FlowSourceBlender': 66,
        'VIEW3D_PT_FlowVelocityBlender': 67,
        'VIEW3D_PT_AdvancedDiffusionSub': 68,
        'VIEW3D_PT_AdvancedLiquidSub': 69,
        'VIEW3D_PT_AdvancedMeshSub': 70,
        'VIEW3D_PT_FlowTextureSub': 71,
        'VIEW3D_PT_FlowTextureSettingsSub': 72,
        'VIEW3D_PT_FlowTextureColorSub': 73,
        'VIEW3D_PT_AdvancedGasSub': 74,
        'VIEW3D_PT_AdvancedAdaptiveGasSub': 75,
        'VIEW3D_PT_AdvancedGravitySub': 76,
        'VIEW3D_PT_AdvancedCacheSub': 77,
        'VIEW3D_PT_FlowEmberSub': 78,
        'VIEW3D_PT_FlowDisplaySubGas': 79,
        'VIEW3D_PT_EmberSettingsSub': 80,
        'VIEW3D_PT_FlowToolsBlender': 81,
        'VIEW3D_PT_EmberParticleSub': 82,
        'VIEW3D_PT_EmberCustomParticleSub': 83,
        'VIEW3D_PT_EmberForceSub': 84,
        'VIEW3D_PT_EmberCacheSub': 85,
        'VIEW3D_PT_EmberForceFalloffSub': 86,
        'VIEW3D_PT_EmberMaterialSub': 87,
        'VIEW3D_PT_DEV': 88,
    }

    for file in files:
        one_pass(file, classes)
        print(file, os.path.exists(file))


if __name__ == '__main__':
    main()
