# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####


import bpy
from ... import Shared
from ...Shared import uiCore, ui_textures
from ...Shared import polls as P

from ... import preferences, Icons, QuickSetup

from .. import ui as ui_gas
from ...Panels.domain import DomainSub
import os


"""
 ██████████                                       ███                 █████████             █████
░░███░░░░███                                     ░░░                 ███░░░░░███           ░░███
 ░███   ░░███  ██████  █████████████    ██████   ████  ████████     ░███    ░░░  █████ ████ ░███████   █████
 ░███    ░███ ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███    ░░█████████ ░░███ ░███  ░███░░███ ███░░
 ░███    ░███░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███     ░░░░░░░░███ ░███ ░███  ░███ ░███░░█████
 ░███    ███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███     ███    ░███ ░███ ░███  ░███ ░███ ░░░░███
 ██████████  ░░██████  █████░███ █████░░████████ █████ ████ █████   ░░█████████  ░░████████ ████████  ██████
░░░░░░░░░░    ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░  ░░░░░░
"""


class VIEW3D_PT_DomainNoiseSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "Noise"
    MP_order_id = 33

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_GAS(context) and not P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="MOD_NOISE")

        domain = context.scene.MantaPro.active_domain
        modifier_settings = Shared.modifiers.get_modifier_domain(domain=domain)

        self.prop(modifier_settings, "use_noise", text="")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "noise")


class VIEW3D_PT_DomainFireSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "Fire"
    MP_order_id = 34

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_GAS(context) and not P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="OUTLINER_OB_VOLUME")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "fire")


class VIEW3D_PT_AdvancedGasSub(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_DomainAdvancedSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Gas"
    bl_context = "objectmode"
    MP_order_id = 74

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_GAS(context) and not P.UI_BLENDER()

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "advanced_gas")


class VIEW3D_PT_AdvancedAdaptiveGasSub(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_DomainAdvancedSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Adaptive Domain"
    bl_context = "objectmode"
    MP_order_id = 75

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_GAS(context) and not P.UI_BLENDER()

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "advanced_adaptive")


"""
 ███████████  ████                          █████
░░███░░░░░███░░███                         ░░███
 ░███    ░███ ░███   ██████  ████████    ███████   ██████  ████████
 ░██████████  ░███  ███░░███░░███░░███  ███░░███  ███░░███░░███░░███
 ░███░░░░░███ ░███ ░███████  ░███ ░███ ░███ ░███ ░███████  ░███ ░░░
 ░███    ░███ ░███ ░███░░░   ░███ ░███ ░███ ░███ ░███░░░   ░███
 ███████████  █████░░██████  ████ █████░░████████░░██████  █████
░░░░░░░░░░░  ░░░░░  ░░░░░░  ░░░░ ░░░░░  ░░░░░░░░  ░░░░░░  ░░░░░



"""


class VIEW3D_PT_GasBlender(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_MantaPro"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Gas"
    bl_context = "objectmode"
    MP_order_id = 8

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_GAS(context) and P.UI_BLENDER()

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "gas")


class VIEW3D_PT_DissolveBlender(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_GasBlender"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Dissolve"
    bl_context = "objectmode"
    MP_order_id = 10
    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_GAS(context) and P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        domain = context.scene.MantaPro.active_domain
        modifier_settings = Shared.modifiers.get_modifier_domain(domain=domain)
        self.prop(modifier_settings, "use_dissolve_smoke", text="")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "dissolve")


class VIEW3D_PT_NoiseBlender(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_GasBlender"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Noise"
    bl_context = "objectmode"
    MP_order_id = 12
    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_GAS(context) and P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        domain = context.scene.MantaPro.active_domain
        modifier_settings = Shared.modifiers.get_modifier_domain(domain=domain)
        self.prop(modifier_settings, "use_noise", text="")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "noise")


class VIEW3D_PT_FireBlender(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_GasBlender"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Fire"
    bl_context = "objectmode"
    MP_order_id = 14
    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_GAS(context) and P.UI_BLENDER()

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "GAS":
            ui_gas.draw(self, context, "fire")
