# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####


import bpy
from ... import Shared
from ...Shared import uiCore, ui_textures
from ...Panels.flow import FlowSub
from ...Shared import polls as P
from ... import preferences, Icons, QuickSetup

from .. import ui as ui_gas

import os


"""
 ███████████ █████                                                      █████
░░███░░░░░░█░░███                                                      ░░███
 ░███   █ ░  ░███         ██████  █████ ███ █████     █████  █████ ████ ░███████   █████
 ░███████    ░███        ███░░███░░███ ░███░░███     ███░░  ░░███ ░███  ░███░░███ ███░░
 ░███░░░█    ░███       ░███ ░███ ░███ ░███ ░███    ░░█████  ░███ ░███  ░███ ░███░░█████
 ░███  ░     ░███      █░███ ░███ ░░███████████      ░░░░███ ░███ ░███  ░███ ░███ ░░░░███
 █████       ███████████░░██████   ░░████░████       ██████  ░░████████ ████████  ██████
░░░░░       ░░░░░░░░░░░  ░░░░░░     ░░░░ ░░░░       ░░░░░░    ░░░░░░░░ ░░░░░░░░  ░░░░░░
"""


class VIEW3D_PT_FlowVertexGroupSub(uiCore.Core, FlowSub, bpy.types.Panel):
    bl_label = "Vertex Group"
    MP_order_id = 35
    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.FLOW_GAS(context) and not P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="MOD_VERTEX_WEIGHT")

    def draw(self, context):
        flow = context.scene.MantaPro.active_flow
        if Shared.modifiers.check_category(flow) != "LIQUID":
            ui_gas.draw(self, context, "vertex_group")


class VIEW3D_PT_FlowTextureSub(uiCore.Core, FlowSub, bpy.types.Panel):
    bl_label = "Texture"
    MP_order_id = 71
    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.FLOW_GAS(context) and not P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        modifier_settings = Shared.modifiers.find_modifier(
            context.scene.MantaPro.active_flow).flow_settings
        self.label(icon="TEXTURE")
        self.prop(modifier_settings, "use_texture", text="")

    def draw(self, context):
        flow = context.scene.MantaPro.active_flow
        if Shared.modifiers.check_category(flow) != "LIQUID":
            ui_gas.draw(self, context, "texture")


"""
 ███████████ ████                               █████                          █████
░░███░░░░░░█░░███                              ░░███                          ░░███
 ░███   █ ░  ░███   ██████  █████ ███ █████    ███████    ██████  █████ █████ ███████   █████ ████ ████████   ██████
 ░███████    ░███  ███░░███░░███ ░███░░███    ░░░███░    ███░░███░░███ ░░███ ░░░███░   ░░███ ░███ ░░███░░███ ███░░███
 ░███░░░█    ░███ ░███ ░███ ░███ ░███ ░███      ░███    ░███████  ░░░█████░    ░███     ░███ ░███  ░███ ░░░ ░███████
 ░███  ░     ░███ ░███ ░███ ░░███████████       ░███ ███░███░░░    ███░░░███   ░███ ███ ░███ ░███  ░███     ░███░░░
 █████       █████░░██████   ░░████░████        ░░█████ ░░██████  █████ █████  ░░█████  ░░████████ █████    ░░██████
░░░░░       ░░░░░  ░░░░░░     ░░░░ ░░░░          ░░░░░   ░░░░░░  ░░░░░ ░░░░░    ░░░░░    ░░░░░░░░ ░░░░░      ░░░░░░
"""


class VIEW3D_PT_FlowTextureSettingsSub(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_FlowTextureSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Texture Settings"
    MP_order_id = 72

    bl_context = "objectmode"

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        if context.scene.MantaPro.active_flow:
            if Shared.modifiers.check_type_gas(context.scene.MantaPro.active_flow, "FLOW"):
                modifier_settings = Shared.modifiers.find_modifier(
                    context.scene.MantaPro.active_flow).flow_settings
                if modifier_settings.noise_texture:
                    if modifier_settings.use_texture:
                        return True
        return False

    def draw(self, context):
        flow = context.scene.MantaPro.active_flow
        if Shared.modifiers.check_category(flow) != "LIQUID":
            ui_gas.draw(self, context, "texture_settings")


class VIEW3D_PT_FlowTextureColorSub(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_FlowTextureSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Color"
    bl_context = "objectmode"
    MP_order_id = 73

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        if context.scene.MantaPro.active_flow:
            if Shared.modifiers.check_type_gas(context.scene.MantaPro.active_flow, "FLOW"):
                modifier_settings = Shared.modifiers.find_modifier(
                    context.scene.MantaPro.active_flow).flow_settings
                if modifier_settings.noise_texture and modifier_settings.use_texture:
                    return True
        return False

    def draw(self, context):
        flow = context.scene.MantaPro.active_flow
        if Shared.modifiers.check_category(flow) != "LIQUID":
            ui_gas.draw(self, context, "texture_color")


"""
 ███████████  ████                          █████
░░███░░░░░███░░███                         ░░███
 ░███    ░███ ░███   ██████  ████████    ███████   ██████  ████████
 ░██████████  ░███  ███░░███░░███░░███  ███░░███  ███░░███░░███░░███
 ░███░░░░░███ ░███ ░███████  ░███ ░███ ░███ ░███ ░███████  ░███ ░░░
 ░███    ░███ ░███ ░███░░░   ░███ ░███ ░███ ░███ ░███░░░   ░███
 ███████████  █████░░██████  ████ █████░░████████░░██████  █████
░░░░░░░░░░░  ░░░░░  ░░░░░░  ░░░░ ░░░░░  ░░░░░░░░  ░░░░░░  ░░░░░



"""


class VIEW3D_PT_FlowToolsBlender(uiCore.Core, FlowSub, bpy.types.Panel):
    bl_label = "MantaPro Tools"
    MP_order_id = 81

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.FLOW(context) and not P.FLOW_OUTFLOW(context) and P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="TOOL_SETTINGS")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        ui_gas.draw(self, context, "flow_tools")
