# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####

import bpy

from . import default
from ..Shared import ui, uiCore, modifiers, material, particles

"""
 ██████   ██████            ███                ██████████                                       ███
░░██████ ██████            ░░░                ░░███░░░░███                                     ░░░
 ░███░█████░███   ██████   ████  ████████      ░███   ░░███  ██████  █████████████    ██████   ████  ████████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ░███    ░███ ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███     ░███    ░███░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███
 ░███      ░███  ███░░███  ░███  ░███ ░███     ░███    ███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███
 █████     █████░░████████ █████ ████ █████    ██████████  ░░██████  █████░███ █████░░████████ █████ ████ █████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░    ░░░░░░░░░░    ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░
"""


def draw_domain(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.set_layout("col")
    self.enabled(ui.get_baking(modifier_settings, "ANY"))

    self.prop(modifier_settings, "resolution_max", text="Resolution Divisions")
    self.prop(modifier_settings, "time_scale")
    self.prop(modifier_settings, "cfl_condition", text="CFL Number")

    self.set_layout("col", align=True, reset=True)
    self.enabled(ui.get_baking(modifier_settings, "DATA"))
    self.icon_prop(modifier_settings, "use_adaptive_timesteps")
    if modifier_settings.use_adaptive_timesteps:
        self.prop(modifier_settings, "timesteps_max", text="Timesteps Maximum")
        self.prop(modifier_settings, "timesteps_min", text="Timesteps Minimum")

    self.set_layout("col", align=True, boxed=True)
    if context.scene.use_gravity:
        self.label("Using Scene Gravity")
    else:
        self.prop(modifier_settings, "gravity")

    self.set_layout("col")
    self.prop(modifier_settings, "clipping", text="Empty Space")
    self.separator(0.5)

    self.icon_prop(modifier_settings, "delete_in_obstacle",
                   text="Delete in Obstacles")

    if modifier_settings.cache_type == 'MODULAR':
        self.separator(1)
        ui.bake_data(self, modifier_settings, "LIQUID")


# Blender
def draw_gas(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)
    self.set_layout("col", align=True)
    self.enabled(ui.get_baking(modifier_settings, "DATA"))
    self.prop(modifier_settings, "alpha")
    self.prop(modifier_settings, "beta")
    self.separator(0.5)
    self.prop(modifier_settings, "vorticity")


def draw_dissolve(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.set_layout("col")
    self.enabled(ui.get_baking(modifier_settings, "ANY"))
    if modifier_settings.use_dissolve_smoke:
        self.prop(modifier_settings, "dissolve_speed")
        self.icon_prop(modifier_settings, "use_dissolve_smoke_log", text="Slow")
    else:
        self.label(text="Dissolve is disabled")


def draw_noise(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.set_layout("col")
    self.enabled(ui.get_baking(modifier_settings, "NOISE"))
    if modifier_settings.use_noise:
        self.prop(modifier_settings, "noise_scale", text="Upres Factor")
        self.label_prop(modifier_settings, "noise_type", text="Noise Method")
        self.prop(modifier_settings, "noise_strength")
        self.prop(modifier_settings, "noise_pos_scale")
        self.prop(modifier_settings, "noise_time_anim")

        ui.bake_noise(self, modifier_settings, "GAS")
    else:
        self.label(text="Noise is disabled")


def draw_fire(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.set_layout("col", align=True)
    self.enabled(ui.get_baking(modifier_settings, "ANY"))

    self.prop(modifier_settings, "burning_rate", text="Reaction Speed")
    self.separator(0.5)
    self.prop(modifier_settings, "flame_smoke", text="Flame Smoke")
    self.prop(modifier_settings, "flame_vorticity", text="Flame Vorticity")
    self.separator(0.5)
    self.prop(modifier_settings, "flame_max_temp", text="Temperature Maximum")
    self.prop(modifier_settings, "flame_ignition", text="Temperature Minimum")
    self.label_prop(modifier_settings, "flame_smoke_color", text="Flame Color")


def draw_cache(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)
    self.set_layout("col")
    self.prop(modifier_settings, "cache_directory", text="")

    self.set_layout("col", align=True)
    self.prop(modifier_settings, "cache_frame_start", text="Frame Start")
    self.prop(modifier_settings, "cache_frame_end", text="Frame End")

    if modifier_settings.cache_type != 'REPLAY':
        self.separator(0.5)
        self.prop(modifier_settings, "cache_frame_offset")

    self.set_layout("col")
    self.label_prop(modifier_settings, "cache_type", text="Type")

    self.ui_reset()
    self.icon_prop(modifier_settings, "cache_resumable", text="Is Resumable")

    self.ui_reset()
    if modifier_settings.cache_type == 'REPLAY':
        self.operator("mantapro.replay_clear", text="Clear Cache", icon="LOOP_BACK")

    self.ui_reset()
    self.enabled(ui.get_baking(modifier_settings, "DATA"))
    self.label_prop(modifier_settings, "cache_data_format", text="Format Volumes")

    ui.cache_worning(self, modifier_settings)

    ui.bake_all(self, modifier_settings, "GAS")


def draw_cache_advanced(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)
    self.set_layout("col", align=True)
    self.enabled(not modifier_settings.has_cache_baked_any)
    self.label_prop(modifier_settings, "openvdb_cache_compress_type", text="Compression Volumes")
    self.label_prop(modifier_settings, "openvdb_data_depth", text="Precision Volumes")
# end Blender


def draw_material(self: uiCore.Core, context):
    default.draw_material(self, context)


"""
 ██████   ██████            ███                   ██████  ████
░░██████ ██████            ░░░                   ███░░███░░███
 ░███░█████░███   ██████   ████  ████████       ░███ ░░░  ░███   ██████  █████ ███ █████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ███████    ░███  ███░░███░░███ ░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███    ░░░███░     ░███ ░███ ░███ ░███ ░███ ░███
 ░███      ░███  ███░░███  ░███  ░███ ░███      ░███      ░███ ░███ ░███ ░░███████████
 █████     █████░░████████ █████ ████ █████     █████     █████░░██████   ░░████░████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░     ░░░░░  ░░░░░░     ░░░░ ░░░░
"""


def draw_flow(self: uiCore.Core, context):
    self.set_layout("col")
    obj = context.scene.MantaPro.active_flow

    if modifiers.check_type_gas(obj, "FLOW"):

        modifier_settings = modifiers.find_modifier(
            obj).flow_settings

        self.set_layout("col")
        self.operator("mantapro.switch_type",
                      icon="ARROW_LEFTRIGHT", settings=[["kind", "FLOW"]])

        self.separator()
        self.ui_refresh()
        self.label_prop(obj.MantaPro, "flow_type", text="Flow Type")

        if obj.MantaPro.flow_type != modifier_settings.flow_type:
            self.set_layout("row", align=True)
            self.alert()
            self.label(text="WARNING: flow type out of sync")
            self.operator("mantapro_gas.flow_sync",
                          icon="FILE_REFRESH", text="")

        ui.flow(self, modifier_settings)
        self.set_layout("col")

        if modifier_settings.flow_type != "FIRE":
            self.prop(modifier_settings, "smoke_color")

        self.ui_refresh()

        self.icon_prop(modifier_settings, "use_absolute", text="Absolute Density")

        self.set_layout("col", align=True)

        if modifier_settings.flow_type != "FIRE":
            self.prop(modifier_settings, "temperature",
                      text="Initial Temperature")
            self.prop(modifier_settings, "density", text="Density", slider=True)

        if modifier_settings.flow_type != "SMOKE":
            self.prop(modifier_settings, "fuel_amount", text="Fuel")

        self.separator()
        self.label(text="Vertex Group:")
        self.ui_layout.prop_search(modifier_settings, "density_vertex_group", obj, "vertex_groups", text="")

    else:
        self.operator("mantapro_gas.make_flow", icon="PLUS")
        self.separator()

        self.operator("mantapro_gas.make_paint", icon="BRUSH_DATA")


"""
 ██████   ██████            ███                            ██████     ██████                     █████
░░██████ ██████            ░░░                            ███░░███   ███░░███                   ░░███
 ░███░█████░███   ██████   ████  ████████       ██████   ░███ ░░░   ░███ ░░░   ██████   ██████  ███████    ██████  ████████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ███░░███ ███████    ███████    ███░░███ ███░░███░░░███░    ███░░███░░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███    ░███████ ░░░███░    ░░░███░    ░███████ ░███ ░░░   ░███    ░███ ░███ ░███ ░░░
 ░███      ░███  ███░░███  ░███  ░███ ░███    ░███░░░    ░███       ░███     ░███░░░  ░███  ███  ░███ ███░███ ░███ ░███
 █████     █████░░████████ █████ ████ █████   ░░██████   █████      █████    ░░██████ ░░██████   ░░█████ ░░██████  █████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░░   ░░░░░      ░░░░░      ░░░░░░   ░░░░░░     ░░░░░   ░░░░░░  ░░░░░

"""


def draw_effector(self: uiCore.Core, context):
    effector = context.scene.MantaPro.active_effector
    modifier_settings = modifiers.find_modifier(effector).effector_settings
    self.set_layout("col")
    self.label_prop(modifier_settings, "effector_type")
    self.separator(0.5)
    self.prop(modifier_settings, "subframes", text="Sampling Subframes")
    self.prop(modifier_settings, "surface_distance", text="Surface Thickness")
    self.separator(0.5)
    self.icon_prop(modifier_settings, "use_effector", text="Use Effector")
    self.icon_prop(modifier_settings, "use_plane_init")


"""
  █████████             █████        ██████████                                       ███
 ███░░░░░███           ░░███        ░░███░░░░███                                     ░░░
░███    ░░░  █████ ████ ░███████     ░███   ░░███  ██████  █████████████    ██████   ████  ████████
░░█████████ ░░███ ░███  ░███░░███    ░███    ░███ ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███
 ░░░░░░░░███ ░███ ░███  ░███ ░███    ░███    ░███░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███
 ███    ░███ ░███ ░███  ░███ ░███    ░███    ███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███
░░█████████  ░░████████ ████████     ██████████  ░░██████  █████░███ █████░░████████ █████ ████ █████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░     ░░░░░░░░░░    ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░
"""


def draw_guides(self: uiCore.Core, context):
    self.set_layout("col")
    modifier_settings = modifiers.get_modifier_domain(context)
    self.enabled(ui.get_baking(modifier_settings, "DATA"))

    if modifier_settings.use_guide:
        self.set_layout("col")
        self.prop(modifier_settings, "guide_alpha")
        self.prop(modifier_settings, "guide_beta")
        self.prop(modifier_settings, "guide_vel_factor")
        self.label_prop(modifier_settings, "guide_source")

        if modifier_settings.guide_source == "DOMAIN":
            self.label_prop(modifier_settings, "guide_parent")
        else:
            self.separator(1)
            ui.bake_guides(self, modifier_settings, "LIQUID")
    else:
        self.label(text="Guides are disabled")


def draw_collections(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.set_layout("col")
    self.label_prop(modifier_settings, "fluid_group", text="Flow")
    self.label_prop(modifier_settings, "effector_group", text="Effector")


def draw_border(self: uiCore.Core, context):
    default.draw_border(self, context)


def draw_field(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.set_layout("col")
    self.label_prop(modifier_settings.effector_weights, "collection", text="Effector Collection")
    ui.field_weights(self, modifier_settings)


def draw_view(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.set_layout("col")
    self.prop(modifier_settings, "display_thickness")
    self.label_prop(modifier_settings, "display_interpolation")
    self.separator(0.25)
    if not modifier_settings.use_slice:
        self.prop(modifier_settings, "slice_per_voxel")
    else:
        self.label(text="Slice Per Voxel is disabled")


def draw_view_slice(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.set_layout("col")
    if modifier_settings.use_slice:
        self.label_prop(modifier_settings, "slice_axis", text="Axis")
        self.separator(0.25)
        self.prop(modifier_settings, "slice_depth", slider=True)
        if modifier_settings.display_interpolation == 'CLOSEST' or modifier_settings.color_ramp_field == 'FLAGS':
            self.icon_prop(modifier_settings, "show_gridlines")
        else:
            self.label(text="Gridlines are disabled")

    else:
        self.label(text="Slice is disabled")


def draw_view_grid(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.set_layout("col")
    if modifier_settings.use_color_ramp:
        self.label_prop(modifier_settings, "color_ramp_field", text="Field")

        if modifier_settings.color_ramp_field != 'FLAGS':
            self.prop(modifier_settings, "color_ramp_field_scale")

        color_ramp_compatible = ['FORCE_Z', 'FORCE_Y', 'FORCE_X', 'VELOCITY_Z', 'VELOCITY_Y', 'VELOCITY_X']
        if modifier_settings.color_ramp_field in color_ramp_compatible:
            self.ui_layout.template_color_ramp(modifier_settings, "color_ramp", expand=True)

    else:
        self.label(text="Grid Display is disabled")


def draw_view_vector(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.set_layout("col")

    if modifier_settings.show_velocity:
        self.label_prop(modifier_settings, "vector_display_type", text="Display As")
        if modifier_settings.vector_display_type == 'MAC':
            self.set_layout("col", align=True)
            self.icon_prop(modifier_settings, "vector_show_mac_x")
            self.icon_prop(modifier_settings, "vector_show_mac_y")
            self.icon_prop(modifier_settings, "vector_show_mac_z")
        else:
            self.icon_prop(modifier_settings, "vector_scale_with_magnitude")
        self.label_prop(modifier_settings, "vector_field", text="Field")
        self.prop(modifier_settings, "vector_scale")

        if not modifier_settings.use_guide and modifier_settings.vector_field == 'GUIDE_VELOCITY':
            self.label(text="Enable Guides first! Defaulting to Fluid Velocity", icon='INFO')

    else:
        self.label(text="Vector Display is disabled")


"""
  █████████             █████           ██████  ████
 ███░░░░░███           ░░███           ███░░███░░███
░███    ░░░  █████ ████ ░███████      ░███ ░░░  ░███   ██████  █████ ███ █████
░░█████████ ░░███ ░███  ░███░░███    ███████    ░███  ███░░███░░███ ░███░░███
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░░░███░     ░███ ░███ ░███ ░███ ░███ ░███
 ███    ░███ ░███ ░███  ░███ ░███     ░███      ░███ ░███ ░███ ░░███████████
░░█████████  ░░████████ ████████      █████     █████░░██████   ░░████░████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░      ░░░░░     ░░░░░  ░░░░░░     ░░░░ ░░░░
"""


def draw_velocity(self: uiCore.Core, context):
    default.draw_velocity(self, context)


def draw_source(self: uiCore.Core, context):
    modifier_settings = modifiers.find_modifier(
        context.scene.MantaPro.active_flow).flow_settings

    self.set_layout("col")
    self.label_prop(modifier_settings, "flow_source", text="Flow Source")

    if modifier_settings.flow_source == "PARTICLES":
        self.prop_search(modifier_settings, "particle_system",
                         context.scene.MantaPro.active_flow, "particle_systems", text="Particle System")

        self.ui_refresh()
        self.set_layout("col", align=True)

        self.icon_prop(modifier_settings, "use_particle_size")

        if modifier_settings.use_particle_size:
            self.prop(modifier_settings, "particle_size")

        return

    self.icon_prop(modifier_settings, "use_plane_init")

    self.set_layout("col", align=True)
    self.prop(modifier_settings, "surface_distance",
              text="Surface Distance")

    self.prop(modifier_settings, "volume_density",
              text="Volume Distance")


def draw_flow_display(self: uiCore.Core, context):
    default.draw_flow_display(self, context)


def draw_flow_tools(self: uiCore.Core, context):
    self.set_layout("col")
    self.operator("mantapro_gas.paint_start", icon="BRUSHES_ALL")


"""
  █████████             █████                    ██████     ██████                     █████
 ███░░░░░███           ░░███                    ███░░███   ███░░███                   ░░███
░███    ░░░  █████ ████ ░███████      ██████   ░███ ░░░   ░███ ░░░   ██████   ██████  ███████    ██████  ████████
░░█████████ ░░███ ░███  ░███░░███    ███░░███ ███████    ███████    ███░░███ ███░░███░░░███░    ███░░███░░███░░███
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░███████ ░░░███░    ░░░███░    ░███████ ░███ ░░░   ░███    ░███ ░███ ░███ ░░░
 ███    ░███ ░███ ░███  ░███ ░███   ░███░░░    ░███       ░███     ░███░░░  ░███  ███  ░███ ███░███ ░███ ░███
░░█████████  ░░████████ ████████    ░░██████   █████      █████    ░░██████ ░░██████   ░░█████ ░░██████  █████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░      ░░░░░░   ░░░░░      ░░░░░      ░░░░░░   ░░░░░░     ░░░░░   ░░░░░░  ░░░░░
"""


def draw_effector_display(self: uiCore.Core, context):
    default.draw_effector_display(self, context)


"""
  █████████             █████                           █████
 ███░░░░░███           ░░███                           ░░███
░███    ░░░  █████ ████ ░███████      █████  █████ ████ ░███████
░░█████████ ░░███ ░███  ░███░░███    ███░░  ░░███ ░███  ░███░░███
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░░█████  ░███ ░███  ░███ ░███
 ███    ░███ ░███ ░███  ░███ ░███    ░░░░███ ░███ ░███  ░███ ░███
░░█████████  ░░████████ ████████     ██████  ░░████████ ████████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░     ░░░░░░    ░░░░░░░░ ░░░░░░░░
"""


def draw_advanced_cache(self: uiCore.Core, context):
    default.draw_advanced_cache(self, context)


def draw_advanced_gravity(self: uiCore.Core, context):
    default.draw_advanced_gravity(self, context)


"""
 ██████   ██████                       █████              ███████████
░░██████ ██████                       ░░███              ░░███░░░░░███
 ░███░█████░███   ██████   ████████   ███████    ██████   ░███    ░███ ████████   ██████
 ░███░░███ ░███  ░░░░░███ ░░███░░███ ░░░███░    ░░░░░███  ░██████████ ░░███░░███ ███░░███
 ░███ ░░░  ░███   ███████  ░███ ░███   ░███      ███████  ░███░░░░░░   ░███ ░░░ ░███ ░███
 ░███      ░███  ███░░███  ░███ ░███   ░███ ███ ███░░███  ░███         ░███     ░███ ░███
 █████     █████░░████████ ████ █████  ░░█████ ░░████████ █████        █████    ░░██████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░ ░░░░░    ░░░░░   ░░░░░░░░ ░░░░░        ░░░░░      ░░░░░░



"""


def draw_tools(self: uiCore.Core, context):
    ui.MantaPro_tools(self, context)


def draw_cache_tools(self: uiCore.Core, context):
    self.operator("mantapro.move_cache", icon="FILE_TICK",
                  settings=[["remove_dir", True]])
