# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####


import bpy

from ..Shared import ui, uiCore, modifiers, material, ui_textures


"""
 ██████   ██████            ███                    █████                                     ███
░░██████ ██████            ░░░                    ░░███                                     ░░░
 ░███░█████░███   ██████   ████  ████████       ███████   ██████  █████████████    ██████   ████  ████████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ███░░███  ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███    ░███ ░███ ░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███
 ░███      ░███  ███░░███  ░███  ░███ ░███    ░███ ░███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███
 █████     █████░░████████ █████ ████ █████   ░░████████░░██████  █████░███ █████░░████████ █████ ████ █████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░░░░  ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░
"""


def draw_domain(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    if modifier_settings:
        self.set_layout("col", align=True)
        self.operator("mantapro.switch_type",
                      icon="ARROW_LEFTRIGHT", settings=[["kind", "DOMAIN"]])

        self.set_layout("col", align=True)
        self.operator(
            "mantapro.toggle_bounds", icon="PIVOT_BOUNDBOX", settings=[["kind", "GAS"]])
        self.operator(
            "mantapro.display_bounds", icon="SHADING_BBOX", settings=[["kind", "GAS"]])

        self.separator()
        self.operator("mantapro.toggle_voxles_view", icon="MESH_GRID", text="Toggle Voxles")
        self.separator()

        self.set_layout("col", align=True)
        self.enabled(ui.get_baking(modifier_settings, "DATA"))

        self.prop(modifier_settings, "resolution_max")
        self.prop(modifier_settings, "time_scale")
        self.prop(modifier_settings, "clipping")

        self.ui_refresh()

        self.icon_prop(modifier_settings, "delete_in_obstacle")
        self.icon_prop(modifier_settings, "use_adaptive_domain")

        self.ui_refresh()

        self.prop(modifier_settings, "alpha")
        self.prop(modifier_settings, "beta")
        self.prop(modifier_settings, "burning_rate", text="Fire Speed")

        self.set_layout('col')
        self.prop(modifier_settings, "vorticity", text="Randomness")

        self.set_layout("col", align=True)
        self.icon_prop(modifier_settings, "use_dissolve_smoke")

        if modifier_settings.use_dissolve_smoke:
            self.prop(modifier_settings, "dissolve_speed")
            self.icon_prop(modifier_settings,
                           "use_dissolve_smoke_log", text="Slow")

        self.set_layout("col")
        self.enabled()
        self.prop(modifier_settings, "cache_frame_start")
        self.prop(modifier_settings, "cache_frame_end")

        self.separator(2)

        if modifier_settings.cache_type != "REPLAY":
            self.set_layout("row")
            self.force_disable(False)
            self.ui_layout.scale_y = 1
            self.icon_prop(domain.MantaPro, "locked_cache",
                           icon_on="LOCKED", icon_off="UNLOCKED", icon_only=False)

        self.set_layout("col")

        if domain.MantaPro.locked_cache and not modifier_settings.cache_type == "REPLAY":
            self.force_disable(True)

        self.label_prop(modifier_settings, "cache_type", text="Cache Type")
        self.icon_prop(modifier_settings, "cache_resumable")

        self.set_layout("col")
        ui.cache(self, modifier_settings, "GAS")
    else:
        self.set_layout("col")
        self.operator("mantapro_gas.make_domain", icon="PLUS")


"""
 ██████   ██████            ███                   ██████  ████
░░██████ ██████            ░░░                   ███░░███░░███
 ░███░█████░███   ██████   ████  ████████       ░███ ░░░  ░███   ██████  █████ ███ █████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ███████    ░███  ███░░███░░███ ░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███    ░░░███░     ░███ ░███ ░███ ░███ ░███ ░███
 ░███      ░███  ███░░███  ░███  ░███ ░███      ░███      ░███ ░███ ░███ ░░███████████
 █████     █████░░████████ █████ ████ █████     █████     █████░░██████   ░░████░████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░     ░░░░░  ░░░░░░     ░░░░ ░░░░
"""


def draw_flow(self: uiCore.Core, context):
    self.set_layout("col")
    obj = context.scene.MantaPro.active_flow

    if not obj or obj.type != "MESH":
        self.operator("mantapro_liquid.make_flow", icon="PLUS")
        self.operator("mantapro_gas.make_paint", icon="BRUSH_DATA")
        return

    if modifiers.check_type_gas(obj, "FLOW"):

        modifier_settings = modifiers.find_modifier(
            obj).flow_settings

        self.set_layout("col")
        self.operator("mantapro.switch_type",
                      icon="ARROW_LEFTRIGHT", settings=[["kind", "FLOW"]])

        self.separator()
        self.ui_refresh()
        self.label_prop(obj.MantaPro, "flow_type", text="Flow Type")

        if obj.MantaPro.flow_type != modifier_settings.flow_type:
            self.set_layout("row", align=True)
            self.alert()
            self.label(text="WARNING: flow type out of sync")
            self.operator("mantapro_gas.flow_sync",
                          icon="FILE_REFRESH", text="")

        ui.flow(self, modifier_settings)
        self.set_layout("col")

        if modifier_settings.flow_type != "FIRE":
            self.prop(modifier_settings, "smoke_color")

        self.ui_refresh()

        self.icon_prop(modifier_settings, "use_absolute",
                       icon_on="VOLUME_DATA", icon_off="OUTLINER_OB_VOLUME", text="Absolute Density")

        self.set_layout("col", align=True)

        if modifier_settings.flow_type != "FIRE":
            self.prop(modifier_settings, "temperature",
                      text="Initial Temperature")
            self.prop(modifier_settings, "density")

        if modifier_settings.flow_type != "SMOKE":
            self.prop(modifier_settings, "fuel_amount", text="Fuel")

    else:
        self.operator("mantapro_gas.make_flow", icon="PLUS")
        self.separator()

        self.operator("mantapro_gas.make_paint", icon="BRUSH_DATA")


"""
 ██████   ██████            ███                            ██████     ██████                     █████
░░██████ ██████            ░░░                            ███░░███   ███░░███                   ░░███
 ░███░█████░███   ██████   ████  ████████       ██████   ░███ ░░░   ░███ ░░░   ██████   ██████  ███████    ██████  ████████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ███░░███ ███████    ███████    ███░░███ ███░░███░░░███░    ███░░███░░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███    ░███████ ░░░███░    ░░░███░    ░███████ ░███ ░░░   ░███    ░███ ░███ ░███ ░░░
 ░███      ░███  ███░░███  ░███  ░███ ░███    ░███░░░    ░███       ░███     ░███░░░  ░███  ███  ░███ ███░███ ░███ ░███
 █████     █████░░████████ █████ ████ █████   ░░██████   █████      █████    ░░██████ ░░██████   ░░█████ ░░██████  █████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░░   ░░░░░      ░░░░░      ░░░░░░   ░░░░░░     ░░░░░   ░░░░░░  ░░░░░
"""


def draw_effector(self: uiCore.Core, context):
    ui.effector(self, context)


"""
 ██████████                                       ███                                   █████
░░███░░░░███                                     ░░░                                   ░░███
 ░███   ░░███  ██████  █████████████    ██████   ████  ████████       █████  █████ ████ ░███████   █████
 ░███    ░███ ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███     ███░░  ░░███ ░███  ░███░░███ ███░░
 ░███    ░███░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███    ░░█████  ░███ ░███  ░███ ░███░░█████
 ░███    ███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███     ░░░░███ ░███ ░███  ░███ ░███ ░░░░███
 ██████████  ░░██████  █████░███ █████░░████████ █████ ████ █████    ██████  ░░████████ ████████  ██████
░░░░░░░░░░    ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░    ░░░░░░    ░░░░░░░░ ░░░░░░░░  ░░░░░░
"""


def draw_noise(self: uiCore.Core, context):
    self.set_layout("col", align=True)

    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)
    self.enabled(ui.get_baking(modifier_settings, "NOISE"))

    if not modifier_settings.use_noise:
        self.enabled(False)
    # col = layout.column()
    self.prop(modifier_settings, "noise_scale",
              text="Noise Resolution")
    self.separator()
    self.prop(modifier_settings, "noise_strength")
    self.prop(modifier_settings, "noise_pos_scale")
    self.prop(modifier_settings, "noise_time_anim",
              text="Animaton Speed")


def draw_fire(self: uiCore.Core, context):
    self.set_layout("col")

    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.enabled(ui.get_baking(modifier_settings, "DATA"))

    self.set_layout("col")
    self.prop(modifier_settings, "flame_vorticity", text="Randomness")

    self.set_layout("col", align=True)
    self.prop(modifier_settings, "flame_max_temp", text="Max Temp")
    self.prop(modifier_settings, "flame_ignition", text="Min Temp")

    self.ui_refresh()
    self.prop(modifier_settings, "flame_smoke")

    self.separator()
    self.prop(modifier_settings, "flame_smoke_color",
              text="Flame's Smoke Color")


def draw_material(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain

    node = material.get_gas(domain)
    if node:

        has_multicolor = material.has_multicolor(domain)
        is_multicolor = material.is_multicolor(domain, node)

        has_flame = material.has_flame(domain)
        is_flame = material.is_flame(domain, node)

        if has_multicolor:
            self.set_layout("col")
            settings = self.operator(
                "mantapro_gas.multi_color", icon="COLOR", text="Multi Color")
            if is_multicolor:
                settings.remove = True
            else:
                settings.remove = False

        if has_flame:
            self.set_layout("col")
            settings = self.operator(
                "mantapro_gas.flame_plus", icon="COLORSET_02_VEC")
            if is_flame:
                settings.remove = True
            else:
                settings.remove = False
        flame = None
        if is_flame:
            flame = material.get_flame(domain, node)

        self.set_layout("col")

        if is_flame:
            self.material_prop(flame.inputs["Density"], "Density+")
        else:
            self.material_prop(node.inputs["Density"], text="Density")

        if is_flame:
            self.material_prop(flame.inputs["Fire"], "Fire+")
        else:
            self.material_prop(
                node.inputs["Blackbody Intensity"], text="Fire")

        if is_flame:
            self.material_prop(flame.inputs["Temperature"], "Temperature+")

            self.separator()

            self.material_prop(flame.inputs["Solid Flame"], "Solid Flame")
            self.material_prop(
                flame.inputs["Use Heat (Cycles only)"], "Use Heat (Cycles only)")
        else:
            self.material_prop(
                node.inputs["Temperature"], text="Temperature")

        self.ui_refresh()
        if not is_multicolor:
            self.material_prop(node.inputs["Color"], text="Color")
        self.material_prop(node.inputs["Blackbody Tint"], text="fire tint")

        if is_multicolor:
            multicolor = material.get_multicolor(domain, node)
            self.set_layout("col", align=True)
            self.label(text="Multicolor")
            self.material_prop(multicolor.inputs["Color1"], "")
            self.material_prop(multicolor.inputs["Color2"], "")

            self.ui_refresh()
            self.material_prop(
                multicolor.inputs["Noise Scale"], "noise scale")

            self.material_prop(
                multicolor.inputs["Noise Distortion"], "noise distrotion")

            self.set_layout("col")
            self.material_prop(multicolor.inputs["invert"], "invert")

            self.separator()
            self.material_prop(multicolor.inputs["hardness"], "hardness")

        if not has_flame or not has_multicolor:
            self.set_layout("col")
            self.operator("mantapro_gas.fix_material",
                          icon="TOOL_SETTINGS")
        if context.scene.render.engine == 'BLENDER_EEVEE':
            self.separator()
            self.ui_layout.popover(
                "RENDER_PT_eevee_volumetric", text="Eevee Volume", icon="VOLUME_DATA")

    else:
        self.set_layout("col")
        self.label(text="Material is not found or incorrect")
        self.operator("mantapro.fix_material",
                      icon="TOOL_SETTINGS", settings=[["kind", "GAS"]])


def draw_guides(self: uiCore.Core, context):
    self.set_layout("col")
    modifier_settings = modifiers.get_modifier_domain(
        context)
    self.enabled(ui.get_baking(modifier_settings, "DATA"))

    ui.guides(self, modifier_settings)


def draw_collections(self: uiCore.Core, context):
    modifier_settings = modifiers.get_modifier_domain(context)

    ui.collections(self, modifier_settings)


def draw_border(self: uiCore.Core, context):
    self.set_layout("col")
    modifier_settings = modifiers.get_modifier_domain(
        context)
    self.enabled(ui.get_baking(modifier_settings, "DATA"))

    ui.border_collisions(self, modifier_settings)


def draw_field(self: uiCore.Core, context):
    self.set_layout("col")
    modifier_settings = modifiers.get_modifier_domain(
        context)
    ui.field_weights(self, modifier_settings)


def draw_view(self: uiCore.Core, context):
    modifier_settings = modifiers.get_modifier_domain(context)

    self.set_layout("col")
    self.prop(modifier_settings, "display_thickness")
    self.label_prop(modifier_settings, "display_interpolation",
                    text="Interpolation")

    self.separator()

    self.set_layout("col", align=True)
    self.icon_prop(modifier_settings, "use_slice")
    if modifier_settings.use_slice:
        self.prop(modifier_settings, "slice_axis", text="")
        self.prop(modifier_settings, "slice_depth")
        if modifier_settings.display_interpolation == "CLOSEST":
            self.icon_prop(modifier_settings, "show_gridlines")

    self.set_layout("col", align=True)
    self.icon_prop(modifier_settings, "show_velocity")
    if modifier_settings.show_velocity:
        self.prop(modifier_settings, "vector_display_type", text="")
        self.prop(modifier_settings, "vector_field", text="")
        self.prop(modifier_settings, "vector_scale")

    self.separator()

    if not modifier_settings.use_slice:
        self.prop(modifier_settings, "slice_per_voxel")


"""
  █████████             █████           ██████  ████                                                                      ████
 ███░░░░░███           ░░███           ███░░███░░███                                                                     ░░███
░███    ░░░  █████ ████ ░███████      ░███ ░░░  ░███   ██████  █████ ███ █████    ████████   ██████   ████████    ██████  ░███   █████
░░█████████ ░░███ ░███  ░███░░███    ███████    ░███  ███░░███░░███ ░███░░███    ░░███░░███ ░░░░░███ ░░███░░███  ███░░███ ░███  ███░░
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░░░███░     ░███ ░███ ░███ ░███ ░███ ░███     ░███ ░███  ███████  ░███ ░███ ░███████  ░███ ░░█████
 ███    ░███ ░███ ░███  ░███ ░███     ░███      ░███ ░███ ░███ ░░███████████      ░███ ░███ ███░░███  ░███ ░███ ░███░░░   ░███  ░░░░███
░░█████████  ░░████████ ████████      █████     █████░░██████   ░░████░████       ░███████ ░░████████ ████ █████░░██████  █████ ██████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░      ░░░░░     ░░░░░  ░░░░░░     ░░░░ ░░░░        ░███░░░   ░░░░░░░░ ░░░░ ░░░░░  ░░░░░░  ░░░░░ ░░░░░░
                                                                                  ░███
                                                                                  █████
                                                                                 ░░░░░
"""


def draw_source(self: uiCore.Core, context):
    modifier_settings = modifier_settings = modifiers.find_modifier(
        context.scene.MantaPro.active_flow).flow_settings
    ui.flow_source(self, modifier_settings, context)


def draw_vertex_group(self: uiCore.Core, context):
    self.set_layout("col")
    modifier_settings = modifier_settings = modifiers.find_modifier(
        context.scene.MantaPro.active_flow).flow_settings
    self.prop_search(modifier_settings, "density_vertex_group",
                     context.scene.MantaPro.active_flow, "vertex_groups", text="Overide")

    self.operator("mantapro_gas.paint_start", icon="BRUSHES_ALL")


def draw_velocity(self: uiCore.Core, context):
    modifier_settings = modifiers.find_modifier(
        context.scene.MantaPro.active_flow).flow_settings
    ui.initial_velocity(self, modifier_settings)


def draw_texture(self: uiCore.Core, context):
    modifier_settings = modifiers.find_modifier(
        context.scene.MantaPro.active_flow).flow_settings
    if modifier_settings.use_texture:
        self.set_layout("col")
        self.operator("mantapro_gas.texture_setup", icon="FORCE_TEXTURE")

        self.ui_refresh()
        self.ui().template_ID_preview(
            modifier_settings, "noise_texture", hide_buttons=False)

        self.separator()
        self.prop(modifier_settings, "texture_map_type")

        self.ui_refresh()
        self.prop(modifier_settings, "texture_size")

        self.set_layout("row")
        self.prop(modifier_settings, "texture_offset")
        self.icon_prop(context.scene.MantaPro.active_flow.MantaPro, "animate_texture",
                       icon_on="DECORATE_DRIVER", icon_off="DECORATE",
                       icon_only=True)

        if context.scene.MantaPro.active_flow.MantaPro.animate_texture:
            self.set_layout("col")
            self.prop(context.scene.MantaPro.active_flow.MantaPro,
                      "animate_speed", slider=True)
    else:
        self.set_layout("col")
        self.label(text="Texture is disabled")


def draw_flow_display(self: uiCore.Core, context):
    ui.display_flow(self, context.scene.MantaPro.active_flow)


"""
  █████████             █████                    ██████     ██████                     █████                                                                  ████
 ███░░░░░███           ░░███                    ███░░███   ███░░███                   ░░███                                                                  ░░███
░███    ░░░  █████ ████ ░███████      ██████   ░███ ░░░   ░███ ░░░   ██████   ██████  ███████    ██████  ████████     ████████   ██████   ████████    ██████  ░███   █████
░░█████████ ░░███ ░███  ░███░░███    ███░░███ ███████    ███████    ███░░███ ███░░███░░░███░    ███░░███░░███░░███   ░░███░░███ ░░░░░███ ░░███░░███  ███░░███ ░███  ███░░
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░███████ ░░░███░    ░░░███░    ░███████ ░███ ░░░   ░███    ░███ ░███ ░███ ░░░     ░███ ░███  ███████  ░███ ░███ ░███████  ░███ ░░█████
 ███    ░███ ░███ ░███  ░███ ░███   ░███░░░    ░███       ░███     ░███░░░  ░███  ███  ░███ ███░███ ░███ ░███         ░███ ░███ ███░░███  ░███ ░███ ░███░░░   ░███  ░░░░███
░░█████████  ░░████████ ████████    ░░██████   █████      █████    ░░██████ ░░██████   ░░█████ ░░██████  █████        ░███████ ░░████████ ████ █████░░██████  █████ ██████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░      ░░░░░░   ░░░░░      ░░░░░      ░░░░░░   ░░░░░░     ░░░░░   ░░░░░░  ░░░░░         ░███░░░   ░░░░░░░░ ░░░░ ░░░░░  ░░░░░░  ░░░░░ ░░░░░░
                                                                                                                      ░███
                                                                                                                      █████
                                                                                                                     ░░░░░
"""


def draw_effector_display(self: uiCore.Core, context):
    ui.display(self, context.scene.MantaPro.active_effector)


"""
  █████████             █████                           █████                                                ████
 ███░░░░░███           ░░███                           ░░███                                                ░░███
░███    ░░░  █████ ████ ░███████      █████  █████ ████ ░███████     ████████   ██████   ████████    ██████  ░███   █████
░░█████████ ░░███ ░███  ░███░░███    ███░░  ░░███ ░███  ░███░░███   ░░███░░███ ░░░░░███ ░░███░░███  ███░░███ ░███  ███░░
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░░█████  ░███ ░███  ░███ ░███    ░███ ░███  ███████  ░███ ░███ ░███████  ░███ ░░█████
 ███    ░███ ░███ ░███  ░███ ░███    ░░░░███ ░███ ░███  ░███ ░███    ░███ ░███ ███░░███  ░███ ░███ ░███░░░   ░███  ░░░░███
░░█████████  ░░████████ ████████     ██████  ░░████████ ████████     ░███████ ░░████████ ████ █████░░██████  █████ ██████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░     ░░░░░░    ░░░░░░░░ ░░░░░░░░      ░███░░░   ░░░░░░░░ ░░░░ ░░░░░  ░░░░░░  ░░░░░ ░░░░░░
                                                                     ░███
                                                                     █████
                                                                    ░░░░░
"""


def draw_texture_settings(self: uiCore.Core, context):
    layout = self.layout
    modifier_settings = modifiers.find_modifier(
        context.scene.MantaPro.active_flow).flow_settings

    texture = modifier_settings.noise_texture

    ui_textures.ui(self, texture)


"""
 ███████████                       █████                                                       █████     █████     ███
░█░░░███░░░█                      ░░███                                                       ░░███     ░░███     ░░░
░   ░███  ░   ██████  █████ █████ ███████   █████ ████ ████████   ██████      █████   ██████  ███████   ███████   ████  ████████    ███████  █████
    ░███     ███░░███░░███ ░░███ ░░░███░   ░░███ ░███ ░░███░░███ ███░░███    ███░░   ███░░███░░░███░   ░░░███░   ░░███ ░░███░░███  ███░░███ ███░░
    ░███    ░███████  ░░░█████░    ░███     ░███ ░███  ░███ ░░░ ░███████    ░░█████ ░███████   ░███      ░███     ░███  ░███ ░███ ░███ ░███░░█████
    ░███    ░███░░░    ███░░░███   ░███ ███ ░███ ░███  ░███     ░███░░░      ░░░░███░███░░░    ░███ ███  ░███ ███ ░███  ░███ ░███ ░███ ░███ ░░░░███
    █████   ░░██████  █████ █████  ░░█████  ░░████████ █████    ░░██████     ██████ ░░██████   ░░█████   ░░█████  █████ ████ █████░░███████ ██████
   ░░░░░     ░░░░░░  ░░░░░ ░░░░░    ░░░░░    ░░░░░░░░ ░░░░░      ░░░░░░     ░░░░░░   ░░░░░░     ░░░░░     ░░░░░  ░░░░░ ░░░░ ░░░░░  ░░░░░███░░░░░░
                                                                                                                                   ███ ░███
                                                                                                                                  ░░██████
                                                                                                                                   ░░░░░░
"""


"""
class FlowTexturePreviewSub(bpy.types.Panel):
    bl_parent_id = "FlowTextureSettingsSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_label = "preview"
    bl_context = "objectmode"

    @ classmethod
    def poll(cls, context):
        if context.active_object:
            if modifiers.check_type_gas(context.active_object, "FLOW"):
                modifier_settings = modifiers.find_modifier(
                    context.active_object).flow_settings
                if modifier_settings.noise_texture:
                    return True
        return False

    def draw(self: uiCore.Core, context):
        layout = self.layout
        modifier_settings = modifiers.find_modifier(
            context.active_object).flow_settings

        texture = modifier_settings.noise_texture
        col = layout.column()
        col.template_ID_preview(
            modifier_settings, "noise_texture", hide_buttons=True)
"""


def draw_texture_color(self: uiCore.Core, context):
    self.set_layout('col')
    modifier_settings = modifiers.find_modifier(
        context.scene.MantaPro.active_flow).flow_settings

    texture = modifier_settings.noise_texture
    ui_textures.draw_color(self, texture)


"""
   █████████       █████                                                        █████                       █████
  ███░░░░░███     ░░███                                                        ░░███                       ░░███
 ░███    ░███   ███████  █████ █████  ██████   ████████    ██████   ██████   ███████      █████  █████ ████ ░███████
 ░███████████  ███░░███ ░░███ ░░███  ░░░░░███ ░░███░░███  ███░░███ ███░░███ ███░░███     ███░░  ░░███ ░███  ░███░░███
 ░███░░░░░███ ░███ ░███  ░███  ░███   ███████  ░███ ░███ ░███ ░░░ ░███████ ░███ ░███    ░░█████  ░███ ░███  ░███ ░███
 ░███    ░███ ░███ ░███  ░░███ ███   ███░░███  ░███ ░███ ░███  ███░███░░░  ░███ ░███     ░░░░███ ░███ ░███  ░███ ░███
 █████   █████░░████████  ░░█████   ░░████████ ████ █████░░██████ ░░██████ ░░████████    ██████  ░░████████ ████████
░░░░░   ░░░░░  ░░░░░░░░    ░░░░░     ░░░░░░░░ ░░░░ ░░░░░  ░░░░░░   ░░░░░░   ░░░░░░░░    ░░░░░░    ░░░░░░░░ ░░░░░░░░
"""


def draw_advanced_gas(self: uiCore.Core, context):
    self.set_layout("col", align=True)
    modifier_settings = modifiers.get_modifier_domain(
        context)

    self.enabled(ui.get_baking(modifier_settings, "DATA"))

    self.prop(modifier_settings, "cfl_condition")

    self.ui_refresh()
    self.icon_prop(modifier_settings, "use_adaptive_timesteps")

    if modifier_settings.use_adaptive_timesteps:
        self.prop(modifier_settings, "timesteps_max")
        self.prop(modifier_settings, "timesteps_min")


def draw_advanced_adaptive(self: uiCore.Core, context):
    self.set_layout("col", align=True)
    modifier_settings = modifiers.get_modifier_domain(
        context)
    self.enabled(ui.get_baking(modifier_settings, "DATA"))
    if not modifier_settings.use_adaptive_domain:
        self.label(text="Adaptive Domain is disabled")
        return

    self.ui_refresh()
    self.prop(modifier_settings, "additional_res", text="Add Resolution")
    self.prop(modifier_settings, "adapt_margin")

    self.set_layout("col")
    self.prop(modifier_settings, "adapt_threshold")


def draw_advanced_gravity(self: uiCore.Core, context):
    modifier_settings = modifiers.get_modifier_domain(
        context)
    ui.gravity(self, modifier_settings, context)
    self.set_layout("col")
    self.operator("mantapro_gas.restore_gravity", icon="FILE_REFRESH")


def draw_advanced_cache(self: uiCore.Core, context):
    self.set_layout("col")
    modifier_settings = modifiers.get_modifier_domain(
        context)
    self.operator("mantapro.move_cache", icon="FILE_TICK",
                  settings=[["remove_dir", True]])

    self.label_prop(modifier_settings, "cache_directory")

    self.set_layout("col", align=True, boxed=True)
    self.enabled(ui.get_baking(modifier_settings, "DATA"))
    self.label_prop(modifier_settings, "cache_data_format",
                    text="Data File Format")

    self.separator()
    self.enabled(ui.get_baking(modifier_settings, "NOISE"))
    if modifier_settings.use_noise:
        self.label_prop(modifier_settings, "cache_noise_format",
                        text="Noise File Format")

    self.separator()
    self.enabled(ui.get_baking(modifier_settings, "DATA"))
    self.label_prop(modifier_settings,
                    "openvdb_cache_compress_type", text="Compression Volumes")
    self.label_prop(modifier_settings, "openvdb_data_depth",
                    text="Precision Volumes")
