# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####


import bpy
from . import default
from ..Shared import ui, uiCore, modifiers, material, ui_textures


"""
 ██████   ██████            ███                    █████                                     ███
░░██████ ██████            ░░░                    ░░███                                     ░░░
 ░███░█████░███   ██████   ████  ████████       ███████   ██████  █████████████    ██████   ████  ████████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ███░░███  ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███    ░███ ░███ ░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███
 ░███      ░███  ███░░███  ░███  ░███ ░███    ░███ ░███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███
 █████     █████░░████████ █████ ████ █████   ░░████████░░██████  █████░███ █████░░████████ █████ ████ █████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░░░░  ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░
"""


def draw_domain(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    if modifier_settings:
        self.set_layout("col", align=True)
        self.operator(
            "mantapro.toggle_bounds", icon="PIVOT_BOUNDBOX", settings=[["kind", "GAS"]])
        self.operator(
            "mantapro.display_bounds", icon="SHADING_BBOX", settings=[["kind", "GAS"]])

        self.separator()

        self.set_layout("col", align=True)
        self.enabled(ui.get_baking(modifier_settings, "DATA"))

        self.prop(modifier_settings, "resolution_max", text="Quality / Scale")
        self.prop(modifier_settings, "time_scale", text="Speed")

        self.ui_refresh()

        self.icon_prop(modifier_settings, "delete_in_obstacle")
        # self.icon_prop(modifier_settings, "use_adaptive_domain")

        self.ui_refresh()

        self.prop(modifier_settings, "alpha", text="Smoke Speed")  # keep one
        # self.prop(modifier_settings, "beta")  # keep one
        self.prop(modifier_settings, "burning_rate", text="Fire Speed")

        self.set_layout('col')
        self.prop(modifier_settings, "vorticity", text="Randomness")

        self.set_layout("col", align=True)
        self.icon_prop(modifier_settings, "use_dissolve_smoke")

        if modifier_settings.use_dissolve_smoke:
            self.prop(modifier_settings, "dissolve_speed")

        self.set_layout("col")
        self.enabled()
        self.prop(modifier_settings, "cache_frame_start")
        self.prop(modifier_settings, "cache_frame_end")

        self.separator(2)

        if modifier_settings.cache_type != "REPLAY":
            self.set_layout("row")
            self.force_disable(False)
            self.ui_layout.scale_y = 1
            self.icon_prop(domain.MantaPro, "locked_cache",
                           icon_on="LOCKED", icon_off="UNLOCKED", icon_only=False)

        self.set_layout("col")

        if domain.MantaPro.locked_cache and not modifier_settings.cache_type == "REPLAY":
            self.force_disable(True)

        self.label_prop(modifier_settings, "cache_type", text="Cache Type")
        self.icon_prop(modifier_settings, "cache_resumable")

        self.set_layout("col")
        ui.cache(self, modifier_settings, "GAS")
    else:
        self.set_layout("col")
        self.operator("mantapro_gas.make_domain", icon="PLUS")


"""
 ██████   ██████            ███                   ██████  ████
░░██████ ██████            ░░░                   ███░░███░░███
 ░███░█████░███   ██████   ████  ████████       ░███ ░░░  ░███   ██████  █████ ███ █████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ███████    ░███  ███░░███░░███ ░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███    ░░░███░     ░███ ░███ ░███ ░███ ░███ ░███
 ░███      ░███  ███░░███  ░███  ░███ ░███      ░███      ░███ ░███ ░███ ░░███████████
 █████     █████░░████████ █████ ████ █████     █████     █████░░██████   ░░████░████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░     ░░░░░  ░░░░░░     ░░░░ ░░░░
"""


def draw_flow(self: uiCore.Core, context):
    self.set_layout("col")
    obj = context.scene.MantaPro.active_flow

    if not obj or obj.type != "MESH":
        self.operator("mantapro_liquid.make_flow", icon="PLUS")
        self.operator("mantapro_gas.make_paint", icon="BRUSH_DATA")
        return

    if modifiers.check_type_gas(obj, "FLOW"):

        modifier_settings = modifiers.find_modifier(
            obj).flow_settings

        self.separator()
        self.ui_refresh()
        self.label_prop(obj.MantaPro, "flow_type", text="Flow Type")

        if obj.MantaPro.flow_type != modifier_settings.flow_type:
            self.set_layout("row", align=True)
            self.alert()
            self.label(text="WARNING: flow type out of sync")
            self.operator("mantapro_gas.flow_sync",
                          icon="FILE_REFRESH", text="")

        ui.flow(self, modifier_settings)
        self.set_layout("col")

        if modifier_settings.flow_type != "FIRE":
            self.prop(modifier_settings, "smoke_color")

        self.ui_refresh()

        self.icon_prop(modifier_settings, "use_absolute",
                       icon_on="VOLUME_DATA", icon_off="OUTLINER_OB_VOLUME", text="Absolute Density")

        self.set_layout("col", align=True)

        if modifier_settings.flow_type != "FIRE":
            self.prop(modifier_settings, "temperature",
                      text="Upward Force")
            self.prop(modifier_settings, "density")

        if modifier_settings.flow_type != "SMOKE":
            self.prop(modifier_settings, "fuel_amount",
                      text="Ignition Strength")

    else:
        self.operator("mantapro_gas.make_flow", icon="PLUS")
        self.separator()

        self.operator("mantapro_gas.make_paint", icon="BRUSH_DATA")


"""
 ██████   ██████            ███                            ██████     ██████                     █████
░░██████ ██████            ░░░                            ███░░███   ███░░███                   ░░███
 ░███░█████░███   ██████   ████  ████████       ██████   ░███ ░░░   ░███ ░░░   ██████   ██████  ███████    ██████  ████████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ███░░███ ███████    ███████    ███░░███ ███░░███░░░███░    ███░░███░░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███    ░███████ ░░░███░    ░░░███░    ░███████ ░███ ░░░   ░███    ░███ ░███ ░███ ░░░
 ░███      ░███  ███░░███  ░███  ░███ ░███    ░███░░░    ░███       ░███     ░███░░░  ░███  ███  ░███ ███░███ ░███ ░███
 █████     █████░░████████ █████ ████ █████   ░░██████   █████      █████    ░░██████ ░░██████   ░░█████ ░░██████  █████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░░   ░░░░░      ░░░░░      ░░░░░░   ░░░░░░     ░░░░░   ░░░░░░  ░░░░░
"""


def draw_effector(self: uiCore.Core, context):
    default.draw_effector(self, context)


"""
 ██████████                                       ███                                   █████
░░███░░░░███                                     ░░░                                   ░░███
 ░███   ░░███  ██████  █████████████    ██████   ████  ████████       █████  █████ ████ ░███████   █████
 ░███    ░███ ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███     ███░░  ░░███ ░███  ░███░░███ ███░░
 ░███    ░███░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███    ░░█████  ░███ ░███  ░███ ░███░░█████
 ░███    ███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███     ░░░░███ ░███ ░███  ░███ ░███ ░░░░███
 ██████████  ░░██████  █████░███ █████░░████████ █████ ████ █████    ██████  ░░████████ ████████  ██████
░░░░░░░░░░    ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░    ░░░░░░    ░░░░░░░░ ░░░░░░░░  ░░░░░░
"""


def draw_noise(self: uiCore.Core, context):
    self.set_layout("col", align=True)

    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)
    self.enabled(ui.get_baking(modifier_settings, "NOISE"))

    if not modifier_settings.use_noise:
        self.enabled(False)
    # col = layout.column()
    self.prop(modifier_settings, "noise_scale",
              text="Noise Resolution")
    self.separator()
    self.prop(modifier_settings, "noise_strength")
    self.prop(modifier_settings, "noise_pos_scale")
    self.prop(modifier_settings, "noise_time_anim",
              text="Animaton Speed")


def draw_fire(self: uiCore.Core, context):
    self.set_layout("col")

    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.enabled(ui.get_baking(modifier_settings, "DATA"))

    self.set_layout("col")
    self.prop(modifier_settings, "flame_vorticity", text="Randomness")

    self.set_layout("col", align=True)
    self.prop(modifier_settings, "flame_max_temp", text="Speed")
    # self.prop(modifier_settings, "flame_ignition", text="Min Temp")

    self.ui_refresh()
    self.prop(modifier_settings, "flame_smoke", text="Smoke Amount")


def draw_material(self: uiCore.Core, context):
    default.draw_material(self, context)


def draw_guides(self: uiCore.Core, context):
    self.set_layout("col")
    modifier_settings = modifiers.get_modifier_domain(
        context)
    self.enabled(ui.get_baking(modifier_settings, "DATA"))

    ui.simple_guides(self, modifier_settings)


def draw_collections(self: uiCore.Core, context):
    default.draw_collections(self, context)


def draw_border(self: uiCore.Core, context):
    default.draw_border(self, context)


def draw_field(self: uiCore.Core, context):
    default.draw_field(self, context)


def draw_view(self: uiCore.Core, context):
    default.draw_view(self, context)


"""
  █████████             █████           ██████  ████                                                                      ████
 ███░░░░░███           ░░███           ███░░███░░███                                                                     ░░███
░███    ░░░  █████ ████ ░███████      ░███ ░░░  ░███   ██████  █████ ███ █████    ████████   ██████   ████████    ██████  ░███   █████
░░█████████ ░░███ ░███  ░███░░███    ███████    ░███  ███░░███░░███ ░███░░███    ░░███░░███ ░░░░░███ ░░███░░███  ███░░███ ░███  ███░░
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░░░███░     ░███ ░███ ░███ ░███ ░███ ░███     ░███ ░███  ███████  ░███ ░███ ░███████  ░███ ░░█████
 ███    ░███ ░███ ░███  ░███ ░███     ░███      ░███ ░███ ░███ ░░███████████      ░███ ░███ ███░░███  ░███ ░███ ░███░░░   ░███  ░░░░███
░░█████████  ░░████████ ████████      █████     █████░░██████   ░░████░████       ░███████ ░░████████ ████ █████░░██████  █████ ██████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░      ░░░░░     ░░░░░  ░░░░░░     ░░░░ ░░░░        ░███░░░   ░░░░░░░░ ░░░░ ░░░░░  ░░░░░░  ░░░░░ ░░░░░░
                                                                                  ░███
                                                                                  █████
                                                                                 ░░░░░
"""


def draw_source(self: uiCore.Core, context):
    default.draw_source(self, context)


def draw_vertex_group(self: uiCore.Core, context):
    default.draw_vertex_group(self, context)


def draw_velocity(self: uiCore.Core, context):
    default.draw_velocity(self, context)


def draw_texture(self: uiCore.Core, context):
    default.draw_texture(self, context)


def draw_flow_display(self: uiCore.Core, context):
    default.draw_flow_display(self, context)


"""
  █████████             █████                    ██████     ██████                     █████                                                                  ████
 ███░░░░░███           ░░███                    ███░░███   ███░░███                   ░░███                                                                  ░░███
░███    ░░░  █████ ████ ░███████      ██████   ░███ ░░░   ░███ ░░░   ██████   ██████  ███████    ██████  ████████     ████████   ██████   ████████    ██████  ░███   █████
░░█████████ ░░███ ░███  ░███░░███    ███░░███ ███████    ███████    ███░░███ ███░░███░░░███░    ███░░███░░███░░███   ░░███░░███ ░░░░░███ ░░███░░███  ███░░███ ░███  ███░░
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░███████ ░░░███░    ░░░███░    ░███████ ░███ ░░░   ░███    ░███ ░███ ░███ ░░░     ░███ ░███  ███████  ░███ ░███ ░███████  ░███ ░░█████
 ███    ░███ ░███ ░███  ░███ ░███   ░███░░░    ░███       ░███     ░███░░░  ░███  ███  ░███ ███░███ ░███ ░███         ░███ ░███ ███░░███  ░███ ░███ ░███░░░   ░███  ░░░░███
░░█████████  ░░████████ ████████    ░░██████   █████      █████    ░░██████ ░░██████   ░░█████ ░░██████  █████        ░███████ ░░████████ ████ █████░░██████  █████ ██████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░      ░░░░░░   ░░░░░      ░░░░░      ░░░░░░   ░░░░░░     ░░░░░   ░░░░░░  ░░░░░         ░███░░░   ░░░░░░░░ ░░░░ ░░░░░  ░░░░░░  ░░░░░ ░░░░░░
                                                                                                                      ░███
                                                                                                                      █████
                                                                                                                     ░░░░░
"""


def draw_effector_display(self: uiCore.Core, context):
    default.draw_effector_display(self, context)


"""
  █████████             █████                           █████                                                ████
 ███░░░░░███           ░░███                           ░░███                                                ░░███
░███    ░░░  █████ ████ ░███████      █████  █████ ████ ░███████     ████████   ██████   ████████    ██████  ░███   █████
░░█████████ ░░███ ░███  ░███░░███    ███░░  ░░███ ░███  ░███░░███   ░░███░░███ ░░░░░███ ░░███░░███  ███░░███ ░███  ███░░
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░░█████  ░███ ░███  ░███ ░███    ░███ ░███  ███████  ░███ ░███ ░███████  ░███ ░░█████
 ███    ░███ ░███ ░███  ░███ ░███    ░░░░███ ░███ ░███  ░███ ░███    ░███ ░███ ███░░███  ░███ ░███ ░███░░░   ░███  ░░░░███
░░█████████  ░░████████ ████████     ██████  ░░████████ ████████     ░███████ ░░████████ ████ █████░░██████  █████ ██████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░     ░░░░░░    ░░░░░░░░ ░░░░░░░░      ░███░░░   ░░░░░░░░ ░░░░ ░░░░░  ░░░░░░  ░░░░░ ░░░░░░
                                                                     ░███
                                                                     █████
                                                                    ░░░░░
"""


def draw_texture_settings(self: uiCore.Core, context):
    default.draw_texture_settings(self, context)


"""
 ███████████                       █████                                                       █████     █████     ███
░█░░░███░░░█                      ░░███                                                       ░░███     ░░███     ░░░
░   ░███  ░   ██████  █████ █████ ███████   █████ ████ ████████   ██████      █████   ██████  ███████   ███████   ████  ████████    ███████  █████
    ░███     ███░░███░░███ ░░███ ░░░███░   ░░███ ░███ ░░███░░███ ███░░███    ███░░   ███░░███░░░███░   ░░░███░   ░░███ ░░███░░███  ███░░███ ███░░
    ░███    ░███████  ░░░█████░    ░███     ░███ ░███  ░███ ░░░ ░███████    ░░█████ ░███████   ░███      ░███     ░███  ░███ ░███ ░███ ░███░░█████
    ░███    ░███░░░    ███░░░███   ░███ ███ ░███ ░███  ░███     ░███░░░      ░░░░███░███░░░    ░███ ███  ░███ ███ ░███  ░███ ░███ ░███ ░███ ░░░░███
    █████   ░░██████  █████ █████  ░░█████  ░░████████ █████    ░░██████     ██████ ░░██████   ░░█████   ░░█████  █████ ████ █████░░███████ ██████
   ░░░░░     ░░░░░░  ░░░░░ ░░░░░    ░░░░░    ░░░░░░░░ ░░░░░      ░░░░░░     ░░░░░░   ░░░░░░     ░░░░░     ░░░░░  ░░░░░ ░░░░ ░░░░░  ░░░░░███░░░░░░
                                                                                                                                   ███ ░███
                                                                                                                                  ░░██████
                                                                                                                                   ░░░░░░
"""


def draw_texture_color(self: uiCore.Core, context):
    default.draw_texture_color(self, context)


"""
   █████████       █████                                                        █████                       █████
  ███░░░░░███     ░░███                                                        ░░███                       ░░███
 ░███    ░███   ███████  █████ █████  ██████   ████████    ██████   ██████   ███████      █████  █████ ████ ░███████
 ░███████████  ███░░███ ░░███ ░░███  ░░░░░███ ░░███░░███  ███░░███ ███░░███ ███░░███     ███░░  ░░███ ░███  ░███░░███
 ░███░░░░░███ ░███ ░███  ░███  ░███   ███████  ░███ ░███ ░███ ░░░ ░███████ ░███ ░███    ░░█████  ░███ ░███  ░███ ░███
 ░███    ░███ ░███ ░███  ░░███ ███   ███░░███  ░███ ░███ ░███  ███░███░░░  ░███ ░███     ░░░░███ ░███ ░███  ░███ ░███
 █████   █████░░████████  ░░█████   ░░████████ ████ █████░░██████ ░░██████ ░░████████    ██████  ░░████████ ████████
░░░░░   ░░░░░  ░░░░░░░░    ░░░░░     ░░░░░░░░ ░░░░ ░░░░░  ░░░░░░   ░░░░░░   ░░░░░░░░    ░░░░░░    ░░░░░░░░ ░░░░░░░░
"""


def draw_advanced_gas(self: uiCore.Core, context):
    default.draw_advanced_gas(self, context)


def draw_advanced_adaptive(self: uiCore.Core, context):
    default.draw_advanced_adaptive(self, context)


def draw_advanced_gravity(self: uiCore.Core, context):
    default.draw_advanced_gravity(self, context)


def draw_advanced_cache(self: uiCore.Core, context):
    default.draw_advanced_cache(self, context)
