# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####

import bpy

from . import default, simplified, blender
from .. import preferences


def draw(self, context, function: str):
    """
    determain which ui mode to use and calls appropriate ui function accordingly

    self: UICore
    context: bpy.context
    function: str - the name of the ui function that is called
    """
    ui_type = preferences.get_preferences().ui_mode
    action = ui_type.lower() + "." + "draw_" + function + "(self, context)"
    exec(action)
