import bpy
import os
import bpy.utils.previews as previews

_pngs = ["domain_mixed", "domain_gas", "domain_liquid",
         "flow_mixed", "flow_gas_both", "flow_gas_fire", "flow_gas_smoke", "flow_liquid",
         "effector_mixed", "force_mixed",
         "ember"]


# We can store multiple preview collections here,
# however in this example we only store "main"
preview_collections = {}


def get_icon_id(name: str):
    if name in preview_collections["main"]:
        return preview_collections["main"][name].icon_id
    else:
        return 1


def register():

    # Note that preview collections returned by bpy.utils.previews
    # are regular py objects - you can use them to store custom data.
    pcoll = previews.new()

    # path to the folder where the icon is
    # the path is calculated relative to this py file inside the addon folder
    my_icons_dir = os.path.dirname(__file__)

    # load a preview thumbnail of a file and store in the previews collection
    for icon in _pngs:
        pcoll.load(icon, os.path.join(my_icons_dir, icon + ".png"), 'IMAGE')

    preview_collections["main"] = pcoll


def unregister():

    for pcoll in preview_collections.values():
        previews.remove(pcoll)
    preview_collections.clear()


if __name__ == "__main__":
    register()
