# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####


import bpy
from ... import Shared
from ...Shared import uiCore, ui_textures, modifiers, ui
from ...Shared import polls as P

from ... import preferences, Icons, QuickSetup

from .. import ui as ui_liquid
from ...Panels.domain import DomainSub
import os


"""
 ██████████                                       ███                 █████████             █████
░░███░░░░███                                     ░░░                 ███░░░░░███           ░░███
 ░███   ░░███  ██████  █████████████    ██████   ████  ████████     ░███    ░░░  █████ ████ ░███████   █████
 ░███    ░███ ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███    ░░█████████ ░░███ ░███  ░███░░███ ███░░
 ░███    ░███░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███     ░░░░░░░░███ ░███ ░███  ░███ ░███░░█████
 ░███    ███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███     ███    ░███ ░███ ░███  ░███ ░███ ░░░░███
 ██████████  ░░██████  █████░███ █████░░████████ █████ ████ █████   ░░█████████  ░░████████ ████████  ██████
░░░░░░░░░░    ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░  ░░░░░░
"""


class VIEW3D_PT_DomainParticelsSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "Particles"
    MP_order_id = 30
    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        domain = context.scene.MantaPro.active_domain
        pref = preferences.get_preferences()
        return Shared.modifiers.check_category(domain) == "LIQUID" and pref.ui_mode != 'BLENDER'

    def draw_header(self, context):
        layout = self.layout
        layout.label(icon="PARTICLES")

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "LIQUID":
            ui_liquid.draw(self, context, "particles")


class VIEW3D_PT_DomainParticelsCustomSub(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_DomainParticelsSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Custom"
    bl_context = "objectmode"
    MP_order_id = 31

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        domain = context.scene.MantaPro.active_domain
        ui = preferences.get_preferences().ui_mode
        return Shared.modifiers.check_category(domain) == "LIQUID" and ui != "SIMPLIFIED"

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        modifier_settings = Shared.modifiers.get_modifier_domain(domain=domain)
        if Shared.modifiers.check_category(domain) == "LIQUID":
            ui_liquid.draw(self, context, "custom_particle")


class VIEW3D_PT_AdvancedParticelsSub(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_DomainParticelsSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Advanced"
    bl_context = "objectmode"
    MP_order_id = 32

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        domain = context.scene.MantaPro.active_domain
        ui = preferences.get_preferences().ui_mode
        return Shared.modifiers.check_category(domain) == "LIQUID" and ui != "SIMPLIFIED"

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "LIQUID":
            ui_liquid.draw(self, context, "advanced_particle")


class VIEW3D_PT_AdvancedDiffusionSub(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_DomainAdvancedSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Diffusion"
    bl_context = "objectmode"
    MP_order_id = 68

    # bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        domain = context.scene.MantaPro.active_domain
        return Shared.modifiers.check_category(domain) == "LIQUID"

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "LIQUID":
            ui_liquid.draw(self, context, "advanced_diffusion")


class VIEW3D_PT_AdvancedLiquidSub(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_DomainAdvancedSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Liquid"
    bl_context = "objectmode"
    MP_order_id = 69

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        domain = context.scene.MantaPro.active_domain
        return Shared.modifiers.check_category(domain) == "LIQUID"

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "LIQUID":
            ui_liquid.draw(self, context, "advanced_liquid")


class VIEW3D_PT_AdvancedMeshSub(uiCore.Core, bpy.types.Panel):
    bl_parent_id = "VIEW3D_PT_DomainAdvancedSub"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_label = "Mesh"
    bl_context = "objectmode"
    MP_order_id = 70

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        domain = context.scene.MantaPro.active_domain
        return Shared.modifiers.check_category(domain) == "LIQUID"

    def draw(self, context):
        domain = context.scene.MantaPro.active_domain
        if Shared.modifiers.check_category(domain) == "LIQUID":
            ui_liquid.draw(self, context, "advanced_mesh")


"""
 ███████████  ████                          █████
░░███░░░░░███░░███                         ░░███
 ░███    ░███ ░███   ██████  ████████    ███████   ██████  ████████
 ░██████████  ░███  ███░░███░░███░░███  ███░░███  ███░░███░░███░░███
 ░███░░░░░███ ░███ ░███████  ░███ ░███ ░███ ░███ ░███████  ░███ ░░░
 ░███    ░███ ░███ ░███░░░   ░███ ░███ ░███ ░███ ░███░░░   ░███
 ███████████  █████░░██████  ████ █████░░████████░░██████  █████
░░░░░░░░░░░  ░░░░░  ░░░░░░  ░░░░ ░░░░░  ░░░░░░░░  ░░░░░░  ░░░░░



"""


class VIEW3D_PT_BlenderLiquid(uiCore.Core, bpy.types.Panel):
    bl_label = "Liquid"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    MP_order_id = 43

    bl_parent_id = "VIEW3D_PT_MantaPro"

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_LIQUID(context) and P.UI_BLENDER()

    def draw_header(self, context):
        domain = context.scene.MantaPro.active_domain
        modifier_settings = modifiers.get_modifier_domain(domain=domain)
        self.set_layout("row", align=True)
        self.prop(modifier_settings, "use_flip_particles", text="")

    def draw(self, context):
        ui_liquid.draw(self, context, "liquid")


class VIEW3D_PT_BlenderViscosity(uiCore.Core, bpy.types.Panel):
    bl_label = "Viscosity"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    bl_parent_id = "VIEW3D_PT_BlenderLiquid"
    MP_order_id = 45

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_LIQUID(context) and P.UI_BLENDER()

    def draw_header(self, context):
        domain = context.scene.MantaPro.active_domain
        modifier_settings = modifiers.get_modifier_domain(domain=domain)
        self.set_layout("row", align=True)
        self.enabled(ui.get_baking(modifier_settings, "ANY"))
        self.prop(modifier_settings, "use_viscosity", text="")

    def draw(self, context):
        ui_liquid.draw(self, context, "viscosity")


class VIEW3D_PT_BlenderDiffusion(uiCore.Core, bpy.types.Panel):
    bl_label = "Diffusion"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    bl_parent_id = "VIEW3D_PT_BlenderLiquid"
    MP_order_id = 46

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_LIQUID(context) and P.UI_BLENDER()

    def draw_header(self, context):
        domain = context.scene.MantaPro.active_domain
        modifier_settings = modifiers.get_modifier_domain(domain=domain)
        self.set_layout("row", align=True)
        self.enabled(ui.get_baking(modifier_settings, "ANY"))
        self.prop(modifier_settings, "use_diffusion", text="")

    def draw(self, context):
        ui_liquid.draw(self, context, "diffusion")


class VIEW3D_PT_BlenderParticles(uiCore.Core, bpy.types.Panel):
    bl_label = "Particles"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    bl_parent_id = "VIEW3D_PT_BlenderLiquid"
    MP_order_id = 47

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_LIQUID(context) and P.UI_BLENDER()

    def draw(self, context):
        ui_liquid.draw(self, context, "particles")


class VIEW3D_PT_BlenderMesh(uiCore.Core, bpy.types.Panel):
    bl_label = "Mesh"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    bl_parent_id = "VIEW3D_PT_BlenderLiquid"
    MP_order_id = 48

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_LIQUID(context) and P.UI_BLENDER()

    def draw_header(self, context):
        domain = context.scene.MantaPro.active_domain
        modifier_settings = modifiers.get_modifier_domain(domain=domain)
        self.set_layout("row", align=True)
        self.prop(modifier_settings, "use_mesh", text="")

    def draw(self, context):
        ui_liquid.draw(self, context, "mesh")


class VIEW3D_PT_DomainParticleBlenderToolsSub(uiCore.Core, DomainSub, bpy.types.Panel):
    bl_label = "MantaPro Tools"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "MantaPro"
    bl_context = "objectmode"
    bl_parent_id = "VIEW3D_PT_BlenderParticles"
    MP_order_id = 63

    bl_options = {"DEFAULT_CLOSED"}

    @ classmethod
    def poll(cls, context):
        return P.DOMAIN_LIQUID(context) and P.UI_BLENDER()

    def draw_header(self, context):
        self.set_layout("row")
        self.label(icon="TOOL_SETTINGS")

    def draw(self, context):
        ui_liquid.draw(self, context, "particle_tools")
