# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####

import bpy

from ..Shared import ui, uiCore, modifiers, material, particles

"""
 ██████   ██████            ███                ██████████                                       ███
░░██████ ██████            ░░░                ░░███░░░░███                                     ░░░
 ░███░█████░███   ██████   ████  ████████      ░███   ░░███  ██████  █████████████    ██████   ████  ████████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ░███    ░███ ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███     ░███    ░███░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███
 ░███      ░███  ███░░███  ░███  ░███ ░███     ░███    ███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███
 █████     █████░░████████ █████ ████ █████    ██████████  ░░██████  █████░███ █████░░████████ █████ ████ █████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░    ░░░░░░░░░░    ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░
"""


def draw_domain(self: uiCore.Core, context):

    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    if modifier_settings:
        self.set_layout("col", align=True)
        self.operator("mantapro.switch_type",
                      icon="ARROW_LEFTRIGHT", settings=[["kind", "DOMAIN"]])

        self.set_layout("col", align=True)
        self.operator(
            "mantapro.toggle_bounds", icon="PIVOT_BOUNDBOX", settings=[["kind", "FLUID"]])

        self.operator(
            "mantapro.display_bounds", icon="SHADING_BBOX", settings=[["kind", "FLUID"]])

        self.separator(0.5)
        self.operator("mantapro.toggle_voxles_view", icon="MESH_GRID", text="Toggle Voxles")
        self.separator()

        self.set_layout("col", align=True)
        self.enabled(ui.get_baking(modifier_settings, "DATA"))
        self.prop(
            modifier_settings, 'resolution_max')

        self.prop(modifier_settings, 'time_scale', text="Simulation Speed")

        self.ui_refresh()
        self.label_prop(modifier_settings, "simulation_method",
                        text="Simulation Method")
        self.ui_refresh()

        if modifier_settings.simulation_method == "FLIP":
            self.prop(modifier_settings, "flip_ratio")
        self.prop(modifier_settings, "sys_particle_maximum")
        self.prop(modifier_settings, 'particle_number',
                  text="Liquid Resolution")
        self.prop(modifier_settings, "particle_randomness")

        self.ui_refresh()

        self.icon_prop(modifier_settings,
                       "delete_in_obstacle", text="Delete in Obstacles")

        self.icon_prop(modifier_settings, "use_fractions")

        if modifier_settings.use_fractions:
            self.prop(modifier_settings,
                      "fractions_threshold", text="Threshold")
            self.prop(modifier_settings, "fractions_distance")

        self.icon_prop(modifier_settings, "use_viscosity")
        if modifier_settings.use_viscosity:
            self.prop(modifier_settings, "viscosity_value")

        self.set_layout("col")
        self.enabled(ui.get_baking(modifier_settings, "MESH"))

        self.icon_prop(modifier_settings, "use_speed_vectors")

        self.set_layout("col", align=True)
        self.prop(modifier_settings, 'mesh_scale')

        self.prop(modifier_settings, 'mesh_particle_radius',
                  text="Mesh Particle Radius")
        self.label_prop(modifier_settings, "mesh_generator",
                        text="Mesh Generator")

        self.ui_reset()
        self.prop(modifier_settings, "cache_frame_start",
                  text="Start frame")
        self.prop(modifier_settings, 'cache_frame_end', text="End frame")

        self.separator(2)

        if modifier_settings.cache_type != "REPLAY":
            self.set_layout("row")
            self.force_disable(False)
            self.ui_layout.scale_y = 1
            self.icon_prop(domain.MantaPro, "locked_cache",
                           icon_on="LOCKED", icon_off="UNLOCKED", icon_only=False)

        self.set_layout("col")

        if domain.MantaPro.locked_cache and not modifier_settings.cache_type == "REPLAY":
            self.force_disable(True)

        self.label_prop(modifier_settings, "cache_type", text="Cache Type")
        self.icon_prop(modifier_settings, "cache_resumable")

        self.separator()

        ui.cache(self, modifier_settings, "FLUID")

    else:
        self.set_layout("col")
        self.operator("mantapro_liquid.make_domain", icon="PLUS")
        # layout.label(text="Select Domain")


def draw_material(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    self.set_layout("col")
    if context.engine == "BLENDER_EEVEE":
        if not material.is_eevee_setup(context):
            self.operator("mantapro_liquid.setup_eevee", icon="SETTINGS")

        self.separator()

    volume_node, glass_node = material.get_liquid_nodes(domain)

    use_volume = context.engine != "BLENDER_EEVEE"

    if volume_node and glass_node:
        self.material_prop(glass_node.inputs["Roughness"], "Glass Roughness")

        self.set_layout("row")
        self.material_prop(glass_node.inputs["IOR"], "Glass IOR")
        self.operator("mantapro_liquid.ior_refrance", text="", icon="URL")

        self.set_layout("col")
        if use_volume:
            self.material_prop(volume_node.inputs["Density"], "Volume Density")

        self.material_prop(glass_node.inputs["Color"], "Glass Color")
        if use_volume:
            self.material_prop(volume_node.inputs["Color"], "Volume Color")

        if not use_volume:
            self.alert()
            self.label(text="Volume is Cycles ONLY")

        # update
        if material.need_update(domain, 1.1):
            self.set_layout("col")
            self.alert()
            self.label(text="This material has a newer version available")
            self.operator("mantapro.fix_material", icon="TOOL_SETTINGS", text="Update",
                          settings=[["kind", "LIQUID"]])
    else:
        self.set_layout("col")
        self.label(text="Material is not found or incorrect")
        self.operator("mantapro.fix_material", icon="TOOL_SETTINGS",
                      settings=[["kind", "LIQUID"]])


"""
 ██████   ██████            ███                   ██████  ████
░░██████ ██████            ░░░                   ███░░███░░███
 ░███░█████░███   ██████   ████  ████████       ░███ ░░░  ░███   ██████  █████ ███ █████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ███████    ░███  ███░░███░░███ ░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███    ░░░███░     ░███ ░███ ░███ ░███ ░███ ░███
 ░███      ░███  ███░░███  ░███  ░███ ░███      ░███      ░███ ░███ ░███ ░░███████████
 █████     █████░░████████ █████ ████ █████     █████     █████░░██████   ░░████░████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░     ░░░░░  ░░░░░░     ░░░░ ░░░░
"""


def draw_flow(self: uiCore.Core, context):
    self.set_layout("col")
    obj = context.scene.MantaPro.active_flow
    if modifiers.check_type_liquid(obj, "FLOW"):

        modifier_settings = modifiers.find_modifier(
            obj).flow_settings

        self.set_layout("col")
        self.operator("mantapro.switch_type",
                      icon="ARROW_LEFTRIGHT", settings=[["kind", "FLOW"]])
        self.separator()

        ui.flow(self, modifier_settings)


"""
 ██████   ██████            ███                            ██████     ██████                     █████
░░██████ ██████            ░░░                            ███░░███   ███░░███                   ░░███
 ░███░█████░███   ██████   ████  ████████       ██████   ░███ ░░░   ░███ ░░░   ██████   ██████  ███████    ██████  ████████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ███░░███ ███████    ███████    ███░░███ ███░░███░░░███░    ███░░███░░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███    ░███████ ░░░███░    ░░░███░    ░███████ ░███ ░░░   ░███    ░███ ░███ ░███ ░░░
 ░███      ░███  ███░░███  ░███  ░███ ░███    ░███░░░    ░███       ░███     ░███░░░  ░███  ███  ░███ ███░███ ░███ ░███
 █████     █████░░████████ █████ ████ █████   ░░██████   █████      █████    ░░██████ ░░██████   ░░█████ ░░██████  █████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░░   ░░░░░      ░░░░░      ░░░░░░   ░░░░░░     ░░░░░   ░░░░░░  ░░░░░

"""


def draw_effector(self: uiCore.Core, context):
    ui.effector(self, context)


"""
  █████████             █████        ██████████                                       ███
 ███░░░░░███           ░░███        ░░███░░░░███                                     ░░░
░███    ░░░  █████ ████ ░███████     ░███   ░░███  ██████  █████████████    ██████   ████  ████████
░░█████████ ░░███ ░███  ░███░░███    ░███    ░███ ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███
 ░░░░░░░░███ ░███ ░███  ░███ ░███    ░███    ░███░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███
 ███    ░███ ░███ ░███  ░███ ░███    ░███    ███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███
░░█████████  ░░████████ ████████     ██████████  ░░██████  █████░███ █████░░████████ █████ ████ █████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░     ░░░░░░░░░░    ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░
"""


def draw_particles(self: uiCore.Core, context):
    self.set_layout("col")
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)
    domain_settings = domain.MantaPro
    spray, foam, bubble = particles.find_particle(context)

    self.operator("mantapro_liquid.link_particles",
                  icon="LINKED", text="Link Default Particles")
    self.separator(2)

    self.set_layout("row", align=True)
    self.prop(modifier_settings, "use_spray_particles")
    self.prop(modifier_settings, "use_foam_particles")
    self.prop(modifier_settings, "use_bubble_particles")

    self.set_layout("col")

    self.icon_prop(domain_settings, "link_particle_size",
                   icon_on="LINKED", icon_off="UNLINKED")

    # particel scaling
    if domain_settings.link_particle_size:
        # linked scale
        self.ui_refresh()
        self.prop(domain_settings, "particle_size", slider=True)
    else:
        # unlinked scale
        self.set_layout("col", align=True)
        if modifier_settings.sndparticle_combined_export == "OFF":
            self.prop(domain_settings, "spray_size", slider=True)
            self.prop(domain_settings, "foam_size", slider=True)
            self.prop(domain_settings, "bubble_size", slider=True)
        elif modifier_settings.sndparticle_combined_export == "SPRAY_FOAM":
            self.prop(domain_settings, "bubble_size", slider=True)
            self.prop(domain_settings, "sprayfoam_size", slider=True)
        elif modifier_settings.sndparticle_combined_export == "SPRAY_BUBBLES":
            self.prop(domain_settings, "foam_size", slider=True)
            self.prop(domain_settings, "spraybubble_size", slider=True)
        elif modifier_settings.sndparticle_combined_export == "FOAM_BUBBLES":
            self.prop(domain_settings, "spray_size", slider=True)
            self.prop(domain_settings, "foambubble_size", slider=True)
        else:
            self.prop(domain_settings, "sprayfoambubble_size", slider=True)

    self.set_layout("col", align=True)

    # view amount
    systems = particles.get_sys(domain)
    for i in systems:
        self.prop(i, "display_percentage", slider=True,
                  text=particles.sys_to_name(i) + " Display Amount")

    self.separator(2)
    self.operator("mantapro_liquid.toggle_liquid_particles",
                  icon="VIS_SEL_10")

    self.set_layout("col", align=True)
    self.separator()

    if modifier_settings.use_spray_particles:
        if "Spray Particle System" in domain.modifiers:
            modifer = context.scene.MantaPro.active_domain.modifiers[
                "Spray Particle System"].particle_system.settings
            self.label_prop(modifer, "display_method", text="Spray Display")

    if modifier_settings.use_foam_particles:
        if "Foam Particle System" in domain.modifiers:
            modifer = context.scene.MantaPro.active_domain.modifiers[
                "Foam Particle System"].particle_system.settings
            self.label_prop(modifer, "display_method", text="Foam Display")

    if modifier_settings.use_bubble_particles:
        if "Bubble Particle System" in domain.modifiers:
            modifer = context.scene.MantaPro.active_domain.modifiers[
                "Bubble Particle System"].particle_system.settings
            self.label_prop(modifer, "display_method", text="Bubble Display")

    self.separator()
    self.operator("mantapro_liquid.quick_toggle_particles",
                  icon="PIVOT_ACTIVE")

    self.set_layout("col",)
    self.label()
    self.enabled(ui.get_baking(modifier_settings, "PARTICLE"))

    self.prop(modifier_settings, "particle_scale",
              text="Particle resolution")

    self.ui_refresh()

    self.set_layout("col", align=True)
    self.prop(modifier_settings, "sndparticle_life_max",
              text="Maximum Particel Lifetime")
    self.prop(modifier_settings, "sndparticle_life_min",
              text="Minimum Particel Lifetime")

    self.separator(2)

    self.label(text="Particels in Bounderis")
    self.prop(modifier_settings, "sndparticle_boundary", text="")


def draw_guides(self: uiCore.Core, context):
    self.set_layout("col")
    modifier_settings = modifiers.get_modifier_domain(
        context)
    self.enabled(ui.get_baking(modifier_settings, "DATA"))

    ui.guides(self, modifier_settings)


def draw_collections(self: uiCore.Core, context):
    modifier_settings = modifiers.get_modifier_domain(context)

    ui.collections(self, modifier_settings)


def draw_border(self: uiCore.Core, context):
    self.set_layout("col")
    modifier_settings = modifiers.get_modifier_domain(context)
    self.enabled(ui.get_baking(modifier_settings, "DATA"))

    ui.border_collisions(self, modifier_settings)


def draw_field(self: uiCore.Core, context):
    modifier_settings = modifiers.get_modifier_domain(
        context)
    ui.field_weights(self, modifier_settings)


def draw_view(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    self.set_layout("col")
    self.prop(modifier_settings, "display_thickness")
    self.label_prop(modifier_settings, "display_interpolation")
    self.separator(0.25)
    self.prop(modifier_settings, "slice_per_voxel")


"""
  █████████             █████           ██████  ████
 ███░░░░░███           ░░███           ███░░███░░███
░███    ░░░  █████ ████ ░███████      ░███ ░░░  ░███   ██████  █████ ███ █████
░░█████████ ░░███ ░███  ░███░░███    ███████    ░███  ███░░███░░███ ░███░░███
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░░░███░     ░███ ░███ ░███ ░███ ░███ ░███
 ███    ░███ ░███ ░███  ░███ ░███     ░███      ░███ ░███ ░███ ░░███████████
░░█████████  ░░████████ ████████      █████     █████░░██████   ░░████░████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░      ░░░░░     ░░░░░  ░░░░░░     ░░░░ ░░░░
"""


def draw_velocity(self: uiCore.Core, context):
    modifier_settings = modifiers.find_modifier(
        context.scene.MantaPro.active_flow).flow_settings
    ui.initial_velocity(self, modifier_settings)


def draw_source(self: uiCore.Core, context):
    layout = self.layout
    modifier_settings = modifiers.find_modifier(
        context.scene.MantaPro.active_flow).flow_settings
    ui.flow_source(self, modifier_settings)


def draw_flow_display(self: uiCore.Core, context):
    layout = self.layout
    ui.display_flow(self, context.scene.MantaPro.active_flow)


"""
  █████████             █████                    ██████     ██████                     █████
 ███░░░░░███           ░░███                    ███░░███   ███░░███                   ░░███
░███    ░░░  █████ ████ ░███████      ██████   ░███ ░░░   ░███ ░░░   ██████   ██████  ███████    ██████  ████████
░░█████████ ░░███ ░███  ░███░░███    ███░░███ ███████    ███████    ███░░███ ███░░███░░░███░    ███░░███░░███░░███
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░███████ ░░░███░    ░░░███░    ░███████ ░███ ░░░   ░███    ░███ ░███ ░███ ░░░
 ███    ░███ ░███ ░███  ░███ ░███   ░███░░░    ░███       ░███     ░███░░░  ░███  ███  ░███ ███░███ ░███ ░███
░░█████████  ░░████████ ████████    ░░██████   █████      █████    ░░██████ ░░██████   ░░█████ ░░██████  █████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░      ░░░░░░   ░░░░░      ░░░░░      ░░░░░░   ░░░░░░     ░░░░░   ░░░░░░  ░░░░░
"""


def draw_effector_display(self: uiCore.Core, context):
    layout = self.layout
    ui.display(self, context.scene.MantaPro.active_effector)


"""
  █████████             █████                           █████
 ███░░░░░███           ░░███                           ░░███
░███    ░░░  █████ ████ ░███████      █████  █████ ████ ░███████
░░█████████ ░░███ ░███  ░███░░███    ███░░  ░░███ ░███  ░███░░███
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░░█████  ░███ ░███  ░███ ░███
 ███    ░███ ░███ ░███  ░███ ░███    ░░░░███ ░███ ░███  ░███ ░███
░░█████████  ░░████████ ████████     ██████  ░░████████ ████████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░     ░░░░░░    ░░░░░░░░ ░░░░░░░░
"""


def draw_advanced_particle(self: uiCore.Core, context):
    self.set_layout("col", align=True)
    modifier_settings = modifiers.get_modifier_domain(
        context)
    self.enabled(ui.get_baking(modifier_settings, "PARTICLE"))

    self.prop(modifier_settings, "sndparticle_potential_max_wavecrest")
    self.prop(modifier_settings, "sndparticle_potential_min_wavecrest")

    self.ui_refresh()

    self.prop(modifier_settings, "sndparticle_potential_max_trappedair")
    self.prop(modifier_settings, "sndparticle_potential_min_trappedair")

    self.ui_refresh()

    self.prop(modifier_settings, "sndparticle_potential_max_energy")
    self.prop(modifier_settings, "sndparticle_potential_min_energy")

    self.ui_refresh()
    self.prop(modifier_settings, "sndparticle_potential_radius")
    self.prop(modifier_settings, "sndparticle_update_radius")

    self.ui_refresh()
    self.prop(modifier_settings, "sndparticle_sampling_wavecrest")
    self.prop(modifier_settings, "sndparticle_sampling_trappedair")

    self.ui_refresh()
    self.prop(modifier_settings, "sndparticle_bubble_buoyancy")
    self.prop(modifier_settings, "sndparticle_bubble_drag")


def draw_custom_particle(self: uiCore.Core, context):
    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)
    particle_sys = particles.get_sys(domain)
    self.set_layout("col", align=True)

    self.ui_reset()
    self.label_prop(
        modifier_settings, "sndparticle_combined_export", text="Comdined Export")
    self.separator(2)
    for i in particle_sys:
        self.set_layout("col", align=True, boxed=True)

        self.label("        " + particles.sys_to_name(i))
        self.label("Particles On Frame: " + str(i.count))
        self.separator()
        self.label_prop(i, "render_type", text="Render As")
        instance_type = i.render_type

        if instance_type == "OBJECT" or instance_type == "COLLECTION":
            self.separator()
            self.label_prop(i, "instance_" + instance_type.lower(),
                            text="Instance " + instance_type.capitalize())

        self.separator()
        self.label_prop(i, "display_method", text="Display As")
        self.prop(i, "display_percentage", text="View amount")


def draw_advanced_diffusion(self: uiCore.Core, context):
    self.set_layout("col", align=True)
    modifier_settings = modifiers.get_modifier_domain(
        context)
    self.enabled(ui.get_baking(modifier_settings, "ANY"))

    self.icon_prop(modifier_settings, "use_diffusion")

    #row.popover(panel="FLUIDpresets", icon="PRESET", text="")
    if modifier_settings.use_diffusion:
        self.ui_refresh()
        self.prop(modifier_settings, "viscosity_base")
        self.prop(modifier_settings, "viscosity_exponent")
        self.prop(modifier_settings, "surface_tension")


def draw_advanced_liquid(self: uiCore.Core, context):
    self.set_layout("col")
    modifier_settings = modifiers.get_modifier_domain(
        context)
    self.enabled(ui.get_baking(modifier_settings, "DATA"))

    self.prop(modifier_settings, "cfl_condition", text="CFL Number")

    self.set_layout("col", align=True)
    self.icon_prop(modifier_settings, "use_adaptive_timesteps")

    if modifier_settings.use_adaptive_timesteps:
        self.prop(modifier_settings, "timesteps_max",
                  text="Timesteps Maximum")
        self.prop(modifier_settings, "timesteps_min",
                  text="Timesteps Minimum")

    self.set_layout("col")
    self.prop(modifier_settings, "particle_radius")

    self.set_layout("col", align=True)
    self.prop(modifier_settings, "particle_max", text="Particle Maximum")
    self.prop(modifier_settings, "particle_min", text="Particle Minimum")

    self.set_layout("col")
    self.prop(modifier_settings, "particle_band_width",
              text="Narrow Band Width")


def draw_advanced_mesh(self: uiCore.Core, context):
    self.set_layout("col", align=True)
    modifier_settings = modifiers.get_modifier_domain(
        context)
    self.enabled(ui.get_baking(modifier_settings, "MESH"))

    self.icon_prop(modifier_settings, "use_mesh")

    self.ui_refresh()
    self.prop(modifier_settings, "mesh_smoothen_pos",
              text="Smoothing Positive")

    self.prop(modifier_settings, "mesh_smoothen_neg",
              text="Smoothing Negative")

    self.ui_refresh()
    self.prop(modifier_settings, "mesh_concave_upper",
              text="Concavity Upper")
    self.prop(modifier_settings, "mesh_concave_lower",
              text="Concavity Lower")


def draw_advanced_cache(self: uiCore.Core, context):
    self.set_layout("col", align=True)
    modifier_settings = modifiers.get_modifier_domain(
        context)

    s = modifier_settings.use_spray_particles
    f = modifier_settings.use_foam_particles
    b = modifier_settings.use_bubble_particles

    self.operator("mantapro.move_cache", icon="FILE_TICK",
                  settings=[["remove_dir", True]])

    self.label_prop(modifier_settings, "cache_directory")

    self.set_layout("col", align=True, boxed=True)
    self.enabled(ui.get_baking(modifier_settings, "DATA"))
    self.label_prop(modifier_settings, "cache_data_format",
                    text="Data File Format")

    # ######################Remove in 2.9+######################
    # self.label_prop(modifier_settings, "cache_particle_format",
    #          text="Particle File Format")
    # ######################Remove in 2.9+######################
    self.separator()
    self.enabled(ui.get_baking(modifier_settings, "MESH"))
    self.label_prop(modifier_settings, "cache_mesh_format",
                    text="Mesh File Format")


def draw_advanced_gravity(self: uiCore.Core, context):
    modifier_settings = modifiers.get_modifier_domain(
        context)

    ui.gravity(self, modifier_settings, context)
    self.set_layout("col")
    self.operator("mantapro_liquid.restore_gravity", icon="FILE_REFRESH")
