# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####

import bpy

from . import default
from ..Shared import ui, uiCore, modifiers, material, particles

"""
 ██████   ██████            ███                ██████████                                       ███
░░██████ ██████            ░░░                ░░███░░░░███                                     ░░░
 ░███░█████░███   ██████   ████  ████████      ░███   ░░███  ██████  █████████████    ██████   ████  ████████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ░███    ░███ ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███     ░███    ░███░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███
 ░███      ░███  ███░░███  ░███  ░███ ░███     ░███    ███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███
 █████     █████░░████████ █████ ████ █████    ██████████  ░░██████  █████░███ █████░░████████ █████ ████ █████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░    ░░░░░░░░░░    ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░
"""


def draw_domain(self: uiCore.Core, context):

    domain = context.scene.MantaPro.active_domain
    modifier_settings = modifiers.get_modifier_domain(domain=domain)

    if modifier_settings:
        self.set_layout("col", align=True)
        self.operator(
            "mantapro.toggle_bounds", icon="PIVOT_BOUNDBOX", settings=[["kind", "FLUID"]])

        self.operator(
            "mantapro.display_bounds", icon="SHADING_BBOX", settings=[["kind", "FLUID"]])

        self.separator()

        self.set_layout("col", align=True)
        self.enabled(ui.get_baking(modifier_settings, "DATA"))
        self.prop(modifier_settings, "resolution_max", text="Quality / Scale")
        self.prop(modifier_settings, "time_scale", text="Speed")

        self.ui_refresh()
        self.label_prop(modifier_settings, "simulation_method",
                        text="Simulation Method")
        self.ui_refresh()

        self.prop(modifier_settings, "flip_ratio", text="Splash Amount")
        self.prop(modifier_settings, 'particle_number',
                  text="Liquid Resolution")
        self.prop(modifier_settings, "particle_randomness")

        self.ui_refresh()

        self.icon_prop(modifier_settings,
                       "delete_in_obstacle", text="Delete in Obstacles")

        self.icon_prop(modifier_settings, "use_fractions")

        if modifier_settings.use_fractions:
            self.prop(modifier_settings, "fractions_threshold",
                      text="Friction Amount")

        self.icon_prop(modifier_settings, "use_viscosity", "Use Thickness")
        if modifier_settings.use_viscosity:
            self.prop(modifier_settings, "viscosity_value", "Thickness")

        self.set_layout("col")
        self.enabled(ui.get_baking(modifier_settings, "MESH"))

        self.icon_prop(modifier_settings, "use_speed_vectors")

        self.set_layout("col", align=True)

        self.label_prop(modifier_settings, "mesh_generator",
                        text="Mesh Generator")

        self.ui_reset()
        self.prop(modifier_settings, "cache_frame_start",
                  text="Start frame")
        self.prop(modifier_settings, 'cache_frame_end', text="End frame")

        self.separator(2)

        if modifier_settings.cache_type != "REPLAY":
            self.set_layout("row")
            self.force_disable(False)
            self.ui_layout.scale_y = 1
            self.icon_prop(domain.MantaPro, "locked_cache",
                           icon_on="LOCKED", icon_off="UNLOCKED", icon_only=False)

        self.set_layout("col")

        if domain.MantaPro.locked_cache and not modifier_settings.cache_type == "REPLAY":
            self.force_disable(True)

        self.label_prop(modifier_settings, "cache_type", text="Cache Type")
        self.icon_prop(modifier_settings, "cache_resumable")

        self.separator()

        ui.cache(self, modifier_settings, "FLUID")

    else:
        self.set_layout("col")
        self.operator("mantapro_liquid.make_domain", icon="PLUS")
        # layout.label(text="Select Domain")


def draw_material(self: uiCore.Core, context):
    default.draw_material(self, context)


"""
 ██████   ██████            ███                   ██████  ████
░░██████ ██████            ░░░                   ███░░███░░███
 ░███░█████░███   ██████   ████  ████████       ░███ ░░░  ░███   ██████  █████ ███ █████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ███████    ░███  ███░░███░░███ ░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███    ░░░███░     ░███ ░███ ░███ ░███ ░███ ░███
 ░███      ░███  ███░░███  ░███  ░███ ░███      ░███      ░███ ░███ ░███ ░░███████████
 █████     █████░░████████ █████ ████ █████     █████     █████░░██████   ░░████░████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░     ░░░░░  ░░░░░░     ░░░░ ░░░░
"""


def draw_flow(self: uiCore.Core, context):
    default.draw_flow(self, context)


"""
 ██████   ██████            ███                            ██████     ██████                     █████
░░██████ ██████            ░░░                            ███░░███   ███░░███                   ░░███
 ░███░█████░███   ██████   ████  ████████       ██████   ░███ ░░░   ░███ ░░░   ██████   ██████  ███████    ██████  ████████
 ░███░░███ ░███  ░░░░░███ ░░███ ░░███░░███     ███░░███ ███████    ███████    ███░░███ ███░░███░░░███░    ███░░███░░███░░███
 ░███ ░░░  ░███   ███████  ░███  ░███ ░███    ░███████ ░░░███░    ░░░███░    ░███████ ░███ ░░░   ░███    ░███ ░███ ░███ ░░░
 ░███      ░███  ███░░███  ░███  ░███ ░███    ░███░░░    ░███       ░███     ░███░░░  ░███  ███  ░███ ███░███ ░███ ░███
 █████     █████░░████████ █████ ████ █████   ░░██████   █████      █████    ░░██████ ░░██████   ░░█████ ░░██████  █████
░░░░░     ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░     ░░░░░░   ░░░░░      ░░░░░      ░░░░░░   ░░░░░░     ░░░░░   ░░░░░░  ░░░░░

"""


def draw_effector(self: uiCore.Core, context):
    default.draw_effector(self, context)


"""
  █████████             █████        ██████████                                       ███
 ███░░░░░███           ░░███        ░░███░░░░███                                     ░░░
░███    ░░░  █████ ████ ░███████     ░███   ░░███  ██████  █████████████    ██████   ████  ████████
░░█████████ ░░███ ░███  ░███░░███    ░███    ░███ ███░░███░░███░░███░░███  ░░░░░███ ░░███ ░░███░░███
 ░░░░░░░░███ ░███ ░███  ░███ ░███    ░███    ░███░███ ░███ ░███ ░███ ░███   ███████  ░███  ░███ ░███
 ███    ░███ ░███ ░███  ░███ ░███    ░███    ███ ░███ ░███ ░███ ░███ ░███  ███░░███  ░███  ░███ ░███
░░█████████  ░░████████ ████████     ██████████  ░░██████  █████░███ █████░░████████ █████ ████ █████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░     ░░░░░░░░░░    ░░░░░░  ░░░░░ ░░░ ░░░░░  ░░░░░░░░ ░░░░░ ░░░░ ░░░░░
"""


def draw_particles(self: uiCore.Core, context):
    default.draw_particles(self, context)


def draw_guides(self: uiCore.Core, context):
    default.draw_guides(self, context)


def draw_collections(self: uiCore.Core, context):
    default.draw_collections(self, context)


def draw_border(self: uiCore.Core, context):
    default.draw_border(self, context)


def draw_field(self: uiCore.Core, context):
    default.draw_field(self, context)


"""
  █████████             █████           ██████  ████
 ███░░░░░███           ░░███           ███░░███░░███
░███    ░░░  █████ ████ ░███████      ░███ ░░░  ░███   ██████  █████ ███ █████
░░█████████ ░░███ ░███  ░███░░███    ███████    ░███  ███░░███░░███ ░███░░███
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░░░███░     ░███ ░███ ░███ ░███ ░███ ░███
 ███    ░███ ░███ ░███  ░███ ░███     ░███      ░███ ░███ ░███ ░░███████████
░░█████████  ░░████████ ████████      █████     █████░░██████   ░░████░████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░      ░░░░░     ░░░░░  ░░░░░░     ░░░░ ░░░░
"""


def draw_velocity(self: uiCore.Core, context):
    default.draw_velocity(self, context)


def draw_source(self: uiCore.Core, context):
    default.draw_source(self, context)


def draw_flow_display(self: uiCore.Core, context):
    default.draw_flow_display(self, context)


"""
  █████████             █████                    ██████     ██████                     █████
 ███░░░░░███           ░░███                    ███░░███   ███░░███                   ░░███
░███    ░░░  █████ ████ ░███████      ██████   ░███ ░░░   ░███ ░░░   ██████   ██████  ███████    ██████  ████████
░░█████████ ░░███ ░███  ░███░░███    ███░░███ ███████    ███████    ███░░███ ███░░███░░░███░    ███░░███░░███░░███
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░███████ ░░░███░    ░░░███░    ░███████ ░███ ░░░   ░███    ░███ ░███ ░███ ░░░
 ███    ░███ ░███ ░███  ░███ ░███   ░███░░░    ░███       ░███     ░███░░░  ░███  ███  ░███ ███░███ ░███ ░███
░░█████████  ░░████████ ████████    ░░██████   █████      █████    ░░██████ ░░██████   ░░█████ ░░██████  █████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░      ░░░░░░   ░░░░░      ░░░░░      ░░░░░░   ░░░░░░     ░░░░░   ░░░░░░  ░░░░░
"""


def draw_effector_display(self: uiCore.Core, context):
    default.draw_effector_display(self, context)


"""
  █████████             █████                           █████
 ███░░░░░███           ░░███                           ░░███
░███    ░░░  █████ ████ ░███████      █████  █████ ████ ░███████
░░█████████ ░░███ ░███  ░███░░███    ███░░  ░░███ ░███  ░███░░███
 ░░░░░░░░███ ░███ ░███  ░███ ░███   ░░█████  ░███ ░███  ░███ ░███
 ███    ░███ ░███ ░███  ░███ ░███    ░░░░███ ░███ ░███  ░███ ░███
░░█████████  ░░████████ ████████     ██████  ░░████████ ████████
 ░░░░░░░░░    ░░░░░░░░ ░░░░░░░░     ░░░░░░    ░░░░░░░░ ░░░░░░░░
"""


def draw_advanced_particle(self: uiCore.Core, context):
    default.draw_advanced_particle(self, context)


def draw_custom_particle(self: uiCore.Core, context):
    default.draw_custom_particle(self, context)


def draw_advanced_diffusion(self: uiCore.Core, context):
    default.draw_advanced_diffusion(self, context)


def draw_advanced_cache(self: uiCore.Core, context):
    default.draw_advanced_cache(self, context)


def draw_advanced_gravity(self: uiCore.Core, context):
    default.draw_advanced_gravity(self, context)
