# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####

import bpy
import os

bl_info = {
    "name": "Cycles Optimizer",
    "author": "Reston Stanton",
    "description": "",
    "blender": (2, 92, 0),
    "version": (0, 0, 1),
    "location": "",
    "warning": "",
    "category": "Generic"
}

join = os.path.join

volume_presets = []
base_path = os.path.abspath(os.path.dirname(__file__))


def load_presets():
    for file in os.listdir(join(base_path, *("presets", "volume"))):
        volume_presets.append(file)


def convert_presets(category: list, kind: str):
    converted = []
    for i in range(len(category)):
        name = category[i][:-3]
        name = name[1:]
        identifier = name.upper()
        description = name + " " + kind + " Cycles Optimization"
        icon = "BLANK"
        number = i
        if name == "Default":
            name = "Default/High"
        converted.append((identifier, name, description, icon, number))
    return converted


def set_preset(preset: str, kind: str):
    path = join(base_path, *("presets", kind))
    preset = preset.capitalize() + ".py"

    for i in os.listdir(path):
        if preset == i[1:]:  # TODO allow for more then 10 presets
            preset = i
            break

    with open(join(path, preset), "r") as file:
        for i in file.readlines():
            exec(i)


def update_volume(self, context):
    set_preset(self.volume, "volume")


class PresetsProps(bpy.types.PropertyGroup):
    load_presets()

    volume: bpy.props.EnumProperty(name="Volume Quality", items=convert_presets(
        volume_presets, "Volume"), default="DEFAULT", update=update_volume)


class SCENE_PT_MantaProVolumeOptimizerUI(bpy.types.Panel):
    """Creates a Panel in the scene context of the properties editor"""
    bl_label = "Volume Optimizer"
    bl_space_type = 'PROPERTIES'
    bl_region_type = 'WINDOW'
    bl_context = "render"

    @ classmethod
    def poll(cls, context):
        return context.scene.render.engine == "CYCLES"

    def draw(self, context):
        props = context.scene.MantaPro_Cycles_Optimizer
        layout = self.layout
        layout.label(text="Volume Quality")
        col = layout.column()
        col.prop(props, "volume", text="")


"""
 ███████████                      ███           █████
░░███░░░░░███                    ░░░           ░░███
 ░███    ░███   ██████   ███████ ████   █████  ███████    ██████  ████████
 ░██████████   ███░░███ ███░░███░░███  ███░░  ░░░███░    ███░░███░░███░░███
 ░███░░░░░███ ░███████ ░███ ░███ ░███ ░░█████   ░███    ░███████  ░███ ░░░
 ░███    ░███ ░███░░░  ░███ ░███ ░███  ░░░░███  ░███ ███░███░░░   ░███
 █████   █████░░██████ ░░███████ █████ ██████   ░░█████ ░░██████  █████
░░░░░   ░░░░░  ░░░░░░   ░░░░░███░░░░░ ░░░░░░     ░░░░░   ░░░░░░  ░░░░░
                        ███ ░███
                       ░░██████
                        ░░░░░░
"""

classes = [PresetsProps, SCENE_PT_MantaProVolumeOptimizerUI]


def register():
    for i in classes:
        bpy.utils.register_class(i)
    bpy.types.Scene.MantaPro_Cycles_Optimizer = bpy.props.PointerProperty(
        type=PresetsProps)


def unregister():
    for i in classes:
        bpy.utils.unregister_class(i)
    del bpy.types.Scene.MantaPro_Cycles_Optimizer
