# Copyright (C) <2021>  <Reston Stanton>

# ##### BEGIN GPL LICENSE BLOCK #####
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTIBILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
# ##### END GPL LICENSE BLOCK #####
import bpy
from .domain import *
from .flow import *
from .effector import *
from .force import *
from .ember import *
from .other import *

from ..Liquid import Panels as Liquid_Panels
from ..Gas import Panels as Gas_Panels


def MP_order_id_sorter(item):
    return item.MP_order_id


classes = [
    OBJECT_UL_domains,
    OBJECT_UL_flows,
    OBJECT_UL_effector,
    OBJECT_UL_force,
    VIEW3D_PT_AutoOpsSettings,
    # domain
    VIEW3D_PT_MantaPro,
    VIEW3D_PT_MantaProDomain,

    # flow
    VIEW3D_PT_MantaProFlowMain,
    VIEW3D_PT_MantaProFlow,
    VIEW3D_PT_FlowSourceSub,
    # effector
    VIEW3D_PT_MantaProEffectorMain,
    VIEW3D_PT_MantaProEffector,
    VIEW3D_PT_EffectorDisplaySubGas,
    # force
    VIEW3D_PT_MantaProForceMain,
    VIEW3D_PT_MantaProForce,
    VIEW3D_PT_MantaProForceFalloff,
    VIEW3D_PT_MantaProForceKink,
    VIEW3D_PT_MantaProForceTexture,
    VIEW3D_PT_MantaProForceTextureSettings,
    VIEW3D_PT_ForceTextureColorSub,
    VIEW3D_PT_MantaProForceFalloffRadial,
    # advanced particle

    VIEW3D_PT_MantaProPanelPaint,
    VIEW3D_PT_SaveSetup,
    VIEW3D_PT_RemoveSetup,
    VIEW3D_PT_ExportImportSetup,
    VIEW3D_PT_ViewSetup,

    VIEW3D_PT_DomainMaterialSub,
    VIEW3D_PT_DomainGuidesSub,
    VIEW3D_PT_DomainCollectionsSub,
    VIEW3D_PT_DomainBorderSub,
    VIEW3D_PT_DomainFieldSub,
    VIEW3D_PT_DomainAdvancedSub,
    VIEW3D_PT_FlowVelocitySub,

    VIEW3D_PT_Viewport,
    VIEW3D_PT_ViewportSlice,
    VIEW3D_PT_ViewportGrid,
    VIEW3D_PT_ViewportVector,

    # blender

    VIEW3D_PT_DomainBorderBlenderSub,

    VIEW3D_PT_BlenderGuides,
    VIEW3D_PT_BlenderCollections,
    VIEW3D_PT_BlenderCache,
    VIEW3D_PT_BlenderCacheAdvanced,
    VIEW3D_PT_BlenderFieldWeights,
    VIEW3D_PT_BlenderViewport,
    VIEW3D_PT_BlenderViewportSlice,
    VIEW3D_PT_BlenderViewportGrid,
    VIEW3D_PT_BlenderViewportVector,

    VIEW3D_PT_DomainBlenderToolsSub,
    VIEW3D_PT_DomainMaterailBlenderToolsSub,
    VIEW3D_PT_CacheBlenderToolsSub,

    VIEW3D_PT_FlowSourceBlender,
    VIEW3D_PT_FlowVelocityBlender,

    VIEW3D_PT_AdvancedGravitySub,
    VIEW3D_PT_AdvancedCacheSub,
    VIEW3D_PT_FlowEmberSub,
    VIEW3D_PT_FlowDisplaySubGas,
    VIEW3D_PT_EmberSettingsSub,
    VIEW3D_PT_EmberParticleSub,
    VIEW3D_PT_EmberCustomParticleSub,
    VIEW3D_PT_EmberForceSub,
    VIEW3D_PT_EmberForceFalloffSub,
    VIEW3D_PT_EmberMaterialSub,
    VIEW3D_PT_EmberCacheSub,
    VIEW3D_PT_DEV, ]


liquid_classes = Liquid_Panels.get()
gas_classes = Gas_Panels.get()

classes.extend(liquid_classes)
classes.extend(gas_classes)

classes.sort(key=MP_order_id_sorter)


def get_new_order():
    """Used for the MP_orderer.py devtool"""
    print("\n\n")
    classes_dict = {}
    for i in range(0, len(classes)):
        classes_dict[str(classes[i].__name__)] = i

    print("classes = {")
    for i in classes_dict.keys():
        print("'" + i + "':", str(classes_dict[i]) + ",")
    print("}")
    print("\n\n")


def register():
    # get_new_order()

    base = os.path.abspath(os.path.dirname(__file__))
    file = os.path.join(os.path.dirname(base), "Preferences", "abreveate_tab")
    if os.path.exists(file):
        for i in classes:
            i.bl_category = "MP"
    for i in classes:
        bpy.utils.register_class(i)


def unregister():
    for i in classes:
        bpy.utils.unregister_class(i)
